//=============================================================================
// HXMapExit.
//
// MapExit transports you to the next map change bCollideActors to false 
// to make it triggered instead of touched.
//=============================================================================
class HXMapExit extends HXTriggers;

var() string DestMap;
var() bool bPlayTransition;
var() name CameraPathTag;

var() bool bItems; // Added for HXMapExit.

var transient bool bFired;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local MapExit OtherMapExit;

	Super.Succeeds( Other );

	// Special MapExit Init.
	OtherMapExit = MapExit(Other);
	if ( OtherMapExit!=None )
	{
		// MapExit.
		DestMap         = OtherMapExit.DestMap;
		bPlayTransition = OtherMapExit.bPlayTransition;
		CameraPathTag   = OtherMapExit.CameraPathTag;
	}
}

// ----------------------------------------------------------------------------
// LoadMap()
// ----------------------------------------------------------------------------

function LoadMap(Actor Other)
{
	local HXInterpolationDummy Dummy;
	local HXPlayerPawn Player;
	local HXGameInfo Game;
	local String NextURL;

	// Pointless?
	if ( Role<ROLE_Authority )
		return;

	// Check if we are already traveling.
	if ( bFired )
		return;
	bFired = True;

	Log( "MapExit activated (DestMap=" $ DestMap $ ",bItems=" $ bItems $ ").", 'MapExit' );

	// Set Portal explicit, because otherwise engine adds the old portal. Barf!
	NextURL = DestMap;
	if ( InStr(NextURL,"/")==-1 && InStr(NextURL,"#")==-1 )
		NextURL = NextURL $ "#";

	// Cool interpolation. Still needs to be fixed for clients.
	if ( bPlayTransition )
	{
		// Turn all Augs off.
		foreach AllActors( Class'HXPlayerPawn', Player )
			if ( Player.AugmentationSystem!=None )
				HXAugmentationManager(Player.AugmentationSystem).ForceDeactivateAll();

		// Dummy will call Level.ServerTravel(DestMap,bItems) at end of interpolation path.
		Dummy = Spawn( Class'HXInterpolationDummy' );
		if ( Dummy!=None )
		{
			Dummy.NextMap = NextURL;
			Dummy.bItems  = bItems;

			//HXRootWindow(Player.rootWindow).ClearWindowStack();
			PlayTransitionPath( Dummy );
			PlayDummyTransitionPath( Dummy );
			return;
		}
	}

	Level.ServerTravel( NextURL, bItems );
}

// ----------------------------------------------------------------------------
// Trigger()
// ----------------------------------------------------------------------------

function Trigger( Actor Other, Pawn Instigator )
{
	LoadMap( Other );
}

// ----------------------------------------------------------------------------
// Touch()
// ----------------------------------------------------------------------------

function Touch(Actor Other)
{
	LoadMap( Other );
}

// ----------------------------------------------------------------------------
// LoadMap()
// ----------------------------------------------------------------------------

function PlayDummyTransitionPath( HXInterpolationDummy Dummy )
{
	local InterpolationPoint InterpolationPoint;

	if ( Dummy!=None )
	{
		foreach AllActors( Class'InterpolationPoint', InterpolationPoint, CameraPathTag )
		{
			if ( InterpolationPoint.Position==0 )
			{
				Dummy.SetCollision( False, False, False );
				Dummy.bCollideWorld = False;
				Dummy.SetLocation( InterpolationPoint.Location );
				break;
			}
		}

		foreach AllActors( Class'InterpolationPoint', InterpolationPoint, CameraPathTag )
		{
			if ( InterpolationPoint.Position == 1)
			{
				Dummy.Target = InterpolationPoint;
				Dummy.SetPhysics(PHYS_Interpolating);
				Dummy.PhysRate       = 1.0;
				Dummy.PhysAlpha      = 0.0;
				Dummy.bInterpolating = True;
				Dummy.bStasis        = False;
				break;
			}
		}
	}
}

// ----------------------------------------------------------------------------
// PlayTransitionPath()
// ----------------------------------------------------------------------------

function PlayTransitionPath( Actor ServerDummy  )
{
	local HXPlayerPawn Player;
	local Pawn CurPawn;

	// Replicate.
	for ( CurPawn = Level.PawnList; CurPawn != None; CurPawn = CurPawn.NextPawn )
	{
		if ( CurPawn.bIsPlayer && CurPawn.IsA('HXPlayerPawn') )
		{
			Player = HXPlayerPawn(CurPawn);
			Player.bHidden = True;
			Player.KillShadow();
			Player.RemoveAllAdditionalViews();
			Player.AddAdditionalView( ServerDummy );
			Player.BroadcastInterpolationOptions( CameraPathTag, 1.0, 0.0, True );
		}
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	Texture=S_Teleport
	bCollideActors=False
	bItems=True
}
