//=============================================================================
// HXMapList.
//=============================================================================
class HXMapList extends Maplist;

var(HXMaps) globalconfig string HXMaps[32];
var globalconfig string HXMapSizes[32];
var globalconfig int HXMapNum;
var localized string HXCycleNames[10];

// NumTypes is the number of total cycle types
// Not using an enum because it is hard for other classes to access

var globalconfig int CycleType;
const MCT_STATIC = 0;
const MCT_RANDOM = 1;
const MCT_CYCLE = 2;

var int HXNumTypes;

function string GetNextMap()
{
	local string CurrentMap;
	local int HXNumMaps;
	local int i;

	CurrentMap = GetURLMap();
	if ( CurrentMap != "" )
	{
		//Strip off any .dx
		if ( Right(CurrentMap,3) ~= ".dx" )
			CurrentMap = Left(CurrentMap,Len(CurrentMap)-3);
		else
			CurrentMap = CurrentMap;

		for ( i=0; i<ArrayCount(HXMaps); i++ )
		{
			if ( CurrentMap ~= HXMaps[i] )
			{
				HXMapNum = i;
				break;
			}
		}
	}

	//Count number of HXMaps
	for (i = 0; ( (i < ArrayCount(HXMaps)) && (HXMaps[i] != "") ); i++);
	HXNumMaps = i;

	if (CycleType == MCT_STATIC)
	{
		HXMapNum = HXMapNum;
	}
	else if (CycleType == MCT_RANDOM)
	{
		HXMapNum = FRand() * HXNumMaps;
		if (HXMapNum >= HXNumMaps)
			HXMapNum = 0;
	}
	else if (CycleType == MCT_CYCLE)
	{
		HXMapNum++;
		if (HXMapNum >= HXNumMaps)
			HXMapNum = 0;
	}

	//save out our current HXMapNum
	SaveConfig();

	return HXMaps[HXMapNum];
}

defaultproperties
{
	HXMaps(0)="00_Intro"
	HXMaps(1)="00_Training"
	HXMaps(2)="01_NYC_UNATCOIsland"
	HXMaps(3)="02_NYC_BatteryPark"
	HXMaps(4)="03_NYC_UNATCOIsland"
	HXMaps(5)="04_NYC_UNATCOIsland"
	HXMaps(6)="05_NYC_UNATCOMJ12lab"
	HXMaps(7)="06_HongKong_Helibase"
	HXMaps(8)="08_NYC_Street"
	HXMaps(9)="09_NYC_Dockyard"
	HXMaps(10)="10_Paris_Catacombs"
	HXMaps(11)="11_Paris_Cathedral"
	HXMaps(12)="12_Vandenberg_Cmd"
	HXMaps(13)="14_Vandenberg_Sub"
	HXMaps(14)="15_Area51_Bunker"
	HXMaps(15)=""
	HXMaps(16)=""
	HXMaps(17)=""
	HXMaps(18)=""
	HXMaps(19)=""
	HXMaps(20)=""
	HXMaps(21)=""
	HXMaps(22)=""
	HXMaps(23)=""
	HXMaps(24)=""
	HXMapSizes(0)="(1-2)"
	HXMapSizes(1)="(1-2)"
	HXMapSizes(2)="(1-2)"
	HXMapSizes(3)="(1-2)"
	HXMapSizes(4)="(1-2)"
	HXMapSizes(5)="(1-2)"
	HXMapSizes(6)="(1-2)"
	HXMapSizes(7)="(1-2)"
	HXMapSizes(8)="(1-2)"
	HXMapSizes(9)="(1-2)"
	HXMapSizes(10)="(1-2)"
	HXMapSizes(11)="(1-2)"
	HXMapSizes(12)="(1-2)"
	HXMapSizes(13)="(1-2)"
	HXMapSizes(14)="(1-2)"
	HXMapSizes(15)="(1-2)"
	HXMapSizes(16)="(1-2)"
	HXMapSizes(17)="(1-2)"
	HXMapSizes(18)="(1-2)"
	HXMapSizes(19)="(1-2)"
	HXMapSizes(20)="(1-2)"
	HXMapSizes(21)="(1-2)"
	HXMapSizes(22)="(1-2)"
	HXMapSizes(23)="(1-2)"
	HXMapSizes(24)="(1-2)"
	HXCycleNames(0)="Repeat map"
	HXCycleNames(1)="Random map"
	HXCycleNames(2)="Loop maps"
	HXNumTypes=3
}
