//=============================================================================
// HXMasterServerLink
//
// Copy of DeusExGSpyLink to use own MenuScreenJoinGame class, and another
// place to use oldunreal masterserver instead of shutdown gamespy one.
//=============================================================================
class HXMasterServerLink extends HXBufferedTcpLink;

// Misc
var HXMenuScreenJoinGame		OwnerWindow;
var IpAddr					MasterServerIpAddr;
var bool					bOpened;

// Params
var string				MasterServerAddress;	// Address of the master server
var int						MasterServerTCPPort;	// Optional port that the master server is listening on
var int						MasterServerTimeout;
var string				BeaconProduct;
var int 					Region;					      // Region of the game server

// Error messages
var localized string		ResolveFailedError;
var localized string		TimeOutError;
var localized string		CouldNotConnectError;

// for WaitFor
const FoundSecureRequest = 1;
const FoundSecret        = 2;
const NextIP             = 3;
const NextAddress        = 4;

function BeginPlay()
{
	Disable('Tick');
	Super.BeginPlay();
}

function Start()
{
	ResetBuffer();
	
	MasterServerIpAddr.Port = MasterServerTCPPort;

	Log( Name $ ": BeaconProduct is " $ BeaconProduct, 'DevGameSpy' );

	Resolve( MasterServerAddress );
}

function DoBufferQueueIO()
{
	Super.DoBufferQueueIO();
}

function Resolved( IpAddr Addr )
{
	// Set the address
	MasterServerIpAddr.Addr = Addr.Addr;

	// Handle failure.
	if ( MasterServerIpAddr.Addr==0 )
	{
		Warn( Name $ ": Invalid master server address, aborting." );
		return;
	}

	// Display success message.
	Log( Name $ ": Master Server is "$MasterServerAddress$":"$MasterServerIpAddr.Port, 'DevGameSpy' );

	// Bind the local port.
	if( BindPort()==0 )
	{
		Warn( Name $ ": Error binding local port, aborting." );
		return;
	}

	Open( MasterServerIpAddr );
	SetTimer(MasterServerTimeout, False);
}

event Timer()
{
	if(!bOpened)
	{
		Warn( Name $ ": Couldn't connect to master server." );
		OwnerWindow.QueryFinished(False, CouldNotConnectError$MasterServerAddress);
		GotoState('Done');	
	}	
}

event Closed()
{
}

// Host resolution failue.
function ResolveFailed()
{
	Warn( Name $ ": Failed to resolve master server address, aborting." );
	OwnerWindow.QueryFinished(False, ResolveFailedError$MasterServerAddress);
	GotoState('Done');
}

event Opened()
{
	bOpened = True;
	Enable('Tick');

	WaitFor("\\basic\\\\secure\\", 5, FoundSecureRequest);
}

event Destroyed()
{
   OwnerWindow = None;
   Super.Destroyed();
}

function Tick(float DeltaTime)
{
	DoBufferQueueIO();
}


function HandleServer(string Text)
{
	local string	Address;
	local string	Port;

	Address = ParseDelimited(Text, ":", 1);
	Port = ParseDelimited(ParseDelimited(Text, ":", 2), "\\", 1);

	OwnerWindow.FoundServer(Address, int(Port), "", BeaconProduct);
}


function GotMatch(int MatchData)
{

	switch(MatchData)
	{
		case FoundSecureRequest:
			Enable('Tick');
			WaitForCount(6, 5, FoundSecret);
			break;
		case FoundSecret:
			Enable('Tick');
			SendBufferedData("\\gamename\\"$BeaconProduct$"\\location\\"$Region$"\\validate\\"$Validate(WaitResult, BeaconProduct)$"\\final\\");
			GotoState('FoundSecretState');
			break;
		case NextIP:
			Enable('Tick');
			if(WaitResult == "final\\")
			{
				OwnerWindow.QueryFinished(True);
				GotoState('Done');
			}
			else
				WaitFor("\\", 10, NextAddress);
			break;
		case NextAddress:
			Enable('Tick');
			HandleServer(WaitResult);
			WaitFor("\\", 5, NextIP);
			break;
		default:
			break;
	}
}

function GotMatchTimeout( int MatchData )
{
	Log( Name $ ": Timed out in master server protocol. Waiting for '" $ WaitingFor $ "' got '" $ InputBuffer $ "' in state" @ MatchData @ "(" $ MasterServerAddress $ ":" $ MasterServerTCPPort $ ")", 'DevGameSpy' );
	OwnerWindow.QueryFinished( False, TimeOutError );
	GotoState( 'Done' );
}

// States
state FoundSecretState 
{
	function Tick(float Delta)
	{
		Global.Tick(Delta);

		// Hack for 0 servers in server list
		if(!IsConnected() && WaitResult == "\\final\\")
		{
			OwnerWindow.QueryFinished(True);
			GotoState('Done');
		}
	}

Begin:
	Enable('Tick');
	SendBufferedData("\\list\\\\gamename\\"$BeaconProduct$"\\final\\");
	WaitFor("ip\\", 30, NextIP);
}

state Done
{
Begin:
	Disable('Tick');
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	ResolveFailedError="The master server could not be resolved: "
	TimeOutError="Timeout talking to the master server"
	CouldNotConnectError="Connecting to the master server timed out: "
	BeaconProduct="invalid"
}
