//=============================================================================
// HXMedicalBot.
//=============================================================================
class HXMedicalBot extends HXRobot;

var int HealAmount;
var int HealRefreshTime;

var float LastHealTime;

// ----------------------------------------------------------------------------
// Network replication.
// ----------------------------------------------------------------------------

replication
{
	reliable if ( bNetInitial && Role==ROLE_Authority )
		HealAmount, HealRefreshTime;

		//LastHealTime, HealRefreshTime;
}

// ----------------------------------------------------------------------------
// PostBeginPlay()
// ----------------------------------------------------------------------------

function PostBeginPlay()
{
	Super.PostBeginPlay();

	curFrobber = None;
	LastHealTime = -HealRefreshTime;
}

// ----------------------------------------------------------------------------
// Frob()
// ----------------------------------------------------------------------------

function Frob(Actor Frobber, Inventory frobWith)
{
	local HXPlayerPawn player;
	local float elapsed, delay;

	// Don't allow someone else to use the repairbot when already in use.
	if (curFrobber != None)
	{
		if (HXPlayerPawn(Frobber) != None)
			HXPlayerPawn(Frobber).ClientMessage(Sprintf(PawnInUseMsg,curFrobber.PlayerReplicationInfo.PlayerName));
		return;
	}

	Super.Frob(Frobber, frobWith);

	// DEUS_EX AMSD get player from frobber, not from getplayerpawn
	player = HXPlayerPawn(Frobber);

	if (player != None)
	{
		if (!bAnimating)
		{
			curFrobber = player;
			GotoState('On');
		}
	}
}

// ----------------------------------------------------------------------------
// state On
// ----------------------------------------------------------------------------

state On
{
	function Tick(float deltaTime)
	{
		Global.Tick(deltaTime);

		if (bOn)
		{
			//if ((PersonaScreen == None) && (Level.NetMode == NM_Standalone))
			//{
				//GotoState('Off');
			//}            
			if (curFrobber == None)
			{
				GotoState('Off');
			}
			else if (VSize(curFrobber.Location - Location) > 1500)
			{
				Log("Disabling medicalbot "$Self$" because user "$curFrobber$" was too far away");
				//Probably should be "GotoState('Off')" instead, but no good way to test, so I'll leave it alone.
				curFrobber = None;
			}
		}
	}

Begin:
	if (!bOn)
	{
		bAnimating = True;
		Acceleration=Vect(0, 0, 0);
		DesiredRotation=Rotation;
		PlaySound(sound'MedicalBotRaiseArm', SLOT_None);
		PlayAnim('Start');
		FinishAnim();
		bOn = True;
		bAnimating = False;
    TryInvoke();
	}
}

// ----------------------------------------------------------------------------
// state Off
// ----------------------------------------------------------------------------

state Off
{
Begin:
	if (bOn)
	{
		bAnimating = True;

		PlaySound(sound'RepairBotLowerArm', SLOT_None);
		PlayAnim('Stop');
		FinishAnim();

		bOn = False;
		bAnimating = False;
    curFrobber = None;

		FollowOrders();
	}
}

// ----------------------------------------------------------------------------
// TryInvoke()
// ----------------------------------------------------------------------------

function TryInvoke()
{
	if (IsInState('Off'))
		return;

	if (!Invoke())
	{
		GotoState('Off');
	}

	return;
}

// ----------------------------------------------------------------------------
// Invoke()
// ----------------------------------------------------------------------------

function bool Invoke()
{
	local HXPlayerPawn player;

	//if (PersonaScreen != None)
		//return False;

	player = curFrobber;

	if (player != None)
	{
		player.InvokeMedicalBot(self, LastHealTime, Level.TimeSeconds);
		SetOwner(Player);
	}

	return True;
}

// ----------------------------------------------------------------------------
// CloseOut()
// ----------------------------------------------------------------------------

function CloseOut()
{
	if (curFrobber != None)
		GotoState('Off');
}

// ----------------------------------------------------------------------------
// HealPlayer()
// ----------------------------------------------------------------------------

function int HealPlayer(DeusExPlayer player)
{
	local int healedPoints;

	if (player != None)
	{
		healedPoints = player.HealPlayer(healAmount);
		LastHealTime = Level.TimeSeconds;
		HXPlayerPawn(player).SetMedicalBotHealTime(self, LastHealTime, Level.TimeSeconds);
	}
	return healedPoints;
}

// ----------------------------------------------------------------------------
// CanHeal()
// 
// Returns whether or not the bot can heal the player
// ----------------------------------------------------------------------------

simulated function bool CanHeal()
{	
	return (Level.TimeSeconds-LastHealTime)>HealRefreshTime;
}

// ----------------------------------------------------------------------------
// GetRefreshTimeRemaining()
// ----------------------------------------------------------------------------

simulated function float GetRefreshTimeRemaining()
{
	return HealRefreshTime-(Level.TimeSeconds-LastHealTime);
}

// ----------------------------------------------------------------------------
// GetRefreshTimeRemaining()
// ----------------------------------------------------------------------------

simulated function float GetRefreshPercent()
{
	return 100.0*(1.0-GetRefreshTimeRemaining()/float(HealRefreshTime));
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	PawnInUseMsg="The MedicalBot is already in use by %s."
	bAlwaysRelevant=True 
	HealAmount=300
	HealRefreshTime=60
	WalkingSpeed=0.2
	GroundSpeed=200.0
	WaterSpeed=50.0
	AirSpeed=144.0
	AccelRate=500.0
	UnderWaterTime=20.0
	AttitudeToPlayer=ATTITUDE_Ignore
	DrawType=DT_Mesh
	Mesh=MedicalBot
	SoundRadius=16
	SoundVolume=128
	AmbientSound=MedicalBotMove
	CollisionRadius=25.00
	//CollisionHeight=36.31
	CollisionHeight=31.81
	Buoyancy=97.0
	BindName="MedicalBot"
	FamiliarName="Medical Bot"
	UnfamiliarName="Medical Bot"
}
