//=============================================================================
// HXMenuChoice_AdjustBrightness.
// 
// Finer grained control over brightness.
//=============================================================================
class HXMenuChoice_AdjustBrightness extends HXMenuUIChoiceSlider;

// ----------------------------------------------------------------------
// LoadSetting()
// ----------------------------------------------------------------------

function LoadSetting()
{
	SaveValue = float(Player.ConsoleCommand("GET" @ ConfigSetting) );

	Super.LoadSetting();
}

// ----------------------------------------------------------------------
// CancelSetting()
// ----------------------------------------------------------------------

function CancelSetting()
{
	Player.ConsoleCommand( "SET" @ ConfigSetting @ SaveValue );
	Player.ConsoleCommand( "UPDATEGAMMA" );
}

// ----------------------------------------------------------------------
// ResetToDefault()
// ----------------------------------------------------------------------

function ResetToDefault()
{
	Super.ResetToDefault();
	Player.ConsoleCommand("UPDATEGAMMA");
}

// ----------------------------------------------------------------------
// ScalePositionChanged() : Called when an ancestor scale window's
//                          position is moved
// ----------------------------------------------------------------------

event bool ScalePositionChanged( Window Scale, int NewTickPosition, float NewValue, bool bFinal )
{
	// Don't do anything while initializing as we get several 
	// ScalePositionChanged() events before LoadSetting() is called.
	if (bInitializing)
		return False;

	Player.ConsoleCommand( "SET" @ ConfigSetting @ GetValue() );
	Player.ConsoleCommand( "UPDATEGAMMA" );

	return False;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	numTicks=51
	endValue=1.000000
	defaultValue=0.500000
	choiceControlPosX=290
	actionText="|&Brightness"
	configSetting="ini:Engine.Engine.ViewportManager Brightness"
}
