//=============================================================================
// HXMenuChoice_AudioSubsystem.
// 
// Revision history:
//  * Base on HXMenuChoice_RenderDevice.
//=============================================================================
class HXMenuChoice_AudioSubsystem extends HXMenuUIChoiceAction;

var localized String PromptTitle;
var localized String GamePromptMessage; // Unused for now.
var localized String RestartPromptMessage;

// Info Button for RenderDevice.
var MenuUIInfoButtonWindow BtnInfo;
var int DefaultInfoWidth;
var int DefaultInfoPosX;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	CreateInfoButton();

	Super.InitWindow();

	UpdateInfoButton();
}

// ----------------------------------------------------------------------
// CreateInfoButton()
// ----------------------------------------------------------------------

function CreateInfoButton()
{
	BtnInfo = MenuUIInfoButtonWindow(NewChild(Class'MenuUIInfoButtonWindow'));

	BtnInfo.SetSelectability( False );
	BtnInfo.SetSize( DefaultInfoWidth, 19 );
	BtnInfo.SetPos( DefaultInfoPosX, 0 );
}

// ----------------------------------------------------------------------
// UpdateInfoButton()
// ----------------------------------------------------------------------

function UpdateInfoButton()
{
	local Object AudioSubsystemClass;

	// Figure out currently selected GameRenderDevice.
	AudioSubsystemClass = DynamicLoadObject( "ini:Engine.Engine.AudioDevice", Class'Class', True );
	if ( AudioSubsystemClass!=None && AudioSubsystemClass.Outer!=None )
		BtnInfo.SetButtonText( String(AudioSubsystemClass.Outer.Name) );
	else
		BtnInfo.SetButtonText( "n/a" );
}

// ----------------------------------------------------------------------
// ButtonActivated()
// ----------------------------------------------------------------------

function bool ButtonActivated( Window ButtonPressed )
{
	local DeusExLevelInfo Info;
	local HXRootWindow Root;

	Root = HXRootWindow(GetRootWindow());
	Info = player.GetLevelInfo();

	// If the game is running, first *PROMPT* the user, becauase
	// this will cause the game to quit and restart!!
	/*if ( Info!=None && Info.MissionNumber>=0 && !(Player.IsInState('Dying') || Player.IsInState('Paralyzed')) )
		Root.MessageBox( PromptTitle, GamePromptMessage, 0, False, Self );
	else*/
		Root.MessageBox( PromptTitle, RestartPromptMessage, 0, False, Self );

	return True;
}

// ----------------------------------------------------------------------
// BoxOptionSelected()
// ----------------------------------------------------------------------

event bool BoxOptionSelected(Window button, int buttonNumber)
{
	local HXRootWindow Root;

	Root = HXRootWindow(GetRootWindow());

	// Destroy the msgbox!  
	Root.PopWindow();

	if ( ButtonNumber==0 )
	{
		// First save any other changes the user made 
		// while in this menu before restarting the game!
		SaveMenuSettings();

		// Restart
		Player.ConsoleCommand( "Relaunch -ChangeAudio" );
	}
	return True;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	PromptTitle="Restart HX?"
	GamePromptMessage="In order to choose an audio subsystem, HX must be restarted.  The current game you are playing will be lost if you have not already saved it.  Do you still wish to restart?"
	RestartPromptMessage="In order to choose an audio subsystem, HX must be restarted.  Do you wish to proceed?"
	Action=MA_Custom
	HelpText="Select the audio subsystem for audio playback."
	ActionText="A|&udio Subsystem..."
	DefaultInfoWidth=83
	DefaultInfoPosX=270
}
