//=============================================================================
// HXMenuChoice_ColorBits.
// 
// Old MenuChoice_TextureColorBits. Changed because it does not actually
// affect the color bits of the Textures but of the Screen.
//=============================================================================
class HXMenuChoice_ColorBits extends MenuUIChoiceEnum;

var bool   bMessageDisplayed;
var String configSetting2;

var Localized String RestartTitle;
var Localized String RestartMessage;

// ----------------------------------------------------------------------
// LoadSetting()
// ----------------------------------------------------------------------

function LoadSetting()
{
	local int detailChoice;

	detailChoice = int(player.ConsoleCommand("get " $ configSetting));

	if (detailChoice == 16)
		SetValue(0);
	else
		SetValue(1);
}

// ----------------------------------------------------------------------
// SaveSetting()
// ----------------------------------------------------------------------

function SaveSetting()
{
	if (GetValue() == 0)
	{
		player.ConsoleCommand("set " $ configSetting $ " 16");
		player.ConsoleCommand("set " $ configSetting2 $ " 16");
	}
	else
	{
		player.ConsoleCommand("set " $ configSetting $ " 32");
		player.ConsoleCommand("set " $ configSetting2 $ " 32");
	}
}

// ----------------------------------------------------------------------
// CycleNextValue()
// ----------------------------------------------------------------------

function CycleNextValue()
{
	Super.CycleNextValue();

	if (!bMessageDisplayed)
	{
		HXRootWindow(GetRootWindow()).MessageBox(RestartTitle, RestartMessage, 1, False, Self);
		bMessageDisplayed = True;
	}
}

// ----------------------------------------------------------------------
// CyclePreviousValue()
// ----------------------------------------------------------------------

function CyclePreviousValue()
{
	Super.CyclePreviousValue();

	if (!bMessageDisplayed)
	{
		HXRootWindow(GetRootWindow()).MessageBox(RestartTitle, RestartMessage, 1, False, Self);
		bMessageDisplayed = True;
	}
}

// ----------------------------------------------------------------------
// BoxOptionSelected()
// ----------------------------------------------------------------------

event bool BoxOptionSelected(Window msgBoxWindow, int buttonNumber)
{
	// Destroy the msgbox!  
	HXRootWindow(GetRootWindow()).PopWindow();

	return True;
}

// ----------------------------------------------------------------------
// ResetToDefault()
// ----------------------------------------------------------------------

function ResetToDefault()
{
	LoadSetting();
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	configSetting="ini:Engine.Engine.ViewportManager FullscreenColorBits"
	configSetting2="ini:Engine.Engine.ViewportManager WindowedColorBits"
	RestartTitle="Texture Color Depth"
	RestartMessage="This change will not take effect until you restart HX."
	enumText(0)="16-bit"
	enumText(1)="32-bit"
	defaultInfoWidth=98
	HelpText="Determines the color depth.  32-bit look better if your hardware supports them."
	actionText="|&Color Depth"
}
