//=============================================================================
// HXMenuChoice_CombatDifficulty.
//=============================================================================
class HXMenuChoice_CombatDifficulty extends MenuUIChoiceEnum;

var localized String DifficultyNames[4]; //Human readable server mode names.

// ----------------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------------

event InitWindow()
{
	PopulateCombatDifficulties();

	Super.InitWindow();

	SetInitialCombatDifficulty();

	SetActionButtonWidth( 179 );
}

// ----------------------------------------------------------------------------
// PopulateCombatDifficulties()
// ----------------------------------------------------------------------------

function PopulateCombatDifficulties()
{
	local int modeIndex;

	for (modeIndex = 0; modeIndex < arrayCount(DifficultyNames); modeIndex++)
	{
		enumText[modeIndex]=DifficultyNames[modeIndex];
	}
}

// ----------------------------------------------------------------------------
// SetInitialCombatDifficulty()
// ----------------------------------------------------------------------------

function SetInitialCombatDifficulty()
{
	local int ModeSetting;

	ModeSetting = int(player.ConsoleCommand("get" @ configsetting));

	SetValue(ModeSetting);
}

// ----------------------------------------------------------------------------
// SaveSetting()
// ----------------------------------------------------------------------------

function SaveSetting()
{
   player.ConsoleCommand("set" @ configsetting @ currentValue);
}

// ----------------------------------------------------------------------------
// LoadSetting()
// ----------------------------------------------------------------------------

function LoadSetting()
{
   local int ModeSetting;

   ModeSetting = int(player.ConsoleCommand("get" @ configsetting));

   SetValue(ModeSetting);
}

// ----------------------------------------------------------------------------
// ResetToDefault
// ----------------------------------------------------------------------------

function ResetToDefault()
{   
   player.ConsoleCommand("set " $ configSetting $ " " $ defaultValue);
   LoadSetting();
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	DifficultyNames(0)="Easy"
	DifficultyNames(1)="Medium"
	DifficultyNames(2)="Hard"
	DifficultyNames(3)="Realistic"
	defaultValue=0
	defaultInfoWidth=243
	defaultInfoPosX=203
	HelpText="Select Combat Difficulty."
	actionText="Combat Difficulty"
	configSetting="HXMenuScreenHostGame CombatDifficulty"
}
