//=============================================================================
// HXMenuChoice_Connection
//=============================================================================
class HXMenuChoice_Connection extends MenuUIChoiceEnum;

var int										ConnectionSpeeds[8]; //Speeds (bytes per second) for connections
var localized String			ConnectionNames[8]; //Human readable connection speed names.

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	PopulateConnectionSpeeds();

	Super.InitWindow();

   SetInitialConnection();

   SetActionButtonWidth(153);

   btnAction.SetHelpText(HelpText);
}

// ----------------------------------------------------------------------
// PopulateConnectionSpeeds()
// ----------------------------------------------------------------------

function PopulateConnectionSpeeds()
{
	local int typeIndex;

   for (typeIndex = 0; typeIndex < arrayCount(ConnectionNames); typeIndex++)
   {
      enumText[typeIndex]=ConnectionNames[typeIndex];
   }
}

// ----------------------------------------------------------------------
// SetInitialConnection()
// ----------------------------------------------------------------------

function SetInitialConnection()
{
   local string TypeString;
   local int typeIndex;

   
   TypeString = player.ConsoleCommand("get" @ configsetting);
  
   for (typeIndex = 0; typeIndex < arrayCount(ConnectionNames); typeIndex++)
   {
      if (TypeString==GetModuleName(typeIndex))
         SetValue(typeIndex);
   }
}

// ----------------------------------------------------------------------
// SaveSetting()
// ----------------------------------------------------------------------

function SaveSetting()
{
   player.ConsoleCommand("set" @ configsetting @ GetModuleName(currentValue));
}

// ----------------------------------------------------------------------
// LoadSetting()
// ----------------------------------------------------------------------

function LoadSetting()
{
   local string TypeString;
   local int typeIndex;
   
   TypeString = player.ConsoleCommand("get" @ configsetting);

   for (typeIndex = 0; typeIndex < arrayCount(ConnectionNames); typeIndex++)
   {
      if (TypeString==GetModuleName(typeIndex))
         SetValue(typeIndex);
   }
}

// ----------------------------------------------------------------------
// ResetToDefault
// ----------------------------------------------------------------------

function ResetToDefault()
{   
   player.ConsoleCommand("set " $ configSetting $ " " $ GetModuleName(defaultValue));
   LoadSetting();
}

// ----------------------------------------------------------------------
// GetModuleName()
// For command line parsing
// ----------------------------------------------------------------------

function string GetModuleName(int ConnectionIndex)
{
   return (string(ConnectionSpeeds[ConnectionIndex]));
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	ConnectionSpeeds(0)=5000
	ConnectionSpeeds(1)=10000
	ConnectionSpeeds(2)=20000
	ConnectionSpeeds(3)=50000
	ConnectionSpeeds(4)=100000
	ConnectionSpeeds(5)=200000
	ConnectionSpeeds(6)=500000
	ConnectionSpeeds(7)=1000000
	ConnectionNames(0)="5 kb/s"
	ConnectionNames(1)="10 kb/s"
	ConnectionNames(2)="20 kb/s"
	ConnectionNames(3)="50 kb/s"
	ConnectionNames(4)="100 kb/s"
	ConnectionNames(5)="200 kb/s"
	ConnectionNames(6)="500 kb/s"
	ConnectionNames(7)="1000 kb/s"
	defaultInfoWidth=153
	defaultInfoPosX=170
	HelpText="Type of Internet Connection"
	actionText="Connection Type"
	configSetting="Player ConfiguredInternetSpeed"
}
