//=============================================================================
// HXMenuChoice_EffectsChannels
//
// Revision history:
//  * Use new ALAudio MaxEffectsChannels command.
//  * Increase the maximum for Galaxy to 32 as this is the real maximum of
//    Galaxy.
//=============================================================================
class HXMenuChoice_EffectsChannels extends HXMenuUIChoiceSlider;

// ----------------------------------------------------------------------
// InitWindow()
// ----------------------------------------------------------------------

event InitWindow()
{
	EndValue = float(GetRootWindow().ParentPawn.ConsoleCommand("MaxEffectsChannels"));
	// Assume Galaxy.
	if ( endValue<=0 )
		EndValue = 32;
	Super.InitWindow();
}

// ----------------------------------------------------------------------
// SetEnumerators()
// ----------------------------------------------------------------------

function SetEnumerators()
{
	local int EnumIndex;
	local int Counter;
	local int StepSize;

	StepSize   = (EndValue+0.5)/32.0;
	Counter    = 0;
	StartValue = Max(4,StepSize);
	NumTicks   = 33-(StartValue/StepSize);
	BtnSlider.SetTicks( NumTicks, StartValue, EndValue );
	for( EnumIndex=StartValue; EnumIndex<EndValue+1; EnumIndex=EnumIndex+StepSize )
		SetEnumeration( Counter++, EnumIndex );
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	numTicks=29
	startValue=4.000000
	endValue=32.000000
	defaultValue=16.000000
	HelpText="Number of sound effects channels"
	actionText="E|&ffects Channels"
	configSetting="ini:Engine.Engine.AudioDevice EffectsChannels"
}
