//=============================================================================
// HXMenuChoice_Episode.
//=============================================================================
class HXMenuChoice_Episode extends MenuUIChoiceEnum;

var HXMapList MapList;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();
 
	PopulateMapFiles();

	SetInitialMap();

	SetActionButtonWidth(179);
}

// ----------------------------------------------------------------------
// PopulateMapFiles()
// ----------------------------------------------------------------------

function PopulateMapFiles()
{
	local int typeIndex;

   MapList = player.Spawn(class'HXMapList');

   if (MapList == None)
   {
      return;
   }

   for (typeIndex = 0; ((typeIndex < arrayCount(MapList.HXMaps)) && (MapList.HXMaps[typeIndex] != "")); typeIndex++)
   {
      enumText[typeIndex] = MapList.HXMaps[typeIndex];
   }

   MapList.Destroy();
}

// ----------------------------------------------------------------------
// SetInitialGameType()
// ----------------------------------------------------------------------

function SetInitialMap()
{
   local int CurrentMapNum;

   CurrentMapNum = int(player.ConsoleCommand("get" @ configsetting));  

   SetValue(CurrentMapNum);
}

// ----------------------------------------------------------------------
// SaveSetting()
// ----------------------------------------------------------------------

function SaveSetting()
{
   player.ConsoleCommand("set" @ configsetting @ currentvalue);
}

// ----------------------------------------------------------------------
// LoadSetting()
// ----------------------------------------------------------------------

function LoadSetting()
{
   local int CurrentMapNum;
   
   CurrentMapNum = int(player.ConsoleCommand("get" @ configsetting));
   
   SetValue(CurrentMapNum);
}

// ----------------------------------------------------------------------
// ResetToDefault
// ----------------------------------------------------------------------

function ResetToDefault()
{   
   player.ConsoleCommand("set " $ configSetting $ " " $ defaultvalue);
   LoadSetting();
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	defaultInfoWidth=243
	defaultInfoPosX=203
	HelpText="Map on which to begin play."
	actionText="Map"
	configSetting="HXMapList HXMapNum"
}
