//=============================================================================
// HXMenuChoice_HRTF
//=============================================================================
class HXMenuChoice_HRTF extends MenuUIChoiceEnum;

var String ALAudioEnumText[3];

// ----------------------------------------------------------------------
// LoadSetting()
// ----------------------------------------------------------------------

function LoadSetting()
{
	local String Setting;
	local int i;

	Setting = Player.ConsoleCommand( "Get" @ ConfigSetting );

	for ( i=0; i<ArrayCount(ALAudioEnumText); i++ )
	{
		if ( ALAudioEnumText[i]==Setting )
		{
			SetValue( i );
			return;
		}	
	}

	SetValue( 0 );
}

// ----------------------------------------------------------------------
// SaveSetting()
// ----------------------------------------------------------------------

function SaveSetting()
{
	Player.ConsoleCommand( "Set" @ ConfigSetting @ ALAudioEnumText[GetValue()] );
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	EnumText(0)="Auto"
	EnumText(1)="On"
	EnumText(2)="Off"
	ALAudioEnumText(0)="Autodetect"
	ALAudioEnumText(1)="Enable"
	ALAudioEnumText(2)="Disable"
	DefaultInfoWidth=83
	HelpText="HRTF improves spatial perception by using using a decorrelation process."
	ActionText="|&HRTF"
	ConfigSetting="ini:Engine.Engine.AudioDevice UseHRTF"
}
