//=============================================================================
// HXMenuChoice_HostGameInfo.
//=============================================================================
class HXMenuChoice_HostGameInfo extends MenuUIChoiceEnum
	config;

// Dynamically loaded off int files.
var class<HXGameInfo> GameInfoClasses[40];

// ----------------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------------

event InitWindow()
{
	PopulateClassChoices();

	Super.InitWindow();

	SetInitialClass();

	SetActionButtonWidth( 179 );
}

// ----------------------------------------------------------------------------
// PopulateClassChoices()
// ----------------------------------------------------------------------------

function PopulateClassChoices()
{
	local string GameInfoClassString, GameInfoDescription;
	local Texture Portrait;
	local int iCandidate, iEnum;

	for ( iCandidate=0; iEnum<ArrayCount(EnumText); iCandidate++ )
	{
		GetRootWindow().ParentPawn.GetNextIntDesc( "HX.HXGameInfo", iCandidate, GameInfoClassString, GameInfoDescription );
		if ( GameInfoClassString=="" )
			break;

		GameInfoClasses[iEnum] = class<HXGameInfo>(DynamicLoadObject(GameInfoClassString,class'Class'));
		if ( GameInfoClasses[iEnum]==None )
			continue;

		// Work around missing description if needed.
		if ( GameInfoDescription=="" )
			EnumText[iEnum] = string(GameInfoClasses[iEnum].Name);
		else
			EnumText[iEnum] = GameInfoDescription;

		iEnum++;
	}

	// Some debug warnings.
	if ( iEnum==0 )
	{
		Warn( "Failed to load any GameInfo." );
	}
	else if ( iEnum==ArrayCount(GameInfoClasses) )
	{
		Warn( "Too many GameInfos." );
	}
}

// ----------------------------------------------------------------------------
// SetInitialClass()
// ----------------------------------------------------------------------------

function SetInitialClass()
{
	local string GameInfoClassString;
	local int iEnum;

	GameInfoClassString = player.ConsoleCommand("get" @ configsetting);

	for ( iEnum=0; iEnum<ArrayCount(EnumText); iEnum++ )
	{
		if ( GameInfoClassString==GetModuleName(iEnum) )
		{
			SetValue( iEnum );
			break;
		}
	}
}

// ----------------------------------------------------------------------------
// SaveSetting()
// ----------------------------------------------------------------------------

function SaveSetting()
{
	Player.ConsoleCommand( "SET" @ ConfigSetting @ GetModuleName(CurrentValue) );
}

// ----------------------------------------------------------------------------
// LoadSetting()
// ----------------------------------------------------------------------------

function LoadSetting()
{
	SetInitialClass();
}

// ----------------------------------------------------------------------------
// ResetToDefault
// ----------------------------------------------------------------------------

function ResetToDefault()
{   
	//Player.ConsoleCommand( "SET" @ GetModuleName(DefaultValue) );
	Player.ConsoleCommand( "SET" @ ConfigSetting @ "HX.HXGameInfo" );

	LoadSetting();
}

// ----------------------------------------------------------------------------
// GetModuleName()
//
// For command line parsing.
// ----------------------------------------------------------------------------

function string GetModuleName( int Index )
{
	return Sprintf("%s.%s",GameInfoClasses[Index].Outer.Name,GameInfoClasses[Index].Name);
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	DefaultInfoWidth=243
	DefaultInfoPosX=203
	HelpText="Type of game to play"
	ActionText="Game Type"
	ConfigSetting="HXMenuScreenHostGame CurrentGameType"
}
