//=============================================================================
// HXMenuChoice_PlayerClass.
//=============================================================================
class HXMenuChoice_PlayerClass extends MenuUIChoiceEnum
	config;

var Texture FallbackPortrait; // The Questionmark portrait.

// Dynamically loaded off int files.
var class<HXPlayerPawn> PlayerClasses[40];
var Texture             Portraits[40];

var ButtonWindow PortraitButton;

// ----------------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------------

event InitWindow()
{
	PopulateClassChoices();
	CreatePortraitButton();

	Super.InitWindow();

	SetInitialClass();

	SetActionButtonWidth( 153 );

	BtnAction.SetHelpText( HelpText );
	BtnInfo.SetPos( 0, 195 );
}

// ----------------------------------------------------------------------------
// PopulateClassChoices()
// ----------------------------------------------------------------------------

function PopulateClassChoices()
{
	local string PlayerClassString, PlayerDescription;
	local Texture Portrait;
	local int iCandidate, iEnum;

	for ( iCandidate=0; iEnum<ArrayCount(EnumText); iCandidate++ )
	{
		GetRootWindow().ParentPawn.GetNextIntDesc( "HX.HXPlayerPawn", iCandidate, PlayerClassString, PlayerDescription );
		if ( PlayerClassString=="" )
			break;

		PlayerClasses[iEnum] = class<HXPlayerPawn>(DynamicLoadObject(PlayerClassString,class'Class'));
		if ( PlayerClasses[iEnum]==None )
			continue;

		// Work around missing description if needed.
		if ( PlayerDescription=="" )
			EnumText[iEnum] = string(PlayerClasses[iEnum].Name);
		else
			EnumText[iEnum] = PlayerDescription;

		// Work around missing portrait if needed.
		if ( PlayerClasses[iEnum].default.Portrait==None )
			Portraits[iEnum] = FallbackPortrait;
		else
			Portraits[iEnum] = PlayerClasses[iEnum].default.Portrait;

		iEnum++;
	}

	// Some debug warnings.
	if ( iEnum==0 )
	{
		Warn( "Failed to load any PlayerClass." );
	}
	else if ( iEnum==ArrayCount(PlayerClasses) )
	{
		Warn( "Too many PlayerClasses." );
	}
}

// ----------------------------------------------------------------------------
// SetInitialClass()
// ----------------------------------------------------------------------------

function SetInitialClass()
{
	local string PlayerClassString;
	local int iEnum;

	PlayerClassString = Player.GetDefaultURL( "Class" );

	for ( iEnum=0; iEnum<ArrayCount(EnumText); iEnum++ )
	{
		if ( PlayerClassString==GetModuleName(iEnum) )
		{
			SetValue( iEnum );
			break;
		}
	}
}

// ----------------------------------------------------------------------------
// SetValue()
// ----------------------------------------------------------------------------

function SetValue( int InValue )
{
	Super.SetValue( InValue );

	UpdatePortrait();
}

// ----------------------------------------------------------------------------
// SaveSetting()
// ----------------------------------------------------------------------------

function SaveSetting()
{
	Player.UpdateURL( "Class", GetModuleName(CurrentValue), true );
	Player.SaveConfig();
}

// ----------------------------------------------------------------------------
// LoadSetting()
// ----------------------------------------------------------------------------

function LoadSetting()
{
	SetInitialClass();

	UpdatePortrait();
}

// ----------------------------------------------------------------------------
// ResetToDefault
// ----------------------------------------------------------------------------

function ResetToDefault()
{   
	//Player.UpdateURL( "Class", GetModuleName(DefaultValue), true );
	Player.UpdateURL( "Class", "HX.HXJCDentonPlayer", true );
	Player.SaveConfig();
	LoadSetting();
}

// ----------------------------------------------------------------------------
// GetModuleName()
//
// For command line parsing.
// ----------------------------------------------------------------------------

function string GetModuleName( int Index )
{
	return Sprintf("%s.%s",PlayerClasses[Index].Outer.Name,PlayerClasses[Index].Name);
}

// ----------------------------------------------------------------------------
// CreatePortraitButton()
// ----------------------------------------------------------------------------

function CreatePortraitButton()
{
	PortraitButton = ButtonWindow(NewChild(Class'ButtonWindow'));

	PortraitButton.SetSize( 116, 163 );
	PortraitButton.SetPos( 19, 27 );

	PortraitButton.SetBackgroundStyle( DSTY_Masked );
}

// ----------------------------------------------------------------------------
// UpdatePortrait()
// ----------------------------------------------------------------------------

function UpdatePortrait()
{
	PortraitButton.SetBackground( Portraits[CurrentValue] );
}

// ----------------------------------------------------------------------------
// CreateInfoButton()
// ----------------------------------------------------------------------------

function CreateInfoButton()
{
	BtnInfo = MenuUIInfoButtonWindow(NewChild(Class'MenuUIInfoButtonWindow'));

	BtnInfo.SetSelectability( false );
	BtnInfo.SetSize( DefaultInfoWidth, 19 );
	BtnInfo.SetPos( DefaultInfoPosX, 0 );
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	FallbackPortrait=menuplayersetupautoteam
	DefaultInfoWidth=153
	DefaultInfoPosX=170
	HelpText="Model for your character."
	ActionText="Model"
}
