//=============================================================================
// HXMenuChoice_RenderDevice.
//
// Revision history:
//  * Merged in parts of code out of MenuUIChoiceEnum to display the RenderDevice.
//=============================================================================
class HXMenuChoice_RenderDevice extends HXMenuUIChoiceAction;

var localized String PromptTitle;
var localized String GamePromptMessage; // Unused for now.
var localized String RestartPromptMessage;

// Info Button for RenderDevice.
var MenuUIInfoButtonWindow BtnInfo;
var int DefaultInfoWidth;
var int DefaultInfoPosX;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	CreateInfoButton();

	Super.InitWindow();

	UpdateInfoButton();
}

// ----------------------------------------------------------------------
// CreateInfoButton()
// ----------------------------------------------------------------------

function CreateInfoButton()
{
	BtnInfo = MenuUIInfoButtonWindow(NewChild(Class'MenuUIInfoButtonWindow'));

	BtnInfo.SetSelectability( False );
	BtnInfo.SetSize( DefaultInfoWidth, 19 );
	BtnInfo.SetPos( DefaultInfoPosX, 0 );
}

// ----------------------------------------------------------------------
// UpdateInfoButton()
// ----------------------------------------------------------------------

function UpdateInfoButton()
{
	local Object GameRenderDeviceClass;

	// TODO: Use GetCurrentRenderDevice command instead!
	// Figure out currently selected GameRenderDevice.
	GameRenderDeviceClass = DynamicLoadObject( "ini:Engine.Engine.GameRenderDevice", Class'Class', True );
	if ( GameRenderDeviceClass!=None && GameRenderDeviceClass.Outer!=None )
		BtnInfo.SetButtonText( String(GameRenderDeviceClass.Outer.Name) );
	else
		BtnInfo.SetButtonText( "n/a" );
}

// ----------------------------------------------------------------------
// ButtonActivated()
// ----------------------------------------------------------------------

function bool ButtonActivated( Window ButtonPressed )
{
	local DeusExLevelInfo Info;
	local HXRootWindow Root;

	Root = HXRootWindow(GetRootWindow());
	Info = player.GetLevelInfo();

	// If the game is running, first *PROMPT* the user, becauase
	// this will cause the game to quit and restart!!
	/*if ( Info!=None && Info.MissionNumber>=0 && !(Player.IsInState('Dying') || Player.IsInState('Paralyzed')) )
		Root.MessageBox( PromptTitle, GamePromptMessage, 0, False, Self );
	else*/
		Root.MessageBox( PromptTitle, RestartPromptMessage, 0, False, Self );

	return True;
}

// ----------------------------------------------------------------------
// BoxOptionSelected()
// ----------------------------------------------------------------------

event bool BoxOptionSelected(Window button, int buttonNumber)
{
	local HXRootWindow Root;

	Root = HXRootWindow(GetRootWindow());

	// Destroy the msgbox!  
	Root.PopWindow();

	if ( ButtonNumber==0 )
	{
		// First save any other changes the user made 
		// while in this menu before restarting the game!
		SaveMenuSettings();

		// Restart
		Player.ConsoleCommand( "Relaunch -ChangeVideo" );
	}
	return True;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	PromptTitle="Restart HX?"
	GamePromptMessage="In order to choose a render device, HX must be restarted.  The current game you are playing will be lost if you have not already saved it.  Do you still wish to restart?"
	RestartPromptMessage="In order to choose a render device, HX must be restarted.  Do you wish to proceed?"
	Action=MA_Custom
	HelpText="Select the device to use for 3D rendering.  HX must EXIT to allow you to select a 3D hardware device."
	ActionText="Rendering |&Device..."
	DefaultInfoWidth=98
	DefaultInfoPosX=270
}
