//=============================================================================
// HXMenuChoice_StartingAugsBonus.
//=============================================================================
class HXMenuChoice_StartingAugsBonus extends MenuUIChoiceEnum;

var localized String MissionNames[16];

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	PopulateStartingAugs();

	Super.InitWindow();

	SetInitialStartingAugs();

	SetActionButtonWidth(179);
}


// ----------------------------------------------------------------------
// PopulateStartingAugs()
// ----------------------------------------------------------------------

function PopulateStartingAugs()
{
	local int modeIndex;

	for (modeIndex = 0; modeIndex < arrayCount(MissionNames); modeIndex++)
	{
		enumText[modeIndex]=MissionNames[modeIndex];
	}
}

// ----------------------------------------------------------------------
// SetInitialStartingAugs()
// ----------------------------------------------------------------------

function SetInitialStartingAugs()
{
	local int ModeSetting;

	ModeSetting = int(player.ConsoleCommand("get" @ configsetting));

	SetValue(ModeSetting);
}

// ----------------------------------------------------------------------
// SaveSetting()
// ----------------------------------------------------------------------

function SaveSetting()
{
   player.ConsoleCommand("set" @ configsetting @ currentValue);
}

// ----------------------------------------------------------------------
// LoadSetting()
// ----------------------------------------------------------------------

function LoadSetting()
{
   local int ModeSetting;

   ModeSetting = int(player.ConsoleCommand("get" @ configsetting));

   SetValue(ModeSetting);
}

// ----------------------------------------------------------------------
// ResetToDefault
// ----------------------------------------------------------------------

function ResetToDefault()
{   
   player.ConsoleCommand("set " $ configSetting $ " " $ defaultValue);
   LoadSetting();
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	MissionNames(0)="Mission 00"
	MissionNames(1)="Mission 01"
	MissionNames(2)="Mission 02"
	MissionNames(3)="Mission 03"
	MissionNames(4)="Mission 04"
	MissionNames(5)="Mission 05"
	MissionNames(6)="Mission 06"
	MissionNames(7)="Mission 08"
	MissionNames(8)="Mission 09"
	MissionNames(9)="Mission 10"
	MissionNames(10)="Mission 11"
	MissionNames(11)="Mission 12"
	MissionNames(12)="Mission 14"
	MissionNames(13)="Mission 15"
	MissionNames(14)="Endgame"
	MissionNames(15)="All"
	defaultValue=0
	defaultInfoWidth=243
	defaultInfoPosX=203
	HelpText="Sets the augmentation level a player has installed when joining the game (priority can be configured in player options)."
	actionText="Augmentations"
	configSetting="HXGameInfo StartingAugBonus"
}
