//=============================================================================
// HXMenuChoice_UIScale
//=============================================================================
class HXMenuChoice_UIScale extends MenuUIChoiceEnum;

var int UIScales[6];
var localized String UIScaleNames[6];

// ----------------------------------------------------------------------
// InitWindow() -- Initialize the Window.
// ----------------------------------------------------------------------

event InitWindow()
{
	PopulateUIScales();

	Super.InitWindow();

	SetInitialUIScale();
	//SetActionButtonWidth(153);

	BtnAction.SetHelpText(HelpText);
}

// ----------------------------------------------------------------------
// PopulateUIScales()
// ----------------------------------------------------------------------

function PopulateUIScales()
{
	local int TypeIndex;

	for ( TypeIndex=0; TypeIndex<ArrayCount(UIScaleNames); TypeIndex++ )
		EnumText[TypeIndex] = UIScaleNames[TypeIndex];
}

// ----------------------------------------------------------------------
// SetInitialUIScale()
// ----------------------------------------------------------------------

function SetInitialUIScale()
{
	local String TypeString;
	local int TypeIndex;

	TypeString = Player.ConsoleCommand( "GET" @ Configsetting );

	for ( TypeIndex=0; TypeIndex<ArrayCount(UIScaleNames); TypeIndex++ )
		if ( TypeString==GetModuleName(TypeIndex) )
			SetValue(TypeIndex);
}

// ----------------------------------------------------------------------
// SaveSetting()
// ----------------------------------------------------------------------

function SaveSetting()
{
	Player.ConsoleCommand( "SET" @ ConfigSetting @ GetModuleName(CurrentValue) );
}

// ----------------------------------------------------------------------
// LoadSetting()
// ----------------------------------------------------------------------

function LoadSetting()
{
	local String TypeString;
	local int TypeIndex;

	TypeString = Player.ConsoleCommand( "GET" @ ConfigSetting );

	for ( TypeIndex=0; TypeIndex<ArrayCount(UIScaleNames); TypeIndex++ )
		if ( TypeString==GetModuleName(TypeIndex) )
			SetValue( TypeIndex );
}

// ----------------------------------------------------------------------
// ResetToDefault
// ----------------------------------------------------------------------

function ResetToDefault()
{   
	Player.ConsoleCommand( "SET " $ ConfigSetting $ " " $ GetModuleName(DefaultValue) );
	LoadSetting();
}

// ----------------------------------------------------------------------
// GetModuleName()
// For command line parsing
// ----------------------------------------------------------------------

function string GetModuleName( int ScaleIndex )
{
	return String(UIScales[ScaleIndex]);
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	DefaultValue=1
	UIScales(0)=-1
	UIScales(1)=0
	UIScales(2)=1
	UIScales(3)=2
	UIScales(4)=3
	UIScales(5)=4
	UIScaleNames(0)="Relaxed"
	UIScaleNames(1)="Default"
	UIScaleNames(2)="Max 1x"
	UIScaleNames(3)="Max 2x"
	UIScaleNames(4)="Max 3x"
	UIScaleNames(5)="Max 4x"
	DefaultInfoWidth=97
	HelpText="Window scale."
	ActionText="UI/Menu/HUD |&Scale"
	ConfigSetting="HXPlayerPawn WindowScale"
}
