//=============================================================================
// HXMenuMain (-72px).
//=============================================================================
class HXMenuMain expands HXMenuUIMenuWindow;

#exec TEXTURE IMPORT FILE="Textures\Menu\MenuMainBackground_1.pcx"			NAME="HXMenuMainBackground_1"			GROUP="UserInterface" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\Menu\MenuMainBackground_2.pcx"			NAME="HXMenuMainBackground_2"			GROUP="UserInterface" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\Menu\MenuMainBackground_3.pcx"			NAME="HXMenuMainBackground_3"			GROUP="UserInterface" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\Menu\MenuMainBackground_4.pcx"			NAME="HXMenuMainBackground_4"			GROUP="UserInterface" MIPS=Off

// ----------------------------------------------------------------------
// InitWindow()
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();

	CreateVersionInfo();

	UpdateButtonStatus();
}

// ----------------------------------------------------------------------
// CreateVersionInfo()
// ----------------------------------------------------------------------

function CreateVersionInfo()
{
	local TextWindow Version;

	Version = TextWindow(NewChild(Class'TextWindow'));
	Version.SetTextMargins( 24, 0 );
	Version.SetWindowAlignments( HALIGN_Right, VALIGN_Bottom );
	Version.SetTextColorRGB( 255, 255, 255 );
	Version.SetTextAlignments( HALIGN_Right, VALIGN_Bottom );
	Version.SetText( Class'HXActor'.Static.GetVersionString() );
}

// ----------------------------------------------------------------------
// UpdateButtonStatus()
// ----------------------------------------------------------------------

function UpdateButtonStatus()
{
	local bool bInMultiplayer;

	bInMultiplayer = Player.Level.Netmode!=NM_Standalone;

	ButtonWindows[0].SetSensitivity( !bInMultiplayer ); // Net Game.
	ButtonWindows[1].SetSensitivity( !bInMultiplayer ); // Lan Game.
	ButtonWindows[2].SetSensitivity(  bInMultiplayer ); // Disconnect.
	ButtonWindows[5].SetSensitivity(  bInMultiplayer ); // Continue.
}

// ----------------------------------------------------------------------
// ProcessCustomMenuButton()
// ----------------------------------------------------------------------

function ProcessCustomMenuButton( String Command )
{
	switch( Command )
	{
		case "Disconnect":
			Player.DisconnectPlayer();
			break;
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	Title="Welcome to HX"
	ButtonNames(0)="Net Game..."
	ButtonNames(1)="Lan Game..."
	ButtonNames(2)="Disconnect"
	ButtonNames(3)="Settings"
	ButtonNames(4)="Player Setup"
	ButtonNames(5)="Continue"
	ButtonNames(6)="Exit"
	ButtonDefaults(0)=(Y=13,Action=MA_MenuScreen,Invoke=HXMenuScreenJoinInternet)
	ButtonDefaults(1)=(Y=49,Action=MA_MenuScreen,Invoke=HXMenuScreenJoinLan)
	ButtonDefaults(2)=(Y=85,Action=MA_Custom,Key="Disconnect")
	ButtonDefaults(3)=(Y=121,Action=MA_MenuScreen,Invoke=HXMenuSettings)
	ButtonDefaults(4)=(Y=157,Action=MA_MenuScreen,Invoke=HXMenuScreenPlayerSetup)
	ButtonDefaults(5)=(Y=193,Action=MA_Previous)
	ButtonDefaults(6)=(Y=251,Action=MA_Quit)
	ButtonWidth=245
	ButtonX=7
	ClientWidth=258
	ClientHeight=293
	ClientTextures(0)=HXMenuMainBackground_1
	ClientTextures(1)=HXMenuMainBackground_2
	ClientTextures(2)=HXMenuMainBackground_3
	ClientTextures(3)=HXMenuMainBackground_4
	TextureCols=2
	ExitMessage="Are you sure you|nwant to exit HX?"
}
