//=============================================================================
// HXMenuScreenAudio (+36px).
//
// Audio settings screen for Galaxy or other non specially handled
// audio subystems. Supports the MaxEffectsChannels command in the
// effects channels slider and sets title based on package name
// of configured audio subystem.
//=============================================================================
class HXMenuScreenAudio expands HXMenuUIScreenWindow;

#exec TEXTURE IMPORT FILE="Textures\Menu\MenuAudioBackground_1.pcx"			NAME="MenuAudioBackground_1"		GROUP="UserInterface" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\Menu\MenuAudioBackground_2.pcx"			NAME="MenuAudioBackground_2"		GROUP="UserInterface" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\Menu\MenuAudioBackground_3.pcx"			NAME="MenuAudioBackground_3"		GROUP="UserInterface" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\Menu\MenuAudioBackground_4.pcx"			NAME="MenuAudioBackground_4"		GROUP="UserInterface" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\Menu\MenuAudioBackground_5.pcx"			NAME="MenuAudioBackground_5"		GROUP="UserInterface" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\Menu\MenuAudioBackground_6.pcx"			NAME="MenuAudioBackground_6"		GROUP="UserInterface" MIPS=Off

var localized String SettingsString;

// ----------------------------------------------------------------------
// InitWindow()
// ----------------------------------------------------------------------

event InitWindow()
{
	local Object AudioSubsystemClass;

	// Display affected audio subsystem in title.
	AudioSubsystemClass = DynamicLoadObject( "ini:Engine.Engine.AudioDevice", Class'Class', True );
	if ( AudioSubsystemClass!=None && AudioSubsystemClass.Outer!=None && AudioSubsystemClass.Outer.Name!='' )
		Title = AudioSubsystemClass.Outer.Name $ SettingsString;

	Super.InitWindow();
}

// ----------------------------------------------------------------------
// SaveSettings()
// ----------------------------------------------------------------------

function SaveSettings()
{
	Super.SaveSettings();
	Player.SaveConfig();
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	Choices(0)=HXMenuChoice_AudioSubsystem
	Choices(1)=Class'DeusEx.MenuChoice_MusicVolume'
	Choices(2)=Class'DeusEx.MenuChoice_SoundVolume'
	Choices(3)=Class'DeusEx.MenuChoice_SpeechVolume'
	Choices(4)=HXMenuChoice_EffectsChannels
	Choices(5)=Class'DeusEx.MenuChoice_SampleRate'
	Choices(6)=Class'DeusEx.MenuChoice_SoundQuality'
	Choices(7)=Class'DeusEx.MenuChoice_ReverseStereo'
	Choices(8)=Class'DeusEx.MenuChoice_SurroundSound'
	Choices(9)=Class'DeusEx.MenuChoice_Use3DHardware'
	ActionButtons(0)=(Align=HALIGN_Right,Action=AB_Cancel)
	ActionButtons(1)=(Align=HALIGN_Right,Action=AB_OK)
	ActionButtons(2)=(Action=AB_Reset)
	Title="Audio Settings"
	SettingsString=" Settings"
	ClientWidth=537
	ClientHeight=444
	ClientTextures(0)=MenuAudioBackground_1
	ClientTextures(1)=MenuAudioBackground_2
	ClientTextures(2)=MenuAudioBackground_3
	ClientTextures(3)=MenuAudioBackground_4
	ClientTextures(4)=MenuAudioBackground_5
	ClientTextures(5)=MenuAudioBackground_6
	HelpPosY=390
}
