//=============================================================================
// HXMenuScreenBrightness
//=============================================================================
class HXMenuScreenBrightness expands HXMenuUIScreenWindow;

var Color ColRed, ColGreen, ColBlue, ColWhite;
var localized string HelpMessage;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();

	ShowHelp( HelpMessage );

	// Don't mask this window, we want the user to see the 
	// 3D Scene unmolested to assist when setting the 
	// brightness.
	Root.HideSnapshot();
}

// ----------------------------------------------------------------------
// DestroyWindow()
// ----------------------------------------------------------------------

event DestroyWindow()
{
	Root.ShowSnapshot( True );

	Super.DestroyWindow();
}

// ----------------------------------------------------------------------
// CreateControls()
// ----------------------------------------------------------------------

function CreateControls()
{
	Super.CreateControls();

	// Create scale textures
	CreateScaleWindow(  14, ColRed   );
	CreateScaleWindow( 144, ColGreen );
	CreateScaleWindow( 274, ColBlue  );
	CreateScaleWindow( 404, ColWhite );

	// Create line
//	CreateScaleLine();
}

// ----------------------------------------------------------------------
// CreateScaleLine()
// ----------------------------------------------------------------------

function CreateScaleLine()
{
	local Window WinLine;

	WinLine = WinClient.NewChild( Class'Window' );
	WinLine.SetPos( 14, 178 );
	WinLine.SetSize( 520, 1 );
	WinLine.SetBackground( Texture'Solid' );
	WinLine.SetBackgroundStyle( DSTY_Normal );
	WinLine.SetTileColor( ColWhite );
}

// ----------------------------------------------------------------------
// CreateScaleWindow()
// ----------------------------------------------------------------------

function CreateScaleWindow(int posX, Color colScale)
{
	local Window WinScale;

	WinScale = WinClient.NewChild( Class'Window' );
	WinScale.SetPos( PosX, 67 );
	WinScale.SetSize( 130, 137 );
	WinScale.SetBackground( Texture'MenuBrightnessGradient' );
	WinScale.SetTileColor( ColScale );
	WinScale.SetBackgroundStyle( DSTY_Normal );
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	ColRed=(R=255)
	ColGreen=(G=255)
	ColBlue=(B=255)
	ColWhite=(R=255,G=255,B=255)
	HelpMessage="Adjust the slider so the color bars fade smoothly to pure black at the bottom of the bars."
	Choices(0)=Class'HX.HXMenuChoice_AdjustBrightness'
	ActionButtons(0)=(Align=HALIGN_Right,Action=AB_Cancel)
	ActionButtons(1)=(Align=HALIGN_Right,Action=AB_OK)
	ActionButtons(2)=(Action=AB_Reset)
	Title="Adjust Brightness"
	ClientWidth=556
	ClientHeight=283
	ClientTextures(0)=Texture'DeusExUI.UserInterface.MenuBrightnessBackground_1'
	ClientTextures(1)=Texture'DeusExUI.UserInterface.MenuBrightnessBackground_2'
	ClientTextures(2)=Texture'DeusExUI.UserInterface.MenuBrightnessBackground_3'
	ClientTextures(3)=Texture'DeusExUI.UserInterface.MenuBrightnessBackground_4'
	ClientTextures(4)=Texture'DeusExUI.UserInterface.MenuBrightnessBackground_5'
	ClientTextures(5)=Texture'DeusExUI.UserInterface.MenuBrightnessBackground_6'
	bHelpAlwaysOn=True
	helpPosY=229
}
