//=============================================================================
// HXMenuScreenHostGame (multiplayer)
//=============================================================================
class HXMenuScreenHostGame expands HXMenuUIScreenWindow;

#exec TEXTURE IMPORT FILE="Textures\Menu\MenuHostBackground_1.bmp "NAME="HXMenuHostBackground_1" GROUP="UserInterface" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\Menu\MenuHostBackground_2.bmp "NAME="HXMenuHostBackground_2" GROUP="UserInterface" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\Menu\MenuHostBackground_3.bmp "NAME="HXMenuHostBackground_3" GROUP="UserInterface" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\Menu\MenuHostBackground_4.bmp "NAME="HXMenuHostBackground_4" GROUP="UserInterface" MIPS=Off

var() globalconfig String CurrentGameType; //gametype selected (for saving in ui)
var() globalconfig int ServerMode;
var() globalconfig int Difficulty;
var() bool bLanOnly;

const MODE_DEDICATED = 0;
const MODE_LISTEN    = 1;

// ----------------------------------------------------------------------------
// InitWindow()
// ----------------------------------------------------------------------------

event InitWindow()
{
	Super(MenuUIScreenWindow).InitWindow();
}

// ----------------------------------------------------------------------------
// ProcessAction()
//
// Meant to be called in derived class
// ----------------------------------------------------------------------------

function ProcessAction( String ActionKey )
{
	if (actionKey == "BEGINHOST")
	{
		BeginHost();
	}
}

// ----------------------------------------------------------------------------
// BeginHost()
// ----------------------------------------------------------------------------

function BeginHost()
{
	local String MapName;
	local String Gametype;
	local String LanOption;
	local int ConfigServerMode;
	local int ConfigDifficulty;
	local HXRootWindow Root;

	//Save all settings so that they can be read.
	SaveSettings();

	MapName = GetGameType();

	// Kinda sucks that way
	Gametype = Player.ConsoleCommand("GET HXMenuScreenHostGame CurrentGameType");
	//GameType = GetConfig( "Engine.Engine", "DefaultServerGame" );
	if ( GameType=="" )
		GameType = "HX.HXGameInfo";

	ConfigServerMode = int(Player.ConsoleCommand("GET HXMenuScreenHostGame ServerMode"));
	ConfigDifficulty = int(Player.ConsoleCommand("GET HXMenuScreenHostGame Difficulty"));

	if ( bLanOnly )
		LanOption = "?-LanPlay?LAN";

	if ( ConfigServerMode==MODE_DEDICATED ) // !! GameClass.Default.ServerLogName
	{
		Player.ConsoleCommand( "Relaunch" @ MapName $ "?Game=" $ GameType $ "?difficulty=" $ ConfigDifficulty $ "?-Server" $ LanOption $ "?Log=HXServer.log");
	}
	else
	{
		//Root = HXRootWindow(GetRootWindow());
		//if ( Root!=None )
			//Root.ClearWindowStack();

		Player.ConsoleCommand( "Start " $ MapName $ "?listen?game=" $ GameType $ "?difficulty=" $ ConfigDifficulty $ LanOption );
	}
}

// ----------------------------------------------------------------------------
// SaveSettings()
// ----------------------------------------------------------------------------

function SaveSettings()
{
	local HXUdpServerUplink TempLink;
	Super.SaveSettings();

	TempLink = Player.Spawn( Class'HXUdpServerUplink' );
	if ( TempLink!=None )
	{
		TempLink.DoUplink = !bLanOnly;
		TempLink.SaveConfig();
		TempLink.Destroy();
	}
}

// ----------------------------------------------------------------------------
// GetGameType()
// ----------------------------------------------------------------------------

function string GetGameType()
{
	local HXMapList MapList;
	local string mapname;

	MapList = player.Spawn(class'HXMapList');

	if (MapList == None)
		return "";

	mapname = MapList.HXMaps[MapList.HXMapNum];

	MapList.Destroy();

	return mapname;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	CurrentGameType="HX.HXGameInfo"
	ServerMode=1
	ChoiceVerticalGap=28
	ChoiceStartY=17
	Choices(0)=HXMenuChoice_HostGameInfo
	Choices(1)=HXMenuChoice_Episode
	Choices(2)=HXMenuChoice_Difficulty
	Choices(3)=HXMenuChoice_MaxPlayers
	Choices(4)=HXMenuChoice_FriendlyFire
	Choices(5)=HXMenuChoice_SkillPointMultiplier
	Choices(6)=HXMenuChoice_HostDentonMode
	Choices(7)=HXMenuChoice_HostDummySlider
	Choices(8)=HXMenuChoice_StartingSkillPointsBonus
	Choices(9)=HXMenuChoice_StartingAugsBonus
	Choices(10)=HXMenuChoice_StartingAugUpgradesBonus
	Choices(11)=HXMenuChoice_HostCheats
	Choices(12)=HXMenuChoice_ServerMode
	ActionButtons(0)=(Align=HALIGN_Right,Action=AB_Cancel)
	ActionButtons(1)=(Align=HALIGN_Right,Action=AB_Reset)
	ActionButtons(2)=(Action=AB_Other,Text="Start Game",Key="BEGINHOST")
	Title="Host Multiplayer Game"
	ClientWidth=461
	ClientHeight=427
	ClientTextures(0)=HXMenuHostBackground_1
	ClientTextures(1)=HXMenuHostBackground_2
	ClientTextures(2)=HXMenuHostBackground_3
	ClientTextures(3)=HXMenuHostBackground_4
	TextureCols=2
	HelpPosY=384
}
