//=============================================================================
// HXMenuScreenJoinInternet (multiplayer)
//=============================================================================
class HXMenuScreenJoinInternet expands HXMenuScreenJoinGame;

var HXMasterServerLink Link;

// ----------------------------------------------------------------------------
// Query()
// ----------------------------------------------------------------------------

function Query()
{
	Link = GetPlayerPawn().GetEntryLevel().Spawn( class'HXMasterServerLink' );

	Link.MasterServerAddress = MasterServerAddress;
	Link.MasterServerTCPPort = MasterServerTCPPort;
	Link.Region              = Region;
	Link.MasterServerTimeout = MasterServerTimeout;
	Link.BeaconProduct       = BeaconProduct;
	Link.OwnerWindow         = Self;

	Link.Start();
}

// ----------------------------------------------------------------------------
// QueryFinished()
// ----------------------------------------------------------------------------

function QueryFinished(bool bSuccess, optional string ErrorMsg)
{
	Link.Destroy();
	Link = None;

	PingUnpingedServers();
}

// ----------------------------------------------------------------------------
// ShutdownLink()
// ----------------------------------------------------------------------------

function ShutdownLink()
{
	if( Link!=None )
		Link.Destroy();
	Link = None;
}

// ----------------------------------------------------------------------------
// ButtonActivated()
// ----------------------------------------------------------------------------

function bool ButtonActivated( Window ButtonPressed )
{
	local bool bHandled;

	bHandled = True;

	switch( buttonPressed )
	{
		case HostButton:
         ProcessMenuAction(MA_MenuScreen,Class'HXMenuScreenHostNet');
			break;

		default:
			bHandled = False;
			break;
	}

	if ( !bHandled )
		bHandled = Super.ButtonActivated(buttonPressed);

	return bHandled;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	Title="Start Multiplayer Internet Game"
}
