//=============================================================================
// HXMenuScreenJoinLan (multiplayer)
//=============================================================================
class HXMenuScreenJoinLan expands HXMenuScreenJoinGame;

var HXLocalLink Link;

// ----------------------------------------------------------------------------
// Query()
// ----------------------------------------------------------------------------

function Query()
{
	Link = GetPlayerPawn().GetEntryLevel().Spawn( class'HXLocalLink' );

	Link.BeaconProduct = BeaconProduct;
	Link.LocalUDPPort  = LocalUDPPort;

	Link.OwnerWindow = Self;
	Link.Start();
	Link.SetTimer( 1.0, false );
}

// ----------------------------------------------------------------------------
// QueryFinished()
// ----------------------------------------------------------------------------

function QueryFinished( bool bSuccess, optional string ErrorMsg )
{
	Link.Destroy();
	Link = None;

	PingUnpingedServers();
}

// ----------------------------------------------------------------------------
// ShutdownLink()
// ----------------------------------------------------------------------------

function ShutdownLink()
{
	if( Link!=None )
		Link.Destroy();
	Link = None;
}

// ----------------------------------------------------------------------------
// GetExtraJoinOptions()
// ----------------------------------------------------------------------------

function string GetExtraJoinOptions()
{
	return Super.GetExtraJoinOptions() $ "?LAN";
}

// ----------------------------------------------------------------------------
// ButtonActivated()
// ----------------------------------------------------------------------------

function bool ButtonActivated( Window ButtonPressed )
{
	switch( ButtonPressed )
	{
		case HostButton:
			ProcessMenuAction(MA_MenuScreen,Class'HXMenuScreenHostLan');
			return true;
			break;

		default:
			return Super.ButtonActivated( ButtonPressed );
			break;
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	Title="Start Multiplayer LAN Game"
}
