//=============================================================================
// HXMenuScreenPlayerSetup
//=============================================================================
class HXMenuScreenPlayerSetup extends HXMenuUIScreenWindow;

// Background
#exec TEXTURE IMPORT FILE="Textures\Menu\MenuPlayerSetupBackground_1.pcx"	NAME="HXMenuPlayerSetupBackground_1"	GROUP="UserInterface"	MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\Menu\MenuPlayerSetupBackground_2.pcx"	NAME="HXMenuPlayerSetupBackground_2"	GROUP="UserInterface"	MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\Menu\MenuPlayerSetupBackground_3.pcx"	NAME="HXMenuPlayerSetupBackground_3"	GROUP="UserInterface"	MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\Menu\MenuPlayerSetupBackground_4.pcx"	NAME="HXMenuPlayerSetupBackground_4"	GROUP="UserInterface"	MIPS=Off

var MenuUIEditWindow PlayerNameEditor;

var localized string HeaderPlayerNameLabel;
var string FilterString;

var HXMenuChoice_Connection ConnectionChoice;
var HXMenuChoice_PlayerClass ClassChoice;
var HXMenuChoice_Augmentation AugmentationChoice;
var	HXMenuChoice_Inventory InventoryChoice;
var HXMenuChoice_UIScale UIScaleChoice;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();

	winHelp.Hide();
}

// ----------------------------------------------------------------------
// CreateControls()
// ----------------------------------------------------------------------

function CreateControls()
{
	Super.CreateControls();

	// Player name
	CreateMenuLabel(13, 31, HeaderPlayerNameLabel, winClient);

	PlayerNameEditor = CreateMenuEditWindow(6, 54, 153, 18, winClient);
	PlayerNameEditor.SetText(GetMultiplayerName());
	PlayerNameEditor.MoveInsertionPoint(MOVEINSERT_End);
	PlayerNameEditor.SetFilter(filterString);

	// UI scale
	UIScaleChoice = HXMenuChoice_UIScale(winClient.NewChild(Class'HXMenuChoice_UIScale'));
	UIScaleChoice.SetPos(6, 87);
	UIScaleChoice.SetSize(153, 60);
	UIScaleChoice.btnInfo.SetPos(0, 27);

	ConnectionChoice = HXMenuChoice_Connection(winClient.NewChild(Class'HXMenuChoice_Connection'));
	ConnectionChoice.SetPos(6, 147);
	ConnectionChoice.SetSize(153, 60);
	ConnectionChoice.btnInfo.SetPos(0, 27);

	AugmentationChoice = HXMenuChoice_Augmentation(winClient.NewChild(Class'HXMenuChoice_Augmentation'));
	AugmentationChoice.SetPos(6, 207);
	AugmentationChoice.SetSize(153, 60);
	AugmentationChoice.SetActionButtonWidth(153);
	
	InventoryChoice = HXMenuChoice_Inventory(winClient.NewChild(Class'HXMenuChoice_Inventory'));
	InventoryChoice.SetPos(6, 234);
	InventoryChoice.SetSize(153, 60);
	InventoryChoice.SetActionButtonWidth(153);

	// Player class
	ClassChoice = HXMenuChoice_PlayerClass(winClient.NewChild(Class'HXMenuChoice_PlayerClass'));
	ClassChoice.SetPos(176, 27);
	ClassChoice.SetSize(153,213);
}

// ----------------------------------------------------------------------
// FocusEnteredDescendant() : Called when a descendant window gets focus
// ----------------------------------------------------------------------

event FocusEnteredDescendant(Window enterWindow)
{
	if (enterWindow.IsA('MenuUIChoiceButton'))
	{
      if ((winHelp != None) && (MenuUIChoiceButton(enterWindow).helpText != ""))
      {
         winHelp.Show();
         winHelp.SetText(MenuUIChoiceButton(enterWindow).helpText);
      }
   }
}


// ----------------------------------------------------------------------
// FocusLeftDescendant() : Called when a descendant window loses focus
// ----------------------------------------------------------------------

event FocusLeftDescendant(Window leaveWindow)
{
	if ((winHelp != None) && (!bHelpAlwaysOn))
		winHelp.Hide();
}

// ----------------------------------------------------------------------
// SaveSettings()
// ----------------------------------------------------------------------

function SaveSettings()
{
   Super.SaveSettings();

   SetMultiplayerName(PlayerNameEditor.GetText());

   player.SaveConfig();
}

// ----------------------------------------------------------------------
// ResetToDefaults()
// ----------------------------------------------------------------------

function ResetToDefaults()
{
   Super.ResetToDefaults();

   //Setting "" will set to default.
   SetMultiplayerName("");

   PlayerNameEditor.SetText(GetMultiplayerName());

   player.SaveConfig();
}

// ----------------------------------------------------------------------
// GetMultiplayerName()
// ----------------------------------------------------------------------

function string GetMultiplayerName()
{
   local string mpname;

   mpname = player.PlayerReplicationInfo.PlayerName;

   if (mpname == "")
   {
      mpname = "Player";
      SetMultiplayerName(mpname);
   }

   return mpname;
}

// ----------------------------------------------------------------------
// SetMultiplayerName()
// ----------------------------------------------------------------------

function SetMultiplayerName(string newname)
{
   local string mpname;

   if (newname == "")
      mpname = "Player";
   else
      mpname = newname;

   player.SetName(mpname);
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	HeaderPlayerNameLabel="Player Name"
	filterString="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890[]()"
	actionButtons(0)=(Align=HALIGN_Right,Action=AB_Cancel)
	actionButtons(1)=(Align=HALIGN_Right,Action=AB_Reset)
	actionButtons(2)=(Action=AB_OK)
	Title="Player Setup"
	ClientWidth=343
	ClientHeight=327
	clientTextures(0)=HXMenuPlayerSetupBackground_1
	clientTextures(1)=HXMenuPlayerSetupBackground_2
	clientTextures(2)=HXMenuPlayerSetupBackground_3
	clientTextures(3)=HXMenuPlayerSetupBackground_4
	textureCols=2
	helpPosY=265
}
