//=============================================================================
// HXMenuScreenUserInterface.
//
// Based on old MenuScreenAdjustColors (+108px).
//
// Revision History:
//  * Moved some buttons here...
//=============================================================================
class HXMenuScreenUserInterface extends HXMenuUIScreenWindow;

#exec TEXTURE IMPORT FILE="Textures\Menu\MenuInterfaceBackground_1.pcx"			NAME="HXMenuInterfaceBackground_1"		GROUP="UserInterface" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\Menu\MenuInterfaceBackground_2.pcx"			NAME="HXMenuInterfaceBackground_2"		GROUP="UserInterface" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\Menu\MenuInterfaceBackground_3.pcx"			NAME="HXMenuInterfaceBackground_3"		GROUP="UserInterface" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\Menu\MenuInterfaceBackground_4.pcx"			NAME="HXMenuInterfaceBackground_4"		GROUP="UserInterface" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\Menu\MenuInterfaceBackground_5.pcx"			NAME="HXMenuInterfaceBackground_5"		GROUP="UserInterface" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\Menu\MenuInterfaceBackground_6.pcx"			NAME="HXMenuInterfaceBackground_6"		GROUP="UserInterface" MIPS=Off

var MenuScreenAdjustColorsExample WinExample;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();

	CreateExampleWindow();	
}

// ----------------------------------------------------------------------
// CreateExampleWindow()
// ----------------------------------------------------------------------

function CreateExampleWindow()
{
	WinExample = MenuScreenAdjustColorsExample(WinClient.NewChild(Class'MenuScreenAdjustColorsExample'));
	WinExample.SetPos( 395, 25 );	
}

// ----------------------------------------------------------------------
// SaveSettings()
// ----------------------------------------------------------------------

function SaveSettings()
{
	Super.SaveSettings();
	Player.SaveConfig();
	Player.ThemeManager.SaveConfig();
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	Choices(0)=Class'DeusEx.MenuChoice_MenuTranslucency'
	Choices(1)=Class'DeusEx.MenuChoice_MenuColor'
	Choices(2)=Class'DeusEx.MenuChoice_HUDBordersVisible'
	Choices(3)=Class'DeusEx.MenuChoice_HUDBorderTranslucency'
	Choices(4)=Class'DeusEx.MenuChoice_HUDTranslucency'
	Choices(5)=Class'DeusEx.MenuChoice_HUDColor'
	Choices(6)=HXMenuChoice_HUDAugDisplay
	Choices(7)=HXMenuChoice_UIBackground
	Choices(8)=HXMenuChoice_UIScale
	ActionButtons(0)=(Align=HALIGN_Right,Action=AB_Cancel)
	ActionButtons(1)=(Align=HALIGN_Right,Action=AB_OK)
	ActionButtons(2)=(Action=AB_Reset)
	Title="User Interface"
	ClientWidth=620
	ClientHeight=408
	ClientTextures(0)=HXMenuInterfaceBackground_1
	ClientTextures(1)=HXMenuInterfaceBackground_2
	ClientTextures(2)=HXMenuInterfaceBackground_3
	ClientTextures(3)=HXMenuInterfaceBackground_4
	ClientTextures(4)=HXMenuInterfaceBackground_5
	ClientTextures(5)=HXMenuInterfaceBackground_6
	HelpPosY=354
}
