//=============================================================================
// HXMenuSettings (-36px).
//=============================================================================
class HXMenuSettings extends HXMenuUIMenuWindow;

#exec TEXTURE IMPORT FILE="Textures\Menu\MenuSettingsBackground_1.pcx"		NAME="HXMenuSettingsBackground_1"		GROUP="UserInterface" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\Menu\MenuSettingsBackground_2.pcx"		NAME="HXMenuSettingsBackground_2"		GROUP="UserInterface" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\Menu\MenuSettingsBackground_3.pcx"		NAME="HXMenuSettingsBackground_3"		GROUP="UserInterface" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\Menu\MenuSettingsBackground_4.pcx"		NAME="HXMenuSettingsBackground_4"		GROUP="UserInterface" MIPS=Off

// ----------------------------------------------------------------------
// ProcessCustomMenuButton()
// ----------------------------------------------------------------------

function ProcessCustomMenuButton( String Command )
{
	local Class<DeusExBaseWindow> InvokeClass;
	local Object AudioSubsystemClass;
	local HXRootWindow Root;

	Root = HXRootWindow(GetRootWindow());

	// Act upon command.
	switch( Command )
	{
		// Open specific audio settings screen depending on currently configured audio subsystem.
		case "AudioSettings":
			// Default screen for all audio subsystems but ALAudio.
			InvokeClass = Class'HXMenuScreenAudio';

			// Dynamicload current ini setting.
			AudioSubsystemClass = DynamicLoadObject( "ini:Engine.Engine.AudioDevice", Class'Class', True );
			if ( AudioSubsystemClass!=None && AudioSubsystemClass.Outer!=None && AudioSubsystemClass.Outer.Name!='' )
				if ( AudioSubsystemClass.Outer.Name=='ALAudio' )
					InvokeClass = Class'HXMenuScreenALAudio';

			// Invoke.
			Root.InvokeMenuScreen( InvokeClass );
			break;

		// Open advanced preferences dialogue.
		case "Advanced":
			Player.ConsoleCommand( "Preferences" );
			break;
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	Title="Settings"
	ButtonNames(0)="Controls"
	ButtonNames(1)="Network"
	ButtonNames(2)="Audio"
	ButtonNames(3)="Video"
	ButtonNames(4)="Game"
	ButtonNames(5)="UI/Menu/HUD"
	ButtonNames(6)="Advanced"
	ButtonNames(7)="Cancel"
	ButtonX=7
	ButtonWidth=245
	ButtonDefaults(0)=(Y=13,Action=MA_MenuScreen,Invoke=HXMenuScreenControls)
	ButtonDefaults(1)=(Y=49,Action=MA_MenuScreen,Invoke=HXMenuScreenNetwork)
	ButtonDefaults(2)=(Y=85,Action=MA_Custom,Key="AudioSettings")
	ButtonDefaults(3)=(Y=121,Action=MA_MenuScreen,Invoke=HXMenuScreenDisplay)
	ButtonDefaults(4)=(Y=157,Action=MA_MenuScreen,Invoke=HXMenuScreenGameOptions)
	ButtonDefaults(5)=(Y=193,Action=MA_MenuScreen,Invoke=HXMenuScreenUserInterface)
	ButtonDefaults(6)=(Y=229,Action=MA_Custom,Key="Advanced")
	ButtonDefaults(7)=(Y=287,Action=MA_Previous)
	ClientTextures(0)=HXMenuSettingsBackground_1
	ClientTextures(1)=HXMenuSettingsBackground_2
	ClientTextures(2)=HXMenuSettingsBackground_3
	ClientTextures(3)=HXMenuSettingsBackground_4
	ClientWidth=258
	ClientHeight=329
	TextureCols=2
}
