//=============================================================================
// HXMenuUIChoiceAugmentation.
//=============================================================================
class HXMenuUIChoiceAugmentation extends MenuUIChoiceEnum;

var Name		AugNames[12];
var localized String AugString[12];

var int AugPrefIndex;
var int CurrentBonus;

var Name AugPrefs[9];

var enum EAugmentationLocation
{
	LOC_Cranial,
	LOC_Eye,
	LOC_Torso,
	LOC_Arm,
	LOC_Leg,
	LOC_Subdermal,
	LOC_Default
} AugmentationLocation;

var HXMenuUIActionButtonLeft	LeftButton;
var HXMenuUIActionButtonRight	RightButton;
var HXMenuUIInfoButtonMiddle	MiddleButton;

var int defaultUpDownPosX;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	CreateUpgradePriorityButtons();

	Super.InitWindow();

	PopulateAugmentationChoices();

	LoadSetting();

	SetActionButtonWidth(92);

	SetSize(540, 21);
}

// ----------------------------------------------------------------------
// CreateInfoButtons()
// ----------------------------------------------------------------------

function CreateUpgradePriorityButtons()
{
	LeftButton = HXMenuUIActionButtonLeft( NewChild(Class'HXMenuUIActionButtonLeft') );
	LeftButton.SetButtonText( "-" );
	LeftButton.SetSize( 23, 19);
	LeftButton.SetPos( defaultUpDownPosX + 14, 0);

	MiddleButton = HXMenuUIInfoButtonMiddle( NewChild(Class'HXMenuUIInfoButtonMiddle') );
	MiddleButton.SetSelectability( False );
	MiddleButton.SetSize( 37, 19 );
	//MiddleButton.SetButtonText( "20" );
	MiddleButton.SetPos( defaultUpDownPosX + 38, 0);

	RightButton = HXMenuUIActionButtonRight( NewChild(Class'HXMenuUIActionButtonRight') );
	RightButton.SetButtonText( "+" );
	RightButton.SetSize( 21, 19);
	RightButton.SetPos( defaultUpDownPosX + 77, 0);
}

// ----------------------------------------------------------------------
// PopulateAugmentationChoices()
// ----------------------------------------------------------------------

function PopulateAugmentationChoices()
{
	local int typeIndex;

	for (typeIndex = 0; typeIndex < arrayCount(AugString); typeIndex++)
	{
		enumText[typeIndex] = AugString[typeIndex];
	}
}

// ----------------------------------------------------------------------
// ButtonActivated()
//
// If the action button was pressed, cycle to the next available
// choice (if any)
// ----------------------------------------------------------------------

function bool ButtonActivated( Window buttonPressed )
{
	if ( buttonPressed == RightButton )
	{
		if ( CurrentBonus < 26)
		{
			CurrentBonus++;
			MiddleButton.SetButtonText( String(CurrentBonus) );
		}
		return True;
	}
	else if ( buttonPressed == LeftButton )
	{
		if ( CurrentBonus > 0 )
		{
			CurrentBonus--;
			MiddleButton.SetButtonText( String(CurrentBonus) );
		}
		return True;
	}
	else
	{
		return Super.ButtonActivated(buttonPressed);
	}
}

// ----------------------------------------------------------------------
// CycleNextValue()
// ----------------------------------------------------------------------

function CycleNextValue()
{
	local int NewValue;
	local Window BtnChoice;
	local HXMenuUIChoiceAugmentation AugChoice;

	// Cycle to the next value, but make sure we don't exceed the 
	// bounds of the enumText array.  If we do, start back at the 
	// bottom.

	NewValue = GetValue() + 1;

	if ( NewValue >= arrayCount(enumText) )
		NewValue = 0;
	else if ( enumText[NewValue] == "" )
		NewValue = 0;

	SetValue( NewValue);

	btnChoice = winParent.GetTopChild();

	// 0 is empty, so always permit it
	if ( NewValue != 0 )
	{
		while( btnChoice != None )
		{
			if ( btnChoice.IsA('HXMenuUIChoiceAugmentation') && btnChoice != Self )
			{
				AugChoice = HXMenuUIChoiceAugmentation(btnChoice);

				if ( ( AugmentationLocation == AugChoice.AugmentationLocation )
					&& ( NewValue == AugChoice.GetValue() ) )
				{
					CycleNextValue();
					break;
				}
			}

			btnChoice = btnChoice.GetLowerSibling();
		}
	}
}

// ----------------------------------------------------------------------
// CyclePreviousValue()
// ----------------------------------------------------------------------

function CyclePreviousValue()
{
	local int NewValue;
	local Window BtnChoice;
	local HXMenuUIChoiceAugmentation AugChoice;

	// Cycle to the next value, but make sure we don't exceed the 
	// bounds of the enumText array.  If we do, start back at the 
	// bottom.

	NewValue = GetValue() - 1;

	if (NewValue < 0)
	{
		NewValue = arrayCount(enumText) - 1;

		while((enumText[newValue] == "") && (NewValue > 0))
			NewValue--;	
	}

	SetValue( NewValue );

	btnChoice = winParent.GetTopChild();

	// 0 is empty, so always permit it
	if ( NewValue != 0 )
	{
		while( btnChoice != None )
		{
			if ( btnChoice.IsA('HXMenuUIChoiceAugmentation') && btnChoice != Self )
			{
				AugChoice = HXMenuUIChoiceAugmentation(btnChoice);

				if ( ( AugmentationLocation == AugChoice.AugmentationLocation )
					&& ( NewValue == AugChoice.GetValue() ) )
				{
					CyclePreviousValue();
					break;
				}
			}

			btnChoice = btnChoice.GetLowerSibling();
		}
	}
}

// ----------------------------------------------------------------------
// LoadSetting()
// ----------------------------------------------------------------------

function LoadSetting()
{
	local int enumIndex;

	CurrentBonus = HXPlayerPawn(Player).AugUpPrefs[AugPrefIndex];

	MiddleButton.SetButtonText( String(CurrentBonus) );

	for ( enumIndex = 0; enumIndex < arrayCount(AugNames); enumIndex++ )
	{
		if ( AugNames[enumIndex] == Player.AugPrefs[AugPrefIndex] )
		{
			SetValue( enumIndex );
			return;
		}	
	}

	SetValue( 0 );
}

// ----------------------------------------------------------------------
// SaveSettings()
// ----------------------------------------------------------------------

function SaveSetting()
{
	Player.AugPrefs[AugPrefIndex] = AugNames[currentValue];
	HXPlayerPawn(Player).AugUpPrefs[AugPrefIndex] = CurrentBonus;
	Player.SaveConfig();
}

// ----------------------------------------------------------------------
// ResetToDefaults()
// ----------------------------------------------------------------------

function ResetToDefault()
{
	Player.AugPrefs[AugPrefIndex] = AugPrefs[AugPrefIndex];
	HXPlayerPawn(Player).AugUpPrefs[AugPrefIndex] = 0;
	Player.SaveConfig();

	LoadSetting();
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	ActionText="Unknown Augmentation Slot"
	HelpText="Select preferred augmentation for unknown slot."
	AugPrefIndex=-1
	AugNames(0)=
	AugString(0)="Empty"
	defaultInfoWidth=108
	defaultInfoPosX=135
	defaultUpDownPosX=270
	AugPrefs(0)=HXAugVision
	AugPrefs(1)=HXAugDrone
	AugPrefs(2)=HXAugMuscle
	AugPrefs(3)=HXAugCloak
	AugPrefs(4)=HXAugRadarTrans
	AugPrefs(5)=HXAugHealing
	AugPrefs(6)=HXAugAqualung
	AugPrefs(7)=HXAugPower
	AugPrefs(8)=HXAugSpeed
	AugmentationLocation=LOC_Default
}
