//=============================================================================
// HXMenuUIClientWindow
//=============================================================================
class HXMenuUIClientWindow extends HXWindow;

var Texture ClientTextures[6];
var int TexturePosX[6];
var int TexturePosY[6];

var int TextureRows;
var int TextureCols;
var int TextureCount;

// Default Colors/Translucency.
var EDrawStyle BackgroundDrawStyle;
var Color      BackgroundColor;

// ----------------------------------------------------------------------------
// DrawWindow()
// ----------------------------------------------------------------------------

event DrawWindow( GC Context )
{
	local int TextureIndex;

	// Set Style and Color.
	Context.SetStyle( BackgroundDrawStyle );
	Context.SetTileColor( BackgroundColor );

	for ( TextureIndex=0; TextureIndex<TextureCount; TextureIndex++ )
		Context.DrawIcon( TexturePosX[TextureIndex], TexturePosY[TextureIndex], ClientTextures[TextureIndex] );
}

// ----------------------------------------------------------------------------
// SetClientTexture()
// ----------------------------------------------------------------------------

function SetClientTexture(int TextureIndex, Texture newTexture)
{
	if ((TextureIndex >= 0) && (TextureIndex < arrayCount(ClientTextures)))
		ClientTextures[TextureIndex] = newTexture;
}

// ----------------------------------------------------------------------------
// SetTextureLayout()
// ----------------------------------------------------------------------------

function SetTextureLayout(int newTextureCols, int newTextureRows)
{
	TextureCols = newTextureCols;
	TextureRows = newTextureRows;

	CalculateTexturePositions();
}

// ----------------------------------------------------------------------------
// CalculateTexturePositions()
//
// Do this once so we don't have to do it every time in the 
// DrawWindow() event
// ----------------------------------------------------------------------------

function CalculateTexturePositions()
{
	local int rowIndex;
	local int colIndex;

	TextureCount = 0;

	for(rowIndex=0; rowIndex<TextureRows; rowIndex++)
	{
		for(colIndex=0; colIndex<TextureCols; colIndex++)
		{
			TexturePosX[TextureCount] = colIndex * 256;
			TexturePosY[TextureCount] = rowIndex * 256;
			TextureCount++;
		}
	}
}

// ----------------------------------------------------------------------------
// StyleChanged()
// ----------------------------------------------------------------------------

event StyleChanged()
{
	local ColorTheme Theme;

	// Translucency
	if ( PlayerPawn.GetMenuTranslucency() )
		BackgroundDrawStyle = DSTY_Translucent;
	else
		BackgroundDrawStyle = DSTY_Masked;

	// Background color
	Theme = PlayerPawn.ThemeManager.GetCurrentMenuColorTheme();

	BackgroundColor = Theme.GetColorFromName( 'MenuColor_Background' );
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
}
