//=============================================================================
// HXMenuUIMenuButtonWindow.
//=============================================================================
class HXMenuUIMenuButtonWindow extends HXMenuUIBorderButtonWindow;

var Texture ButtonLights[4];
var int ButtonLightWidth;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();

	// Load the menu font from the DXFonts package
	FontButtonText = Font(DynamicLoadObject("DXFonts.MainMenuTrueType", Class'Font'));
}

// ----------------------------------------------------------------------
// DrawWindow()
// ----------------------------------------------------------------------

event DrawWindow( GC Context )
{	
	// Allow the parent to draw the bulk of the button and the text.
	Super.DrawWindow( Context );

	// Now draw the pretty light to the left of the button
	Context.DrawTexture( 0, 0, ButtonLightWidth, ButtonHeight, 0, 0, ButtonLights[TextColorIndex] );
}

// ----------------------------------------------------------------------
// StyleChanged()
// ----------------------------------------------------------------------

event StyleChanged()
{
	Super.StyleChanged();

	// Honor Menu Transluency.
	bTranslucent = Player.GetMenuTranslucency();
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	ButtonLights(0)=MenuMainLight_Normal
	ButtonLights(1)=MenuMainLight_Focus
	ButtonLights(2)=MenuMainLight_Focus
	ButtonLights(3)=MenuMainLight_Normal
	Left_Textures(0)=(Texture=Texture'MenuMainButtonNormal_Left',Width=5)
	Left_Textures(1)=(Texture=Texture'MenuMainButtonPressed_Left',Width=5)
	Right_Textures(0)=(Texture=Texture'MenuMainButtonNormal_Right',Width=20)
	Right_Textures(1)=(Texture=Texture'MenuMainButtonPressed_Right',Width=20)
	Center_Textures(0)=(Texture=Texture'MenuMainButtonNormal_Center',Width=2)
	Center_Textures(1)=(Texture=Texture'MenuMainButtonPressed_Center',Width=2)
	ButtonLightWidth=7
	bTranslucentText=True
	LeftOffset=9
	ButtonHeight=27
	MinimumButtonWidth=245
	TextLeftMargin=-4
	bTranslucent=True
	bCenterText=True
}
