//=============================================================================
// HXMenuUIMenuWindow.
//
// Base class for the Menu windows, which consist of a list of selections
// (load game, save game, new game, options, etc.)
//
// Overview about menu backgroud graphics:
//  * DeusExUI.UserInterface.MenuDifficultyBackground				5
//  * DeusExUI.UserInterface.MenuMultiplayerBackground			6
//  * DeusExUI.UserInterface.MenuOptionsBackground					7
//  * HX.UserInterface.HXMenuOptionsBackground							8
//  * DeusExUI.UserInterface.MenuMainBackground (RTM/Demo)	9
//  * DeusExUI.UserInterface.MenuMainBackground						 10
//=============================================================================
class HXMenuUIMenuWindow extends HXMenuUIWindow;

enum EMenuActions
{
	MA_Menu,
	MA_MenuScreen,
	MA_Previous,
	MA_Quit,
	MA_Custom
};

struct S_MenuButton
{
	var int y;
	var EMenuActions action;
	var class invoke;
	var string key;
};

// Array of Buttons
var HXMenuUIMenuButtonWindow ButtonWindows[10]; // Up to ten Buttons

// Array of button text
var localized string ButtonNames[10];

// Defaults
var int ButtonX;
var int ButtonWidth;
var S_MenuButton ButtonDefaults[10];

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();

	CreateMenuButtons();
}

// ----------------------------------------------------------------------
// CreateMenuButtons()
//
// Loop through the ButtonDefaults array and create any Buttons
// that we need for the menu
// ----------------------------------------------------------------------

function CreateMenuButtons()
{
	local int ButtonIndex;

	for ( ButtonIndex=0; ButtonIndex<ArrayCount(ButtonDefaults); ButtonIndex++ )
	{
		if ( ButtonNames[ButtonIndex]!="" )
		{
			ButtonWindows[ButtonIndex] = HXMenuUIMenuButtonWindow(ClientWindow.NewChild(Class'HXMenuUIMenuButtonWindow'));

			ButtonWindows[ButtonIndex].SetButtonText( ButtonNames[ButtonIndex] );
			ButtonWindows[ButtonIndex].SetPos( ButtonX, ButtonDefaults[ButtonIndex].Y );
			ButtonWindows[ButtonIndex].SetWidth( ButtonWidth );
		}
		else
		{
			break;
		}
	}
}

// ----------------------------------------------------------------------
// ButtonActivated()
// ----------------------------------------------------------------------

function bool ButtonActivated( Window ButtonPressed )
{
	local bool bHandled;
	local int  ButtonIndex;

	bHandled = False;

	Super.ButtonActivated(ButtonPressed);

	// Figure out which Button was pressed
	for ( ButtonIndex=0; ButtonIndex<ArrayCount(ButtonWindows); ButtonIndex++ )
	{
		if ( ButtonPressed==ButtonWindows[ButtonIndex] )
		{
			// Check to see if there's somewhere to go
			ProcessMenuAction( ButtonDefaults[ButtonIndex].Action, ButtonDefaults[ButtonIndex].Invoke, ButtonDefaults[ButtonIndex].Key );

			bHandled = True;
			break;
		}
	}

	return bHandled;
}

// ----------------------------------------------------------------------
// ProcessMenuAction()
// ----------------------------------------------------------------------

function ProcessMenuAction( EMenuActions Action, Class MenuActionClass, optional String Key )
{
	switch(Action)
	{
		case MA_Menu:
			Root.InvokeMenu(Class<DeusExBaseWindow>(MenuActionClass));
			break;

		case MA_MenuScreen:
			Root.InvokeMenuScreen(Class<DeusExBaseWindow>(MenuActionClass));
			break;

		case MA_Previous:
			Root.PopWindow();
			break;

		case MA_Quit:
			MessageBoxMode = MB_Exit;
			Root.MessageBox( MessageBoxTitle, ExitMessage, 0, False, Self );
			break;

		case MA_Custom:
			ProcessCustomMenuButton( Key );
			break;
	}
}

// ----------------------------------------------------------------------
// ProcessCustomMenuButton()
// ----------------------------------------------------------------------

function ProcessCustomMenuButton( string Key )
{
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	TextureRows=2
	TextureCols=1
	bUsesHelpWindow=False
	ScreenType=ST_Menu
}
