//=============================================================================
// HXMenuUIMessageBoxShadowWindow
//=============================================================================
class HXMenuUIMessageBoxShadowWindow extends MenuUIShadowWindow;

var Texture ShadowsTextures[4];
var int     textureIndex;

// ----------------------------------------------------------------------------
// DrawWindow()
// ----------------------------------------------------------------------------

event DrawWindow(GC gc)
{	
	gc.SetStyle(DSTY_Modulated);
	gc.DrawTexture(0,   0, 256, ShadowHeight, 0, 0, ShadowsTextures[0 + (textureIndex * 2)]);
	gc.DrawTexture(256, 0, ShadowWidth - 256, ShadowHeight, 0, 0, ShadowsTextures[1 + (textureIndex * 2)]);
}

// ----------------------------------------------------------------------------
// SetButtonCount()
// ----------------------------------------------------------------------------

function SetButtonCount(int newButtonCount)
{
	if ((newButtonCount >= 1) && (newButtonCount <= 2))
		textureIndex = newButtonCount - 1;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	ShadowsTextures(0)=MenuMessageBoxShadow1_1
	ShadowsTextures(1)=MenuMessageBoxShadow1_2
	ShadowsTextures(2)=MenuMessageBoxShadow2_1
	ShadowsTextures(3)=MenuMessageBoxShadow2_2
	ShadowWidth=316
	ShadowHeight=154
	ShadowOffsetX=13
	ShadowOffsetY=13
}
