//=============================================================================
// HXMilitaryBot.
//=============================================================================
class HXMilitaryBot extends HXRobot;

var localized String PerforatedBy;
var localized String SnuffedIntoBy;

enum ESkinColor
{
	SC_UNATCO,
	SC_Chinese
};

var() ESkinColor SkinColor;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local MilitaryBot OtherMilitaryBot;

	// Call Super.
	Super.Succeeds( Other );

	// Special MilitaryBot Init.
	OtherMilitaryBot = MilitaryBot(Other);
	if ( OtherMilitaryBot!=None )
	{
		SetPropertyText( "SkinColor", OtherMilitaryBot.GetPropertyText("SkinColor") );
	}
}

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	Super.BeginPlay();

	if ( Role==ROLE_Authority && !IsInRelevant() )
	{
		switch ( SkinColor )
		{
			case SC_UNATCO:  Skin = Texture'MilitaryBotTex1'; break;
			case SC_Chinese: Skin = Texture'MilitaryBotTex2'; break;
		}
	}
}

// ----------------------------------------------------------------------------
// PlayDisabled()
// ----------------------------------------------------------------------------

function PlayDisabled()
{
	switch ( Rand(3) )
	{
		case 0:  TweenAnimPivot( 'Disabled1', 0.2 ); break;
		case 1:  TweenAnimPivot( 'Disabled2', 0.2 ); break;
		default: TweenAnimPivot( 'Still',     0.2 ); break;
	}
}

// ----------------------------------------------------------------------------
// KillMessage()
// ----------------------------------------------------------------------------

function string KillMessage( Name DamageType, Pawn Other )
{
	switch ( DamageType )
	{
		case 'Exploded':
			return SnuffedIntoBy $ NameArticle $ UnfamiliarName $ ".";
			break;

		default:
			return PerforatedBy $ NameArticle $ UnfamiliarName $ ".";
			break;
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	PerforatedBy=" was perforated by "
	SnuffedIntoBy=" was snuffed into the pavement by "
	SearchingSound=MilitaryBotSearching
	SpeechTargetAcquired=MilitaryBotTargetAcquired
	SpeechTargetLost=MilitaryBotTargetLost
	SpeechOutOfAmmo=MilitaryBotOutOfAmmo
	SpeechCriticalDamage=MilitaryBotCriticalDamage
	SpeechScanning=MilitaryBotScanning
	EMPHitPoints=200
	ExplosionSound=MilitaryBotExplode
	WalkingSpeed=1.0
	bEmitDistress=True
	InitialInventory(0)=(Inventory=Class'WeaponRobotMachinegun')
	InitialInventory(1)=(Inventory=Class'Ammo762mm',Count=24)
	InitialInventory(2)=(Inventory=Class'WeaponRobotRocket')
	InitialInventory(3)=(Inventory=Class'AmmoRocketRobot',Count=10)
	WalkSound=MilitaryBotWalk
	GroundSpeed=44.0
	WaterSpeed=50.0
	AirSpeed=144.0
	AccelRate=500.0
	Health=600
	UnderWaterTime=20.0
	AttitudeToPlayer=ATTITUDE_Ignore
	DrawType=DT_Mesh
	Mesh=MilitaryBot
	Skin=MilitaryBotTex1
	CollisionRadius=80.0
	//CollisionHeight=79.0
	CollisionHeight=74.5
	Mass=2000.0
	Buoyancy=100.0
	RotationRate=(Yaw=10000)
	BindName="MilitaryBot"
	FamiliarName="Military Bot"
	UnfamiliarName="Military Bot"
}
