//=============================================================================
// Mission00.
//
// Todo:
//  * Finish resupply code for 00_TrainingCombat
//  * Come up with an idea to either prevent or act on player throwing ressuply
//    crates onto the shooting ranges.
//=============================================================================
class HXMission00 extends HXMissionScript;

var Class<HXScriptedPawn> UNATCOTroopClass, BobPageClass, SecurityBot2Class, JaimeReyesClass;
var Class<HXDecoration>   ContainersClass, CrateBreakableMedGeneralClass, Keypad1Class;
var Class<Inventory>      LockpickClass, MultitoolClass;
var Class<Actor>          LAMClass;

// ----------------------------------------------------------------------------
// LoadClasses()
// ----------------------------------------------------------------------------

function LoadClasses()
{
	Super.LoadClasses();

	// ScriptedPawns.
	UNATCOTroopClass	= LoadScriptedPawnReplacementClass( class'UNATCOTroop' );
	BobPageClass			= LoadScriptedPawnReplacementClass( class'BobPage' );
	SecurityBot2Class	= LoadScriptedPawnReplacementClass( class'SecurityBot2' );
	JaimeReyesClass		= LoadScriptedPawnReplacementClass( class'JaimeReyes' );

	// Decorations.
	ContainersClass   = LoadDecorationReplacementClass( class'Containers' );
	CrateBreakableMedGeneralClass = LoadDecorationReplacementClass( class'CrateBreakableMedGeneral' );
	Keypad1Class      = LoadDecorationReplacementClass( class'Keypad1' );

	// Inventory.
	LockpickClass     = LoadInventoryReplacementClass( class'Lockpick' );
	MultitoolClass    = LoadInventoryReplacementClass( class'Multitool' );

	// Misc.
	LAMClass          = LoadActorReplacementClass( class'LAM' );
}

// ----------------------------------------------------------------------------
// LoadClasses()
// ----------------------------------------------------------------------------

function Class<Actor> GetRelevantClass( Class<Actor> InClass )
{
	// TODO.
	return InClass;
}

// ----------------------------------------------------------------------------
// GiveInitialInventory()
// ----------------------------------------------------------------------------

function GiveInitialInventory( HXPlayerPawn Player, String Portal, String MapURL )
{
}

// ----------------------------------------------------------------------------
// InitSkillPoints()
// ----------------------------------------------------------------------------

static function InitSkillPoints( HXGameInfo Game, HXSteve Steve )
{
	// No skill points in training despite starting bonus.
	Steve.SkillPointsTotal = Game.StartingSkillPointsBonus;
}

// ----------------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------------

function FirstFrame()
{
	local HXScriptedPawn ScriptedPawn;
	local Actor Actor;

	Super.FirstFrame();

	//
	// 00_TRAINING.
	//
	if ( LocalURL=="00_TRAINING" )
	{
		// Knock this guy out
		foreach AllActors( UNATCOTroopClass, Actor, 'Test_Subject' )
		{
			ScriptedPawn = HXScriptedPawn(Actor);
			if ( ScriptedPawn!=None )
			{
				ScriptedPawn.HealthTorso = 0;
				ScriptedPawn.Health = 0;
				ScriptedPawn.bStunned = True;
				ScriptedPawn.TakeDamage( 1, ScriptedPawn, ScriptedPawn.Location, vect(0,0,0), 'KnockedOut' );
			}
		}
	}

	//
	// 00_TRAININGCOMBAT.
	//
	else if ( LocalURL=="00_TRAININGCOMBAT" )
	{
		// Fool a LAM into thinking that a player set it.
		if ( LAMClass!=None )
		{
			foreach AllActors( LAMClass, Actor, 'Bot1LAM' )
			{
				if ( Actor.IsA('HXProjectile') )
					HXProjectile(Actor).bPlayerPlaced = true;
				break;
			}
		}
	}
}

// ----------------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------------

function PreTravel()
{
	Super.PreTravel();
}

// ----------------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------------

function Timer()
{
	local HXBreakableGlass BreakableGlass;
	local HXCoopStart CoopStart;
	local HXContainers Crate;
	local HXPlayerPawn Player;
	local HXMover Mover;
	local Actor Actor;
	local Pawn Pawn;
	local HXSkill Skill;
	local int Count;

	Super.Timer();

	//
	// 00_TRAINING
	//
	if ( LocalURL=="00_TRAINING" )
	{
		// See if the player has picked the door.
		if ( !GetBoolFlag('MS_DoorPicked') )
		{
			foreach AllActors( Class'HXMover', Mover, 'gundoor' )
			{
				if ( !Mover.bLocked )
				{
					SetBoolFlag( 'MS_DoorPicked', True, True, 1 );
					break;
				}
			}
		}

		// See if the player has broken all the crates.
		if ( !GetBoolFlag('MS_AllCratesBroken') && !GetBoolFlag('MS_DoorPicked') )
		{
			Count = 0;
			if ( ContainersClass!=None )
			{
				foreach AllActors( ContainersClass, Actor )
				{
					if ( Actor.Tag=='Cratepick1' || Actor.Tag=='Cratepick2' || Actor.Tag=='PickResupply' )
						Count++;
					if ( Count==2 )
						break;
				}
			}

			// If the player breaks at least one of the crates.
			if ( Count<2 )
			{
				if ( !GetBoolFlag('MS_CratesBroken') )
				{
					StartDataLinkTransmission( "DL_Lockpick" );
					SetBoolFlag( 'MS_CratesBroken', True, True, 1 );
				}

				// If the player has broken all crates.
				if ( Count==0 )
				{
					SetBoolFlag( 'MS_AllCratesBroken', True, True, 1 );
				}
			}
		}

		// Spawn resupply crate with a Lockpick in it if the doors have not been picked 
		// yet, all crates have been broken and there are no lockpicks anymore.
		if ( !GetBoolFlag('MS_DoorPicked') && GetBoolFlag('MS_AllCratesBroken') )
		{
			if ( !ActorsExist(LockpickClass) )
			{
				Log( "Subjects failed to effectively utilize lockpick assets in achievement of goal." );

				// Find spawn location.
				CoopStart = GetCoopStart( 'ResupplyDrop' );

				Crate = HXContainers(Spawn( CrateBreakableMedGeneralClass, None, 'PickResupply', CoopStart.Location ));
				if ( Crate!=None )
				{
					// Put a lockpick in.
					Crate.NumThings = 1;
					Crate.Contents = LockpickClass;
					Crate.Content2 = None;
					Crate.Content3 = None;

					// Reset all broken flag.
					SetBoolFlag( 'MS_AllCratesBroken', False, True, 1 );
				}
			}
		}

		// After players finally passed the lockpicking..
		if ( GetBoolFlag('MS_DoorPicked') )
		{
			// Check if keypad was hacked.
			if ( !GetBoolFlag('MS_KeypadHacked') )
			{
				if ( Keypad1Class!=None )
					foreach AllActors( Keypad1Class, Actor, 'Keypad1' )
						if ( Actor.Event=='hackdoor' )
							SetBoolFlag( 'MS_KeypadHacked', True, True, 1 );
			}

			// Spawn resupply crate with a Multitool in it if the keypad has not been hacked yet,
			// resupply crate does not exist and there are no multitools anymore.
			if ( !GetBoolFlag('MS_KeypadHacked') && !ActorsExist(MultitoolClass) && !ActorsExist(Class'HXContainers','HackResupply') )
			{
				Log( "Subjects failed to effectively utilize multitool assets in achievement of goal." );

				// Find spawn location.
				CoopStart = GetCoopStart( 'ResupplyDrop' );

				Crate = HXContainers(Spawn( CrateBreakableMedGeneralClass, None, 'HackResupply', CoopStart.Location ));
				if ( Crate!=None )
				{
					// Put a lockpick in.
					Crate.NumThings = 1;
					Crate.Contents = MultitoolClass;
					Crate.Content2 = None;
					Crate.Content3 = None;
				}
			}
		}
	}

	//
	// 00_TRAININGCOMBAT
	//
	else if ( LocalURL=="00_TRAININGCOMBAT" )
	{
		// Start a datalink when first bot is destroyed.
		if ( !GetBoolFlag('MS_LAMBot1Destroyed') )
		{
			if ( !PawnsExist(SecurityBot2Class,'LAMBot1') )
			{
				StartDataLinkTransmission( "DL_ReleaseBot2" );
				SetBoolFlag( 'MS_LAMBot1Destroyed', True, True, 1 );
			}
		}

		// Start a datalink when second bot is destroyed.
		if ( !GetBoolFlag('MS_LAMBot2Destroyed') )
		{
			if ( !PawnsExist(SecurityBot2Class,'LAMBot2') )
			{
				StartDataLinkTransmission( "DL_DemolitionLast" );
				SetBoolFlag( 'MS_LAMBot2Destroyed', True, True, 1 );
			}
		}

		// Start a datalink when all LAMs are destroyed.
		if ( !GetBoolFlag('MS_LAMsDestroyed') )
		{
			if ( !ActorsExist(LAMClass,'DefuseLAM') )
			{
				StartDataLinkTransmission( "DL_DefuseFinish" );
				SetBoolFlag( 'MS_LAMsDestroyed', True, True, 1 );
			}
		}

		// Max out the player's rifle skill.
		if ( GetBoolFlag('DL_RifleRangeShot1_Played') && !GetBoolFlag('MS_SkillIncreased') )
		{
			for( Pawn=Level.PawnList; Pawn!=None; Pawn=Pawn.NextPawn )
			{
				if( Pawn.bIsPlayer )
				{
					Player = HXPlayerPawn(Pawn);

					if ( Player!=None && Player.SkillSystem!=None )
					{
						Skill = HXSkill(Player.SkillSystem.GetSkillFromClass( Class'HXSkillWeaponRifle') );
						if ( Skill!=None )
							Skill.CurrentLevel = 3;
					}
				}
			}
			SetBoolFlag( 'MS_SkillIncreased', True, True, 1 );
		}

		// Set flags for the broken targets.
		if ( !GetBoolFlag('MS_AllTargetsDone') )
		{
			foreach AllActors( Class'HXBreakableGlass', BreakableGlass )
			{
				if ( BreakableGlass.bDestroyed )
				{
					switch ( BreakableGlass.Event )
					{
						case 'shootplay':
							if ( !GetBoolFlag('MS_ShootPlay') )
								SetBoolFlag( 'MS_ShootPlay', True, True, 1 );
							break;

						case 'shootplay2':
							if ( !GetBoolFlag('MS_ShootPlay2') )
								SetBoolFlag( 'MS_ShootPlay2', True, True, 1 );
							break;

						case 'rifleshot1':
							if ( !GetBoolFlag('MS_RifleShot') )
								SetBoolFlag( 'MS_RifleShot', True, True, 1 );
							break;

						case 'rifleshot2':
							if ( !GetBoolFlag('MS_RifleShot2') )
								SetBoolFlag( 'MS_RifleShot2', True, True, 1 );
							break;

						default:
							break;
					}
				}
			}

			// Check if all pistol targets are done.
			if ( !GetBoolFlag('MS_AllShootPlay') )
			{
				if ( GetBoolFlag('MS_ShootPlay') && GetBoolFlag('MS_ShootPlay2') )
				{
					SetBoolFlag( 'MS_AllShootPlay', True, True, 1 );
				}
			}

			// Check if all rifle targets are done.
			if ( !GetBoolFlag('MS_AllRifleShot') )
			{
				if ( GetBoolFlag('MS_RifleShot') && GetBoolFlag('MS_RifleShot2') )
				{
					SetBoolFlag( 'MS_AllRifleShot', True, True, 1 );
				}
			}

			// Set a flag if all targets are done so we don't need to check anymore.
			if ( GetBoolFlag('MS_AllShootPlay') && GetBoolFlag('MS_AllRifleShot') )
			{
				SetBoolFlag( 'MS_AllTargetsDone', True, True, 1 );
			}
		}


	}

	//
	// 00_TRAININGFINAL
	//
	else if ( LocalURL=="00_TRAININGFINAL" )
	{
		// Unhide holo-Jaime.
		if ( GetBoolFlag('JaimeAppears') && !GetBoolFlag('MS_ReyesUnhidden') )
		{
			PawnsEnterWorld( JaimeReyesClass, 'holojaime', True );
			SetBoolFlag( 'MS_ReyesUnhidden', True, True, 1 );
		}

		// Hide holo-Jaime
		if ( GetBoolFlag('JaimeBark_Played') && !GetBoolFlag('MS_ReyesHidden') )
		{
			PawnsLeaveWorld( JaimeReyesClass, 'holojaime', True );
			SetBoolFlag( 'MS_ReyesHidden', True, True, 1 );
		}

		// Hide holo-Bob.
		if ( GetBoolFlag('M00MeetPage_Played') && !GetBoolFlag('MS_PageHidden') )
		{
			PawnsLeaveWorld( BobPageClass );
			SetBoolFlag( 'MS_PageHidden', True, True, 1 );
		}
	}
}

// ----------------------------------------------------------------------------
// PreventDeath()
// ----------------------------------------------------------------------------

function PreventDeath( Pawn Pawn )
{
	local HXPlayerPawn Player;

	if ( Pawn!=None && Pawn.bIsPlayer )
		Player = HXPlayerPawn(Pawn);

	if ( Player!=None )
	{
		Player.HealthTorso = FMax( Player.HealthTorso, 10 );
		Player.HealthHead  = FMax( Player.HealthHead,  10 );
		Player.GenerateTotalHealth();
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
}
