//=============================================================================
// HXMission01.
//=============================================================================
class HXMission01 expands HXMissionScript;

var Class<HXScriptedPawn> UNATCOTroopClass, PaulDentonClass, TerroristCommanderClass,
                          ThugMale2Class, SecurityBot3Class, TerroristClass;
var Class<HXCarcass>      TerroristCarcassClass, ThugMale2CarcassClass;

// ----------------------------------------------------------------------------
// LoadClasses()
// ----------------------------------------------------------------------------

function LoadClasses()
{
	Super.LoadClasses();

	// ScriptedPawns.
	UNATCOTroopClass	      = LoadScriptedPawnReplacementClass( class'UNATCOTroop' );
	PaulDentonClass			    = LoadScriptedPawnReplacementClass( class'PaulDenton' );
	TerroristCommanderClass	= LoadScriptedPawnReplacementClass( class'TerroristCommander' );
	ThugMale2Class	        = LoadScriptedPawnReplacementClass( class'ThugMale2' );
	SecurityBot3Class	      = LoadScriptedPawnReplacementClass( class'SecurityBot3' );
	TerroristClass	        = LoadScriptedPawnReplacementClass( class'Terrorist' );

	// Carcasses.
	TerroristCarcassClass   = LoadCarcassReplacementClass( class'TerroristCarcass' );
	ThugMale2CarcassClass   = LoadCarcassReplacementClass( class'ThugMale2Carcass' );
}

// ----------------------------------------------------------------------------
// RandomizeEvents()
//
// Randomizes what happened at this Mission, so one would not start blank
// with what happened in prior mission.
//
// Notes:
//  * What about the ('UN_maindoor',"UNATCO HQ Blast Doors") Key Paul carries?
//  * As Troopers have unique names, one could randomly kill some of them...
//
// Todo:
//  * Notes, etc.
// ----------------------------------------------------------------------------

static function RandomizeEvents( HXGameInfo Game, HXSteve Steve, int MissionNumber, String MapName )
{
	Super.RandomizeEvents( Game, Steve, MissionNumber, MapName );

	// Paul gives you a map of the island.
	Game.AddImage( Class'Image01_LibertyIsland' );

	// NanoKey for Compound hatch, hidden behind com container.
	if ( FRand()<0.75 )
	{
		Game.GiveKey( 'UNhatchdoor', "UNATCO Compound Hatch", True );
	}

	// Player wrecked havoc..
	if ( FRand()<0.5 )
	{
		Steve.FlagBase.SetBool( 'M01PlayerAggressive', True, True, 6 );
	}

	// What we did about Gunther.
	if ( FRand()<0.75 )
	{
		Steve.FlagBase.SetBool( 'GuntherFreed', True, True, 0 );

		// Gunther respects player if player has given him a weapon or did 
		// not had any weapon he could have given to gunther.
		Steve.FlagBase.SetBool( 'GuntherRespectsPlayer', FRand()<0.25, True, 0 );
	}

	// If we met Filben.
	if ( FRand()<0.66 )
	{
		Steve.FlagBase.SetBool( 'M01PlayerMetFilben', True, True, 0 );
		Steve.FlagBase.SetBool( 'PlayerMetFilben', True, True, 0 );

		// Filben gives you an image of the TerroristCommander at start of conversation.
		Game.AddImage( Class'Image01_TerroristCommander' );

		// If Filben gave us the Key.
		if ( FRand()<0.75 )
		{
			Steve.FlagBase.SetBool( 'FilbenGaveKey', True, True, 0 );
			Game.GiveKey( 'ruin_key', "Statue Ruin Key", True );
		}
		else
		{
			Steve.FlagBase.SetBool( 'FilbenGaveKey', False, True, 0 );
		}
	}

	// What we did about TerroristCommander.
	if ( FRand()<0.2 )
	{
		// Player attacks.
		Steve.FlagBase.SetBool( 'PlayerAttackedStatueTerrorist', True, True, 0 );
		Steve.FlagBase.SetBool( 'TerroristCommander_Dead', True, True, 0 );
	
		// 50% chance we did not kill him.
		Steve.FlagBase.SetBool( 'TerroristCommander_Unconscious', FRand()<0.5, True, 0 );
	}
	else
	{
		// Unharmed.
		//Steve.FlagBase.SetBool( 'PlayerAttackedStatueTerrorist', False, True, 0 );
	}

	// Key on secretary desk. Hard to miss.
	if ( FRand()<0.95 )
	{
		Game.GiveKey( 'UNcloset', "UNATCO Closet Key Code", True );
	}

	// Key hidden in one of the top offices and in hidden floor in hackers room.
	if ( FRand()<0.9 )
	{
		Game.GiveKey( 'UNOfficeDoorKey', "Office Door Key Code", True );
	}

	// Medical locker key found behind plant in Jamies office.
	if ( FRand()<0.8 )
	{
		Game.GiveKey( 'JaimeClosetKey', "MedLab Closet Key Code", True );
	}

	// If player was "unprofessional".
	if ( FRand()<0.5 )
		Steve.FlagBase.SetBool( 'BathroomBarks_Played', True, True, 0 );
}

// ----------------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------------

function FirstFrame()
{
	Super.FirstFrame();

	//
	// 01_NYC_UNATCOISLAND
	//
	if ( LocalURL=="01_NYC_UNATCOISLAND" )
	{
		// Delete Paul and company after final briefing.
		if ( GetBoolFlag('M02Briefing_Played') )
		{
			DestroyActors( PaulDentonClass );
			DestroyActors( UNATCOTroopClass, 'custodytroop' );
			DestroyActors( TerroristCommanderClass, 'TerroristCommander' );
		}
	}
}

// ----------------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------------

function PreTravel()
{
	Super.PreTravel();
}

// ----------------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------------

function Timer()
{
	local HXSecurityCamera SecurityCamera;
	local HXLaserTrigger LaserTrigger;
	local HXScriptedPawn ScriptedPawn;
	local HXAutoTurret AutoTurret;
	local HXCarcass Carcass;
	local HXMover Mover;
	local SpawnPoint SpawnPoint;
	local Inventory Item, NextItem;
	local Actor Actor;
	local int Count;

	Super.Timer();

	//
	// 01_NYC_UNATCOISLAND
	//
	if ( LocalURL=="01_NYC_UNATCOISLAND" )
	{
		// Count the number of dead terrorists.
		if ( !GetBoolFlag('M01PlayerAggressive') )
		{
			// Count the living.
			// There are 29 Terrorists total on the island.
			// There are 5 ThugMale2 total on the island.
			// There is 1 TerroristCommander on the island.
			Count = 0;
			foreach AllActors( Class'HXScriptedPawn', ScriptedPawn )
				if ( ClassIsChildOf(ScriptedPawn.Class,TerroristClass) || ClassIsChildOf(ScriptedPawn.Class,ThugMale2Class) )
					Count++;

			// Add the unconscious ones to the not dead count,
			foreach AllActors( Class'HXCarcass', Carcass )
			{
				if ( ClassIsChildOf(Carcass.Class,TerroristCarcassClass) || ClassIsChildOf(Carcass.Class,ThugMale2CarcassClass) )
				{
					if ( Carcass.KillerBindName=="JCDenton" && InStr(Carcass.ItemName,"Unconscious")!=-1 )
						Count++;
					else if ( Carcass.KillerBindName!="JCDenton" )
						Count++;
				}
			}

			// If commander is not dead count him too.
			if ( !GetBoolFlag('TerroristCommander_Dead') )
				Count++;

			// If the player killed more than 5, set the flag.
			if ( Count<(29+5+1-5) )
				SetBoolFlag( 'M01PlayerAggressive', True, True, 6 ); // Don't expire until mission 6.
		}

		// Check for the leader being killed.
		if ( !GetBoolFlag('MS_DL_Played') )
		{
			if ( GetBoolFlag('TerroristCommander_Dead') )
			{
				if ( !GetBoolFlag('DL_LeaderNotKilled_Played') )
				{
					StartDataLinkTransmission( "DL_LeaderKilled" );
				}
				else
				{
					StartDataLinkTransmission( "DL_LeaderKilledInSpite" );
				}

				SetBoolFlag( 'MS_DL_Played', True, True, 2 );
			}
		}

		// check for player not killing leader
		if ( !GetBoolFlag('PlayerAttackedStatueTerrorist') && GetBoolFlag('MeetTerrorist_Played') && !GetBoolFlag('MS_DL2_Played') )
		{
			StartDataLinkTransmission( "DL_LeaderNotKilled" );
			SetBoolFlag( 'MS_DL2_Played', True, True, 2 );
		}

		// Remove guys and move Paul.
		if ( !GetBoolFlag('MS_MissionComplete') )
		{
			if ( GetBoolFlag('StatueMissionComplete') )
			{
				// Open the HQ blast doors and unlock some other doors.
				UnlockMovers( Class'HXMover', 'UN_maindoor', True, None, None );
				UnlockMovers( Class'HXMover', 'StatueRuinDoors' );
				UnlockMovers( Class'HXMover', 'temp_celldoor' );

				// Unhide the troop, delete the terrorists, Gunther, and teleport Paul.
				foreach AllActors( Class'HXScriptedPawn', ScriptedPawn )
				{
					if ( (ScriptedPawn.BindName=="custodytroop" || ScriptedPawn.BindName=="postmissiontroops") && ScriptedPawn.IsA('HXUNATCOTroop') )
					{
						ScriptedPawn.EnterWorld();
					}
					else if ( ScriptedPawn.IsA('HXTerrorist') || ScriptedPawn.IsA('HXThugMale2') )
					{
						// Delete their inventories first.
						if ( ScriptedPawn.Inventory!=None )
						{
							do
							{
								Item = ScriptedPawn.Inventory;
								NextItem = Item.Inventory;
								ScriptedPawn.DeleteInventory(item);
								Item.Destroy();
								Item = NextItem;
							}
							until ( Item==None );
						}

						// Actually kill the terrorists instead of destroying them.
						// NOTE: Maybe vary their death pose a bit.
						ScriptedPawn.HealthTorso = 0;
						ScriptedPawn.Health      = 0;
						ScriptedPawn.TakeDamage( 1, ScriptedPawn, ScriptedPawn.Location, vect(0,0,0), 'Shot' );
					}
					else if ( ScriptedPawn.IsA('HXSecurityBot3') || ScriptedPawn.BindName=="GuntherHermann" )
					{
						ScriptedPawn.Destroy();
					}
					else if ( ScriptedPawn.BindName=="PaulDenton" )
					{
						SpawnPoint = GetSpawnPoint('PaulTeleport');
						if ( SpawnPoint!=None )
						{
							ScriptedPawn.SetLocation( SpawnPoint.Location );
							ScriptedPawn.SetRotation( SpawnPoint.Rotation );
							ScriptedPawn.SetOrders( 'Standing', , True );
							ScriptedPawn.SetHomeBase( SpawnPoint.Location, SpawnPoint.Rotation );
						}
					}
				}

				// Delete all tagged turrets.
				foreach AllActors( Class'HXAutoTurret', AutoTurret )
					if ( AutoTurret.Tag =='NSFTurret01' || AutoTurret.Tag=='NSFTurret02' )
						AutoTurret.Destroy();

				// Delete all tagged lasertriggers.
				foreach AllActors( Class'HXLaserTrigger', LaserTrigger, 'statue_lasertrap' )
					LaserTrigger.Destroy();

				// Turn off all tagged cameras.
				foreach AllActors( Class'HXSecurityCamera', SecurityCamera )
					if ( SecurityCamera.Tag=='NSFCam01' || SecurityCamera.Tag=='NSFCam02' || SecurityCamera.Tag=='NSFCam03' )
						SecurityCamera.bNoAlarm = True;

				SetBoolFlag( 'MS_MissionComplete', True, True, 2 );
			}
		}
	}

	//
	// 01_NYC_UNATCOHQ
	//
	else if ( LocalURL=="01_NYC_UNATCOHQ" )
	{
		// Unhide Paul.
		if ( !GetBoolFlag('MS_ReadyForBriefing') && GetBoolFlag('M01ReadyForBriefing') )
		{
			PawnsEnterWorld( PaulDentonClass, '', True );
			SetBoolFlag( 'MS_ReadyForBriefing', True, True, 2 );
		}
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	PrevMissionScript=None
	NextMissionScript=Class'HX.HXMission02'
}
