//=============================================================================
// HXMission02.
//=============================================================================
class HXMission02 expands HXMissionScript;

var Class<HXScriptedPawn> TerroristClass, UNATCOTroopClass, DoctorClass, GuntherHermannClass,
                          ThugMaleClass, ThugMale2Class, FordSchickClass, SandraRentonClass,
													BumMaleClass, BumFemaleClass;
var Class<HXDecoration>   BlackHelicopterClass;
var Class<HXCarcass>      TerroristCarcassClass;

// ----------------------------------------------------------------------------
// LoadClasses()
// ----------------------------------------------------------------------------

function LoadClasses()
{
	Super.LoadClasses();

	// ScriptedPawns.
	TerroristClass	        = LoadScriptedPawnReplacementClass( class'Terrorist' );
	UNATCOTroopClass	      = LoadScriptedPawnReplacementClass( class'UNATCOTroop' );
	DoctorClass			        = LoadScriptedPawnReplacementClass( class'Doctor' );
	GuntherHermannClass	    = LoadScriptedPawnReplacementClass( class'GuntherHermann' );
	ThugMaleClass	          = LoadScriptedPawnReplacementClass( class'ThugMale' );
	ThugMale2Class	        = LoadScriptedPawnReplacementClass( class'ThugMale2' );
	FordSchickClass	        = LoadScriptedPawnReplacementClass( class'FordSchick' );
	SandraRentonClass       = LoadScriptedPawnReplacementClass( class'SandraRenton' );
	BumMaleClass	          = LoadScriptedPawnReplacementClass( class'BumMale' );
	BumFemaleClass	        = LoadScriptedPawnReplacementClass( class'BumFemale' );

	// Decorations,
	BlackHelicopterClass    = LoadDecorationReplacementClass( class'BlackHelicopter' );

	// Carcasses.
	TerroristCarcassClass   = LoadCarcassReplacementClass( class'TerroristCarcass' );
}

// ----------------------------------------------------------------------------
// RandomizeEvents()
//
// Randomizes what happened at this Mission, so one would not start blank
// with what happened in prior mission.
//
// Notes:
//
// Todo:
//  * Everything.
//  * Notes, etc.
// ----------------------------------------------------------------------------

static function RandomizeEvents( HXGameInfo Game, HXSteve Steve, int MissionNumber, String MapName )
{
	Super.RandomizeEvents( Game, Steve, MissionNumber, MapName );

	// Anna gives you the ambrosia barrel schematics in first conversation.
	Game.AddImage( Class'Image02_Ambrosia_Flyer' );

	// TODO.
}

// ----------------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------------

function FirstFrame()
{
	local HXScriptedPawn ScriptedPawn;
	local Actor Actor;

	Super.FirstFrame();

	//
	// All
	// 
	if ( GetBoolFlag('FordSchickRescued') )
	{
		// Hack to prevent this flag to expire premature.
		Steve.Flagbase.SetExpiration( 'FordSchickRescued', FLAG_Bool, 9 );
	}

	//
	// 02_NYC_STREET
	//
	if ( LocalURL=="02_NYC_STREET" )
	{
		SetBoolFlag( 'M02StreetLoaded', True, True, 3 );

		// If you went to the warehouse without finishing the streets set some flags.
		if ( !GetBoolFlag('MS_GuardsWandering') && GetBoolFlag('WarehouseDistrictEntered') )
		{
			if ( !GetBoolFlag('StreetOpened') || !GetBoolFlag('ClinicCleared') )
			{
				foreach AllActors( Class'HXScriptedPawn', ScriptedPawn )
					if ( ScriptedPawn.Tag=='ClinicGuards' || ScriptedPawn.Tag=='HotelGuards' )
						ScriptedPawn.SetOrders( 'Wandering', '', True );
			}

			SetBoolFlag( 'MS_GuardsWandering', True, True, 3 );
		}

		// Manderley will be disappointed if you don't finish the streets.
		if ( !GetBoolFlag('M02ManderleyDisappointed') && !GetBoolFlag('BatteryParkComplete') )
		{
			SetBoolFlag( 'M02ManderleyDisappointed', True, True, 3 );
		}

		// Get rid of Sandra if you've talked to her already.
		if ( GetBoolFlag('MeetSandraRenton_Played') )
		{
			if ( SandraRentonClass!=None )
				foreach AllActors( SandraRentonClass, Actor )
					Actor.Destroy();
		}

		// Unhide some hostages if you've rescued them.
		if ( GetBoolFlag('EscapeSuccessful') )
		{
			foreach AllActors( Class'HXScriptedPawn', ScriptedPawn )
				if ( (ScriptedPawn.Tag=='hostageMan' && ClassIsChildOf(ScriptedPawn.Class,BumMaleClass)) || (ScriptedPawn.Tag=='hostageWoman' && ClassIsChildOf(ScriptedPawn.Class,BumFemaleClass)) )
					ScriptedPawn.EnterWorld();
		}
	}

	//
	// 02_NYC_BAR
	//
	else if ( LocalURL=="02_NYC_BAR" )
	{
		// Unhide Sandra if you've talked to her already.
		if ( GetBoolFlag('MeetSandraRenton_Played') )
		{
			if ( SandraRentonClass!=None )
			{
				foreach AllActors( SandraRentonClass, Actor )
				{
					HXScriptedPawn(Actor).EnterWorld();
					SetBoolFlag( 'MS_SandraInBar', True, True, 3 );
				}
			}
		}
	}

	//
	// 02_NYC_SMUG
	//
	else if ( LocalURL=="02_NYC_SMUG" )
	{
		// Unhide Ford if you've rescued him.
		if ( GetBoolFlag('FordSchickRescued') )
		{
			//
			// Notes:
			//  * Schick ins not in 02_NYC_SMUG
			//  * They probably gave the aug first in 02 and moved to 08.
			//  * SchickThankedPlayer gets set by Conversation (SchickThanks).
			PawnsEnterWorld( FordSchickClass, '', True );
			SetBoolFlag( 'SchickThankedPlayer', True, True, 9 );
		}
	}
}

// ----------------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
//
// HX_HAN: This seems to be never called.
// ----------------------------------------------------------------------------

function PreTravel()
{
	//
	// 02_NYC_BATTERYPARK
	//
	if ( LocalURL=="02_NYC_BATTERYPARK" )
	{
		// If you leave without finishing, set some flags and remove the terrorists.
		if ( !GetBoolFlag('MS_MapLeftEarly') && (!GetBoolFlag('AmbrosiaTagged') || !GetBoolFlag('SubTerroristsDead')) )
		{
			SetBoolFlag( 'MS_MapLeftEarly', True, True, 3 );
		}
	}

	//
	// 02_NYC_UNDERGROUND
	//
	else if ( LocalURL=="02_NYC_UNDERGROUND" )
	{
		// If you leave the level with Ford Schick, set a flag.
		if ( GetBoolFlag('MS_FordFollowing') && !GetBoolFlag('FordSchick_Dead') )
		{
			SetBoolFlag( 'FordSchickRescued', True, True, 9 );
		}
	}

	Super.PreTravel();
}

// ----------------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------------

function Timer()
{
	local HXCarcass Carcass;
	local Actor Actor, Other;
	local Pawn Pawn, OtherPawn;
	local float Dist, MaxDist;
	local int Count;

	Super.Timer();

	//
	// 02_NYC_BATTERYPARK
	//
	if ( LocalURL=="02_NYC_BATTERYPARK" )
	{
		// After terrorists are dead, set guards to wandering.
		if (!GetBoolFlag('BatteryParkSlaughter'))
		{
			// Count the number of living terrorists.
			Count = 0;
			if ( TerroristClass!=None )
				foreach AllActors( TerroristClass, Actor, 'ClintonTerrorist' )
					Count++;

			// Count the number of unconscious terrorists.
			if ( TerroristCarcassClass!=None )
				foreach AllActors( TerroristCarcassClass, Actor, 'ClintonTerrorist' )
					if ( InStr(HXCarcass(Actor).ItemName,"Unconscious")!=-1 )
						Count++;

			// There are 5 total, (player) must have killed 2 or more, so
			// check to see if there are fewer than 3 still alive or unconscious
			if ( Count<=3 )
			{
				if ( UNATCOTroopClass!=None )
					foreach AllActors( UNATCOTroopClass, Actor, 'ClintonGuard' )
						HXScriptedPawn(Actor).SetOrders( 'Wandering', '', True );

				SetBoolFlag( 'BatteryParkSlaughter', True, True, 6 );
			}
		}

		// set guards to wandering after sub terrorists are dead
		if ( !GetBoolFlag('SubTerroristsDead') )
		{
			Count = 0;
			if ( TerroristClass!=None )
				foreach AllActors( TerroristClass, Actor, 'SubTerrorist' )
					Count++;

			if ( Count==0 )
			{
				if ( UNATCOTroopClass!=None )
					foreach AllActors( UNATCOTroopClass, Actor, 'SubGuards' )
						HXScriptedPawn(Actor).SetOrders( 'Wandering', '', True );

				CompleteGoal( 'LiberateBatteryParkSubway' );
				SetBoolFlag( 'SubTerroristsDead', True, True, 6 );
			}
		}

		// Check to see if hostages are dead.
		if ( !GetBoolFlag('HostagesKilled') && GetBoolFlag('SubHostageMale_Dead') && GetBoolFlag('SubHostageFemale_Dead') )
		{
			SetBoolFlag( 'HostagesKilled', True, True, 3 );
		}

		// Check a bunch of flags, and start a datalink
		if ( !GetBoolFlag('MS_MapLeftEarly') && !GetBoolFlag('MS_DL_Played') )
		{
			if ( !GetBoolFlag('SubTerroristsDead') && GetBoolFlag('EscapeSuccessful') &&  !GetBoolFlag('HostagesKilled') )
			{
				StartDataLinkTransmission( "DL_SubwayComplete3" );
				SetBoolFlag( 'MS_DL_Played', True, True, 3 );
			}
			else if ( GetBoolFlag('HostagesKilled') )
			{
				StartDataLinkTransmission( "DL_SubwayComplete2" );
				SetBoolFlag( 'MS_DL_Played', True, True, 3 );
			}
			else if ( GetBoolFlag('SubTerroristsDead') || GetBoolFlag('EscapeSuccessful') )
			{
				StartDataLinkTransmission( "DL_SubwayComplete" );
				SetBoolFlag( 'MS_DL_Played', True, True, 3 );
			}
		}

		if ( !GetBoolFlag('ShantyTownSecure') )
		{
			// Count shanty terrorists.
			Count = 0;
			if ( TerroristClass!=None )
			{
				foreach AllActors( TerroristClass, Actor )
				{
					// In code ShantyTerrorists was used but in maps ShantyTerrorist.
					if ( Actor.Tag=='ShantyTerrorist' || Actor.Tag=='ShantyTerrorists' )
						Count++;
				}
			}

			if ( Count==0 )
				SetBoolFlag('ShantyTownSecure', True, True, 3 );
		}
	}

	//
	// 02_NYC_STREET
	//
	else if ( LocalURL=="02_NYC_STREET" )
	{
		// Set guards to wandering after clinc terrorists are dead.
		if ( !GetBoolFlag('ClinicCleared') )
		{
			Count = 0;
			if ( TerroristClass!=None )
				foreach AllActors( TerroristClass, Actor, 'ClinicTerrorist' )
					Count++;

			if ( Count==0 )
			{
				if ( UNATCOTroopClass!=None )
					foreach AllActors( UNATCOTroopClass, Actor, 'ClinicGuards')
						HXScriptedPawn(Actor).SetOrders( 'Wandering', '', True );

				SetBoolFlag('ClinicCleared', True, True, 6);
			}
		}

		// Set guards to wandering after street terrorists are dead.
		if ( !GetBoolFlag('StreetOpened') )
		{
			Count = 0;
			if ( TerroristClass!=None )
				foreach AllActors( TerroristClass, Actor, 'StreetTerrorist' )
					Count++;

			if ( Count==0 )
			{
				if ( UNATCOTroopClass!=None )
					foreach AllActors( UNATCOTroopClass, Actor, 'HotelGuards' )
						HXScriptedPawn(Actor).SetOrders( 'Wandering', '', True );

				SetBoolFlag('StreetOpened', True, True, 6);

				// there are 5 terrorists total
				// if player killed 3 or more, call it a slaughter
				// TODO: Make this more reliable, as this does not account for gibbed.
				if ( TerroristCarcassClass!=None )
				{
					foreach AllActors( TerroristCarcassClass, Actor, 'StreetTerrorist' )
					{
						Carcass = HXCarcass(Actor);
						if ( Carcass.KillerBindName=="JCDenton" && InStr(Carcass.ItemName,"Unconscious")!=-1 )
							Count++;
					}
				}

				if ( Count>=3 )
					SetBoolFlag( 'TenderloinSlaughter', True, True, 6 );
			}
		}

		// Check to see if player rescued bum.
		if ( !GetBoolFlag('MS_ThugsDead') )
		{
			Count = 0;
			if ( ThugMale2Class!=None )
				foreach AllActors( ThugMale2Class, Actor, 'AlleyThug')
					Count++;

			// Set the resuced flag if the bum is still alive.
			if ( Count==0 )
			{
				if ( BumMaleClass!=None )
				{
					foreach AllActors( BumMaleClass, Actor, 'AlleyBum' )
					{
						SetBoolFlag('AlleyBumRescued', True, True, 3);
						break;
					}
				}

				SetBoolFlag('MS_ThugsDead', True, True, 3);
			}
		}

		// If the pimp is dead, set a flag.
		if ( !GetBoolFlag('SandrasPimpDone') )
		{
			Count = 0;
			if ( ThugMaleClass!=None )
				foreach AllActors( ThugMaleClass, Actor, 'Pimp' )
					Count++;

			if ( Count==0 )
			{
				SetBoolFlag( 'SandrasPimpDone', True, True, 3 );
				CompleteGoal( 'HelpJaneysFriend' );
			}
		}

		// If Sandra is dead, set a flag.
		if ( !GetBoolFlag('MS_SandraDead') )
		{
			Count = 0;
			if ( SandraRentonClass!=None )
				foreach AllActors( SandraRentonClass, Actor )
					Count++;

			if ( Count==0 )
			{
				SetBoolFlag( 'MS_SandraDead', True, True, 3 );
				CompleteGoal( 'HelpJaneysFriend' );
			}
		}

		if ( GetBoolFlag('OverhearAlleyThug_Played') && !GetBoolFlag('MS_ThugAttacks') )
		{
			foreach AllActors( Class'Actor', Actor, 'ThugAttacks' )
			{
				// Figure out nearest player to attack.
				OtherPawn = None;
				MaxDist   = 9999999.9;
				for ( Pawn=Level.PawnList; Pawn!=None; Pawn=Pawn.NextPawn )
				{
					if ( Pawn.bIsPlayer )
					{
						Dist = VSize(Actor.Location-Pawn.Location);
						
						if ( Dist<MaxDist )
						{
							OtherPawn = Pawn;
							MaxDist   = Dist;
						}
					}
				}
				// Just try this once.
				if ( OtherPawn!=None )
					Actor.Trigger( Self, OtherPawn );
				break;
			}
			SetBoolFlag( 'MS_ThugAttacks', True, True, 3 );
		}
	}

	//
	// 02_NYC_WAREHOUSE
	//
	else if ( LocalURL=="02_NYC_WAREHOUSE" )
	{
		// Start infolink after generator blown and also unhide the helicopter and Gunther on the roof.
		if ( !GetBoolFlag('MS_GeneratorStuff') && !GetBoolFlag('DL_Pickup_Played') && GetBoolFlag('GeneratorBlown') )
		{
			StartDataLinkTransmission( "DL_Pickup" );
			DecorationsEnterWorld( BlackHelicopterClass, 'Helicopter', True );
			PawnsEnterWorld( GuntherHermannClass, '', True );
			SetBoolFlag( 'MS_GeneratorStuff', True, True, 3 );
		}
	}

	//
	// 02_NYC_FREECLINIC
	//
	else if ( LocalURL=="02_NYC_FREECLINIC" )
	{
		// Make the bum disappear when he gets to his destination.
		if ( GetBoolFlag('MS_BumLeaving') && !GetBoolFlag('MS_BumRemoved') )
		{
			if ( BumMaleClass!=None )
				foreach AllActors( BumMaleClass, Actor, 'SickBum1' )
					if ( Actor.IsInState('Standing') )
						Actor.Destroy();

			SetBoolFlag( 'MS_BumRemoved', True, True, 3 );
			DeleteBoolFlag( 'MS_BumLeaving' );
		}

		// Make the bum leave after talking to the doctor.
		if ( GetBoolFlag('Doctor2_Saved') && !GetBoolFlag('MS_BumRemoved') && !GetBoolFlag('MS_BumLeaving') )
		{
			if ( BumMaleClass!=None )
				foreach AllActors( BumMaleClass, Actor, 'SickBum1' )
					HXScriptedPawn(Actor).SetOrders( 'GoingTo', 'SickBumDestination', True );

			SetBoolFlag( 'MS_BumLeaving', True, True, 3 );
		}

		// Make the bum face the doctor.
		if ( GetBoolFlag('SickBumInterrupted_Played') && !GetBoolFlag('Doctor2_Saved') && !GetBoolFlag('MS_BumTurned') )
		{
			// Holy shit.
			if ( DoctorClass!=None && BumMaleClass!=None )
			{
				foreach AllActors( DoctorClass, Other, 'Doctor2')
				{
					foreach AllActors( BumMaleClass, Actor, 'SickBum1')
					{
						Actor.DesiredRotation = Rotator(Other.Location - Actor.Location);
						break;
					}
				}
			}

			SetBoolFlag( 'MS_BumTurned', True, True, 3 );
		}
	}

	//
	// 02_NYC_BAR
	//
	else if ( LocalURL=="02_NYC_BAR" )
	{
		// If the player kills anybody in the bar, set a flag.
		if ( !GetBoolFlag('M02ViolenceInBar') )
		{
			// NOTE: What about exploding them?
			Count = 0;
			foreach AllActors( Class'HXCarcass', Carcass )
				Count++;

			if ( Count>0 )
				SetBoolFlag( 'M02ViolenceInBar', True, True, 4 );
		}
	}

	//
	// 02_NYC_HOTEL
	//
	else if ( LocalURL=="02_NYC_HOTEL" )
	{
		// If the player kills all the terrorists, set a flag.
		if ( !GetBoolFlag('M02HostagesRescued') )
		{
			// Count terrorists.
			Count = 0;
			if ( TerroristClass!=None )
				foreach AllActors( TerroristClass, Actor, 'SecondFloorTerrorist' )
					Count++;

			if ( Count==0 )
				SetBoolFlag( 'M02HostagesRescued', True, True, 3 );
		}
	}

	//
	// 02_NYC_UNDERGROUND
	//
	else if ( LocalURL=="02_NYC_UNDERGROUND" )
	{
		if ( GetBoolFlag('FordSchick_Dead') && !GetBoolFlag('FordSchickRescueDone') )
		{
			SetBoolFlag( 'FordSchickRescueDone', True, True, 9 );
		}
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	PrevMissionScript=Class'HX.HXMission01'
	NextMissionScript=Class'HX.HXMission03'
}
