//=============================================================================
// HXMission03.
//=============================================================================
class HXMission03 expands HXMissionScript;

var Class<HXScriptedPawn> TerroristClass, UNATCOTroopClass, ThugMaleClass, ThugMale2Class,
                          SecurityBot3Class, PaulDentonClass, GuntherHermannClass, WaltonSimonsClass,
													AnnaNavarreClass, JuanLebedevClass;
var Class<HXDecoration>   BlackHelicopterClass, SecurityCameraClass, AutoTurretClass;
var Class<HXCarcass>      JuanLebedevCarcassClass;

// ----------------------------------------------------------------------------
// LoadClasses()
// ----------------------------------------------------------------------------

function LoadClasses()
{
	Super.LoadClasses();

	// ScriptedPawns.
	TerroristClass	     = LoadScriptedPawnReplacementClass( class'Terrorist' );
	UNATCOTroopClass	   = LoadScriptedPawnReplacementClass( class'UNATCOTroop' );
	ThugMaleClass	       = LoadScriptedPawnReplacementClass( class'ThugMale' );
	ThugMale2Class	     = LoadScriptedPawnReplacementClass( class'ThugMale2' );
	SecurityBot3Class	   = LoadScriptedPawnReplacementClass( class'SecurityBot3' );
	PaulDentonClass	     = LoadScriptedPawnReplacementClass( class'PaulDenton' );
	GuntherHermannClass	 = LoadScriptedPawnReplacementClass( class'GuntherHermann' );
	WaltonSimonsClass	   = LoadScriptedPawnReplacementClass( class'WaltonSimons' );
	AnnaNavarreClass	   = LoadScriptedPawnReplacementClass( class'AnnaNavarre' );
	JuanLebedevClass     = LoadScriptedPawnReplacementClass( class'JuanLebedev' );

	// Decorations,
	BlackHelicopterClass = LoadDecorationReplacementClass( class'BlackHelicopter' );
	SecurityCameraClass  = LoadDecorationReplacementClass( class'SecurityCamera' );
	AutoTurretClass      = LoadDecorationReplacementClass( class'AutoTurret' );

	// Carcasses.
	JuanLebedevCarcassClass = LoadCarcassReplacementClass( class'JuanLebedevCarcass' );
}

// ----------------------------------------------------------------------------
// RandomizeEvents()
//
// Randomizes what happened at this Mission, so one would not start blank
// with what happened in prior mission.
// ----------------------------------------------------------------------------

static function RandomizeEvents( HXGameInfo Game, HXSteve Steve, int MissionNumber, String MapName )
{
	Super.RandomizeEvents( Game, Steve, MissionNumber, MapName );
}

// ----------------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------------

function FirstFrame()
{
	local Actor Actor;

	Super.FirstFrame();

	//
	// 03_NYC_AIRFIELDHELIBASE
	//
	if ( LocalURL=="03_NYC_AIRFIELDHELIBASE" )
	{
		// Delete terrorists and unhide reinforcements.
		if ( GetBoolFlag('MeetLebedev_Played') || GetBoolFlag('JuanLebedev_Dead') )
		{
			DestroyActors( TerroristClass );
			DestroyActors( SecurityBot3Class );
			PawnsEnterWorld( UNATCOTroopClass, 'UNATCOTroop' );
		}
	}

	//
	// 03_NYC_AIRFIELD
	//
	else if ( LocalURL=="03_NYC_AIRFIELD" )
	{
		// Delete terrorists and unhide reinforcements and unhide the helicopter
		// also, turn off all security cameras.
		if ( GetBoolFlag('MeetLebedev_Played') || GetBoolFlag('JuanLebedev_Dead') )
		{
			DestroyActors( TerroristClass );
			DestroyActors( SecurityBot3Class );
			PawnsEnterWorld( UNATCOTroopClass, 'UNATCOTroop' );
			DecorationsEnterWorld( BlackHelicopterClass,, true );
			UnTriggerActors( SecurityCameraClass,, None, None );
			UnTriggerActors( AutoTurretClass,, None, None );
			PawnsEnterWorld( GuntherHermannClass,, true );
		}
	}

	//
	// 03_NYC_HANGAR
	//
	else if (localURL == "03_NYC_HANGAR")
	{
		// Delete terrorists and unhide reinforcements.
		if ( GetBoolFlag('MeetLebedev_Played') || GetBoolFlag('JuanLebedev_Dead') )
		{
			DestroyActors( TerroristClass );
			DestroyActors( SecurityBot3Class );
			DestroyActors( PaulDentonClass );
			PawnsEnterWorld( UNATCOTroopClass, 'UNATCOTroop' );
		}
	}

	//
	// 03_NYC_747
	//
	else if ( LocalURL=="03_NYC_747" )
	{
		// Delete terrorists. -- Turns out there are none of those Actors even inside the map.
		//if ( GetBoolFlag('MeetLebedev_Played') || GetBoolFlag('JuanLebedev_Dead') )
		//{
		//	DestroyActors( TerroristClass );
		//	DestroyActors( SecurityBot3Class );
		//}
	}
}

// ----------------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------------

function PreTravel()
{
	Super.PreTravel();
}

// ----------------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------------

function Timer()
{
	local HXScriptedPawn ScriptedPawn;
	local HXMover Mover;
	local Actor Actor;
	local bool bCarcFound, bJuanFound;
	local int Count;

	Super.Timer();

	//
	// 03_NYC_UNATCOHQ
	//
	if ( LocalURL=="03_NYC_UNATCOHQ" )
	{
		// Make Walton Simons walk to the cell.
		if ( !GetBoolFlag('MS_SimonsWalking') && GetBoolFlag('SimonsOverheard_Played') )
		{
			if ( WaltonSimonsClass!=None )
				foreach AllActors( WaltonSimonsClass, Actor )
					HXScriptedPawn(Actor).SetOrders( 'GoingTo', 'SimonsInterrogating', True );

			SetBoolFlag( 'MS_SimonsWalking', True, True, 4 );
		}

		// Set a flag when Walton Simons gets to his point.
		if ( !GetBoolFlag('SimonsInterrogating') && GetBoolFlag('MS_SimonsWalking') )
		{
			if ( WaltonSimonsClass!=None )
				foreach AllActors( WaltonSimonsClass, Actor )
					if ( Actor.IsInState('Standing') )
						SetBoolFlag( 'SimonsInterrogating', True, True, 4 );
		}

		// Unlock a door when a flag is set.
		if ( !GetBoolFlag('MS_MoverUnlocked') && GetBoolFlag('UnlockDoor') )
		{
			foreach AllActors( Class'HXMover', Mover, 'Manderley_Office' )
			{
				Mover.bLocked = False;
				Mover.LockStrength = 0.0;
			}

			SetBoolFlag( 'MS_MoverUnlocked', True, True, 4 );
		}

		if ( GetBoolFlag('AnnaAtDesk') && !GetBoolFlag('MS_AnnaDeskHome') )
		{
			if ( AnnaNavarreClass!=None )
				foreach AllActors( AnnaNavarreClass, Actor )
					HXScriptedPawn(Actor).SetHomeBase( Actor.Location, Actor.Rotation );

			SetBoolFlag('MS_AnnaDeskHome', True, True, 4);
		}

		if ( GetBoolFlag('AnnaInOffice') && !GetBoolFlag('MS_AnnaOfficeHome') )
		{
			if ( AnnaNavarreClass!=None )
				foreach AllActors( AnnaNavarreClass, Actor )
					HXScriptedPawn(Actor).SetHomeBase( Actor.Location, Actor.Rotation );

			SetBoolFlag('MS_AnnaOfficeHome', True, True, 4);
		}
	}

	//
	// 03_NYC_AIRFIELDHELIBASE
	//
	else if ( LocalURL=="03_NYC_AIRFIELDHELIBASE" )
	{
		// Check for Ambrosia Barrels being tagged.
		if ( !GetBoolFlag('Barrel1Checked') && GetBoolFlag('HelicopterBaseAmbrosia') )
		{
			Count = 1;
			if ( GetBoolFlag('BoatDocksAmbrosia') )
				Count++;
			if ( GetBoolFlag('747Ambrosia') )
				Count++;

			switch ( Count )
			{
				case 1:
					StartDataLinkTransmission( "DL_TaggedOne" );
					break;
				case 2:
					StartDataLinkTransmission( "DL_TaggedTwo" );
					break;
				case 3:
					StartDataLinkTransmission( "DL_TaggedThree" );
					break;
				default:
					break;
			}

			SetBoolFlag( 'Barrel1Checked', True, True, 4 );
		}
	}

	//
	// 03_NYC_AIRFIELD
	//
	else if ( LocalURL=="03_NYC_AIRFIELD" )
	{
		// Check for Ambrosia Barrels being tagged.
		if ( !GetBoolFlag('Barrel2Checked') && GetBoolFlag('BoatDocksAmbrosia') )
		{
			Count = 1;
			if ( GetBoolFlag('HelicopterBaseAmbrosia') )
				Count++;
			if ( GetBoolFlag('747Ambrosia') )
				Count++;

			switch ( Count )
			{
				case 1:
					StartDataLinkTransmission( "DL_TaggedOne" );
					break;
				case 2:
					StartDataLinkTransmission( "DL_TaggedTwo" );
					break;
				case 3:
					StartDataLinkTransmission( "DL_TaggedThree" );
					break;
				default:
					break;
			}
					
			SetBoolFlag( 'Barrel2Checked', True, True, 4 );
		}

		// Unhide Gunther.
		if ( !GetBoolFlag('MS_GuntherUnhidden') && (GetBoolFlag('MeetLebedev_Played') || GetBoolFlag('JuanLebedev_Dead')) )
		{
			PawnsEnterWorld( GuntherHermannClass );

			SetBoolFlag( 'MS_GuntherUnhidden', True, True, 4 );
		}
	}

	//
	// 03_NYC_747
	//
	else if ( LocalURL=="03_NYC_747" )
	{
		// Check for Lebedev's death.
		if ( GetBoolFlag('JuanLebedev_Dead') && !GetBoolFlag('MS_Anna747Unhidden') )
		{
			PawnsEnterWorld( AnnaNavarreClass );

			SetBoolFlag( 'MS_Anna747Unhidden', True, True, 4 );
		}

		// check for Ambrosia Barrels being tagged
		if ( !GetBoolFlag('Barrel3Checked') && GetBoolFlag('747Ambrosia') )
		{
			Count = 1;
			if ( GetBoolFlag('HelicopterBaseAmbrosia') )
				Count++;
			if ( GetBoolFlag('BoatDocksAmbrosia') )
				Count++;

			switch ( Count )
			{
				case 1:
					StartDataLinkTransmission( "DL_TaggedOne" );
					break;
				case 2:
					StartDataLinkTransmission( "DL_TaggedTwo" );
					break;
				case 3:
					StartDataLinkTransmission( "DL_TaggedThree" );
					break;
				default:
					break;
			}
				
			SetBoolFlag( 'Barrel3Checked', True, True, 4 );
		}

		// Unhide Anna. (Note: Collapse with above?)
		if ( !GetBoolFlag('MS_AnnaUnhidden') && (GetBoolFlag('MeetLebedev_Played') || GetBoolFlag('JuanLebedev_Dead')) )
		{
			PawnsEnterWorld( AnnaNavarreClass );

			SetBoolFlag('MS_AnnaUnhidden', True, True, 4);
		}

		// Check to see if the player has killed Lebedev.
		if ( !GetBoolFlag('PlayerKilledLebedev') && !GetBoolFlag('AnnaKilledLebedev') )
		{
			bCarcFound = False;
			if ( JuanLebedevCarcassClass!=None )
			{
				foreach AllActors( JuanLebedevCarcassClass, Actor )
				{
					switch ( HXCarcass(Actor).KillerBindName )
					{
						case "JCDenton":
						case "":
							CompleteGoal( 'AssassinateLebedev' );
							SetBoolFlag( 'PlayerKilledLebedev', True, True, 6 );
							break;
						case "AnnaNavarre":
							SetBoolFlag( 'AnnaKilledLebedev', True, True, 6 );
							break;
						default:
							SetBoolFlag( 'JuanLebedev_Dead', True, True, 0 );
							break;
					}
					bCarcFound = True;
					break;
				}
			}

			bJuanFound = False;
			if ( JuanLebedevClass!=None )
			{
				foreach AllActors( JuanLebedevClass, Actor )
				{
					bJuanFound = True;
					break;
				}
			}

			if ( !bCarcFound && !bJuanFound && GetBoolFlag('JuanLebedev_Dead') )
				SetBoolFlag( 'PlayerKilledLebedev', True, True, 6 );
		}
	}

	//
	// 03_NYC_MOLEPEOPLE
	//
	else if ( LocalURL=="03_NYC_MOLEPEOPLE" )
	{
		// Set a flag when there are less than 4 mole people alive.
		// Note: What about them beeing unconscious?
		if ( !GetBoolFlag('MolePeopleSlaughtered') )
		{
			Count = 0;
			foreach AllActors( Class'HXScriptedPawn', ScriptedPawn, 'MolePeople' )
				Count++;

			if ( Count<4 )
				SetBoolFlag( 'MolePeopleSlaughtered', True, True, 4 );
		}

		// Set a flag when there are less than 3 terrorists alive.
		if ( !GetBoolFlag('MoleTerroristsDefeated') )
		{
			Count = 0;
			if ( TerroristClass!=None )
				foreach AllActors( TerroristClass, Actor, 'MoleTerrorist' )
					Count++;

			if ( Count<3 )
				SetBoolFlag( 'MoleTerroristsDefeated', True, True, 4 );
		}
	}

	//
	// 03_NYC_BROOKLYNBRIDGESTATION
	//
	else if ( LocalURL=="03_NYC_BROOKLYNBRIDGESTATION" )
	{
		// Set a flag when the gang's all dead.
		if ( !GetBoolFlag('JugHeadGangDefeated') )
		{
			Count = 0;
			// Normal gang members.
			if ( ThugMale2Class!=None )
			{
				foreach AllActors( ThugMale2Class, Actor, 'ThugMale2' )
				{
					Count++;
					break;
				}
			}
			// Boss.
			if ( Count==0 ) // Just check if we really need too.
			{
				if ( ThugMaleClass!=None )
				{
					foreach AllActors( ThugMaleClass, Actor, 'Elrey' )
					{
						Count++;
						break;
					}
				}
			}
			if ( Count==0 )
				SetBoolFlag( 'JugHeadGangDefeated', True, True, 4 );
		}
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	PrevMissionScript=Class'HX.HXMission02'
	NextMissionScript=Class'HX.HXMission04'
}
