//=============================================================================
// HXMission04.
//
// TODO:
//  * Maybe handle MS_FirstPlayerKilledOnHunt in PreventDeath()
//  * Evalulate handling of killed Rentons in 04_NYC_HOTEL.
//=============================================================================
class HXMission04 expands HXMissionScript;

var Class<HXScriptedPawn> UNATCOTroopClass, SecurityBot2Class, PaulDentonClass, MIBClass,
                          SandraRentonClass, GilbertRentonClass, HarleyFilbenClass;
var Class<HXDecoration>   SatelliteDishClass;
var Class<HXCarcass>      SandraRentonCarcassClass, GilbertRentonCarcassClass;

// ----------------------------------------------------------------------------
// LoadClasses()
// ----------------------------------------------------------------------------

function LoadClasses()
{
	Super.LoadClasses();

	// ScriptedPawns.
	UNATCOTroopClass	 = LoadScriptedPawnReplacementClass( class'UNATCOTroop' );
	SecurityBot2Class	 = LoadScriptedPawnReplacementClass( class'SecurityBot2' );
	PaulDentonClass	   = LoadScriptedPawnReplacementClass( class'PaulDenton' );
	MIBClass	         = LoadScriptedPawnReplacementClass( class'MIB' );
	SandraRentonClass  = LoadScriptedPawnReplacementClass( class'SandraRenton' );
	GilbertRentonClass = LoadScriptedPawnReplacementClass( class'GilbertRenton' );
	HarleyFilbenClass  = LoadScriptedPawnReplacementClass( class'HarleyFilben' );

	// Decorations,
	SatelliteDishClass = LoadDecorationReplacementClass( class'SatelliteDish' );

	// Carcasses.
	SandraRentonCarcassClass  = LoadCarcassReplacementClass( class'SandraRentonCarcass' );
	GilbertRentonCarcassClass = LoadCarcassReplacementClass( class'GilbertRentonCarcass' );
}

// ----------------------------------------------------------------------------
// RandomizeEvents()
//
// Randomizes what happened at this Mission, so one would not start blank
// with what happened in prior mission.
// ----------------------------------------------------------------------------

static function RandomizeEvents( HXGameInfo Game, HXSteve Steve, int MissionNumber, String MapName )
{
	Super.RandomizeEvents( Game, Steve, MissionNumber, MapName );
}

// ----------------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------------

function FirstFrame()
{
	local HXScriptedPawn ScriptedPawn;
	local Actor Actor;

	Super.FirstFrame();

	//
	// 04_NYC_STREET.
	//
	if ( LocalURL=="04_NYC_STREET" )
	{
		// Unhide a bunch of stuff on this flag.
		if ( GetBoolFlag('TalkedToPaulAfterMessage_Played') )
		{
			PawnsEnterWorld( UNATCOTroopClass );
			PawnsEnterWorld( SecurityBot2Class );
		}
	}

	//
	// 04_NYC_HOTEL.
	//
	else if ( LocalURL=="04_NYC_HOTEL" )
	{
		// Unhide the correct JoJo.
		if ( (GetBoolFlag('SandraRenton_Dead') || GetBoolFlag('GilbertRenton_Dead')) && !GetBoolFlag('JoJoFine_Dead') )
		{
			PawnsEnterWorld( Class'HXScriptedPawn', 'JoJoInLobby' );
		}
	}

	//
	// 04_NYC_BATTERYPARK.
	//
	else if ( LocalURL=="04_NYC_BATTERYPARK" )
	{
		// Set flag manually if not yet set, because it fucks up convos else.
		if ( !GetBoolFlag('TalkedToPaulAfterMessage_Played') )
		{
			SetBoolFlag( 'TalkedToPaulAfterMessage_Played', true, true, 5 );
		}
	}
}

// ----------------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------------

function PreTravel()
{
	Super.PreTravel();
}

// ----------------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------------

function Timer()
{
	local Actor Actor;
	local int Count;

	Super.Timer();

	// Do this for every map in this mission. If the player
	// is "killed" after a certain flag, he is sent to mission 5.
	if ( !GetBoolFlag('MS_PlayerCaptured') && GetBoolFlag('TalkedToPaulAfterMessage_Played') && GetBoolFlag('MS_FirstPlayerKilledOnHunt') )
	{
		SetBoolFlag( 'MS_PlayerCaptured', true, true, 5 );
		CompleteGoal( 'EscapeToBatteryPark');

		// Travel to next mission.
		Log( "ServerTravel via MissionScript to 05_NYC_UNATCOMJ12Lab#", 'DevMissionScript' );
		Level.ServerTravel( "05_NYC_UNATCOMJ12Lab#", True );
	}

	//
	// 04_NYC_HOTEL
	//
	if ( LocalURL=="04_NYC_HOTEL" )
	{
		// Check to see if the player has killed either Sandra or Gilbert.
		if ( !GetBoolFlag('PlayerKilledRenton') )
		{
			// Note: one should actually check into the conversations if this is really
			//       the best matching bahaviour.

			Count = 0;
			if ( SandraRentonClass!=None )
			{
				foreach AllActors( SandraRentonClass, Actor )
				{
					Count++;
					break;
				}
			}
			if ( GilbertRentonClass!=None )
			{
				foreach AllActors( GilbertRentonClass, Actor )
				{
					Count++;
					break;
				}
			}

/*
			// HX_HAN: Comment this out because it won't change a bit.
			//         Might be needed later if I came to the conclusion that
			//         counting corpses with KillerBindName!="JCDenton" too makes sense.
			if ( SandraRentonCarcassClass!=None )
			foreach AllActors( SandraRentonCarcassClass, Actor )
			{
				if ( HXCarcass(Actor).KillerBindName=="JCDenton" )
				{
					Count = 0;
				}
				//else
				//{
					//Count++;
				//}
				break;
			}

			if ( GilbertRentonCarcassClass!=None )
			foreach AllActors( GilbertRentonCarcassClass, GilbertCarc)
			{
				if ( HXCarcass(Actor).KillerBindName=="JCDenton" )
				{
					Count = 0;
				}
				//else
				//{
					//Count++;
				//}
			}
*/

			if ( Count<2 )
			{
				SetBoolFlag( 'PlayerKilledRenton', true, true, 5 );
				foreach AllActors( Class'Actor', Actor, 'RentonsHatePlayer' )
					Actor.Trigger( Self, None );
			}
		}

		// HX_NOTE: Just fire up the convo here.
		if ( !GetBoolFlag('M04RaidTeleportDone') && GetBoolFlag('ApartmentEntered') && GetBoolFlag('NSFSignalSent') && !GetBoolFlag('TalkedToPaulAfterMessage_Played') )
		{
			// Leep trying until it finally can be played.
			if ( PaulDentonClass!=None )
			{
				foreach AllActors( PaulDentonClass, Actor )
				{
					Game.StartConversationByName( None, 'TalkedToPaulAfterMessage', Actor, false, false );
					break;
				}
			}
		}

		if ( !GetBoolFlag('M04RaidTeleportDone') && GetBoolFlag('TalkedToPaulAfterMessage_Played') )
		{
			PawnsEnterWorld( UNATCOTroopClass );
			PawnsEnterWorld( MIBClass );

			PawnsLeaveWorld( SandraRentonClass );
			PawnsLeaveWorld( GilbertRentonClass );
			PawnsLeaveWorld( HarleyFilbenClass );

			SetBoolFlag( 'M04RaidTeleportDone', true, true, 5 );
		}

		// Make the MIBs mortal.
		if ( !GetBoolFlag('MS_MIBMortal') && GetBoolFlag('TalkedToPaulAfterMessage_Played') )
		{
			if ( MIBClass!=None )
				foreach AllActors( MIBClass, Actor )
					HXScriptedPawn(Actor).bInvincible = False;

			SetBoolFlag( 'MS_MIBMortal', true, true, 5 );
		}

		// Unhide the correct JoJo.
		if ( !GetBoolFlag('MS_JoJoUnhidden') && (GetBoolFlag('SandraWaitingForJoJoBarks_Played') || GetBoolFlag('GilbertWaitingForJoJoBarks_Played')) && !GetBoolFlag('JoJoFine_Dead') )
		{
			PawnsEnterWorld( Class'HXScriptedPawn', 'JoJoUpstairs' );

			SetBoolFlag( 'MS_JoJoUnhidden', true, true, 5 );
		}

		// Unhide the correct JoJo.
		// Todo: Merge with above.
		if ( !GetBoolFlag('MS_JoJoUnhidden') && GetBoolFlag('M03OverhearSquabble_Played') && !GetBoolFlag('JoJoOverheard_Played') && GetBoolFlag('JoJoEntrance') && !GetBoolFlag('JoJoFine_Dead') )
		{
			PawnsEnterWorld( Class'HXScriptedPawn', 'JoJoUpstairs' );

			SetBoolFlag( 'MS_JoJoUnhidden', true, true, 5 );
		}

		// Trigger some stuff based on convo flags.
		if ( GetBoolFlag('JoJoOverheard_Played') && !GetBoolFlag('MS_JoJo1Triggered') )
		{
			if ( GetBoolFlag('GaveRentonGun') )
			{
				foreach AllActors( Class'Actor', Actor, 'GilbertAttacksJoJo' )
					Actor.Trigger( Self, None );
			}
			else
			{
				foreach AllActors( Class'Actor', Actor, 'JoJoAttacksGilbert' )
					Actor.Trigger( Self, None );
			}

			SetBoolFlag('MS_JoJo1Triggered', true, true, 5 );
		}

		// Trigger some stuff based on convo flags.
		if ( GetBoolFlag('JoJoAndSandraOverheard_Played') && !GetBoolFlag('MS_JoJo2Triggered') )
		{
			foreach AllActors( Class'Actor', Actor, 'SandraLeaves' )
				Actor.Trigger( Self, None );

			SetBoolFlag('MS_JoJo2Triggered', true, true, 5 );
		}

		// Trigger some stuff based on convo flags.
		if ( GetBoolFlag('JoJoAndGilbertOverheard_Played') && !GetBoolFlag('MS_JoJo3Triggered') )
		{
			foreach AllActors( Class'Actor', Actor, 'JoJoAttacksGilbert' )
				Actor.Trigger( Self, None );

			SetBoolFlag('MS_JoJo3Triggered', true, true, 5 );
		}
	}

	//
	// 04_NYC_NSFHQ
	//
	else if ( LocalURL=="04_NYC_NSFHQ" )
	{
		// Rotate the dish when the computer sets the flag.
		if ( !GetBoolFlag('MS_Dish1Rotated') && GetBoolFlag('Dish1InPosition') )
		{
			if ( SatelliteDishClass!=None )
				foreach AllActors( SatelliteDishClass, Actor, 'Dish1' )
					Actor.DesiredRotation.Yaw = 49152;

			SetBoolFlag( 'MS_Dish1Rotated', true, true, 5 );
		}

		// Rotate the dish when the computer sets the flag.
		if ( !GetBoolFlag('MS_Dish2Rotated') && GetBoolFlag('Dish2InPosition') )
		{
			if ( SatelliteDishClass!=None )
				foreach AllActors( SatelliteDishClass, Actor, 'Dish2' )
					Actor.DesiredRotation.Yaw = 0;

			SetBoolFlag( 'MS_Dish2Rotated', true, true, 5 );
		}

		// Rotate the dish when the computer sets the flag.
		if ( !GetBoolFlag('MS_Dish3Rotated') && GetBoolFlag('Dish3InPosition') )
		{
			if ( SatelliteDishClass!=None )
				foreach AllActors( SatelliteDishClass, Actor, 'Dish3' )
					Actor.DesiredRotation.Yaw = 16384;

			SetBoolFlag( 'MS_Dish3Rotated', true, true, 5 );
		}

		// Set a flag when all dishes are rotated.
		if ( !GetBoolFlag('CanSendSignal') && GetBoolFlag('Dish1InPosition') && GetBoolFlag('Dish2InPosition') && GetBoolFlag('Dish3InPosition') )
		{
			SetBoolFlag( 'CanSendSignal', true, true, 5 );
		}

		// Count living troops
		if ( !GetBoolFlag('MostWarehouseTroopsDead') )
		{
			Count = 0;
			if ( UNATCOTroopClass!=None )
				foreach AllActors( UNATCOTroopClass, Actor )
					if ( ++Count>2 )
						break;

			// If two or less are still alive.
			if ( Count<=2 )
				SetBoolFlag( 'MostWarehouseTroopsDead', true, true, 5 );
		}
	}
}

// ----------------------------------------------------------------------------
// PreventDeath()
// ----------------------------------------------------------------------------

function PreventDeath( Pawn Pawn )
{
	local HXPlayerPawn Player;

	if ( Pawn!=None && Pawn.bIsPlayer )
		Player = HXPlayerPawn(Pawn);

	if ( Player!=None )
	{
		if ( GetBoolFlag('TalkedToPaulAfterMessage_Played') )
		{
			if ( !GetBoolFlag('MS_FirstPlayerKilledOnHunt') )
				SetBoolFlag( 'MS_FirstPlayerKilledOnHunt', true, true, 1 );

			Player.HealthTorso = FMax( Player.HealthTorso, 1 );
			Player.HealthHead  = FMax( Player.HealthHead,  1 );
			Player.GenerateTotalHealth();
		}
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	PrevMissionScript=Class'HX.HXMission03'
	NextMissionScript=Class'HX.HXMission05'
}
