//=============================================================================
// HXMission05.
//
// TODO:
//  * Figure out a way to detect a player rejoining 05_NYC_UNATCOMJ12LAB,
//    so his inventory gets not dropped at the armory.
//=============================================================================
class HXMission05 extends HXMissionScript;

var Class<HXScriptedPawn> TerroristClass, PaulDentonClass, WaltonSimonsClass, AnnaNavarreClass;
var Class<HXCarcass>      PaulDentonCarcassClass;
var Class<Inventory>      WeaponBatonClass, WeaponCombatKnifeClass;

// ----------------------------------------------------------------------------
// LoadClasses()
// ----------------------------------------------------------------------------

function LoadClasses()
{
	Super.LoadClasses();

	// ScriptedPawns.
	TerroristClass	  = LoadScriptedPawnReplacementClass( class'Terrorist' );
	PaulDentonClass	  = LoadScriptedPawnReplacementClass( class'PaulDenton' );
	WaltonSimonsClass = LoadScriptedPawnReplacementClass( class'WaltonSimons' );
	AnnaNavarreClass	= LoadScriptedPawnReplacementClass( class'AnnaNavarre' );

	// Carcasses.
	PaulDentonCarcassClass  = LoadCarcassReplacementClass( class'PaulDentonCarcass' );

	// Inventory.
	WeaponBatonClass        = LoadInventoryReplacementClass( class'WeaponBaton' );
	WeaponCombatKnifeClass  = LoadInventoryReplacementClass( class'WeaponCombatKnife' );
}

// ----------------------------------------------------------------------------
// RandomizeEvents()
//
// Randomizes what happened at this Mission, so one would not start blank
// with what happened in prior mission.
// ----------------------------------------------------------------------------

static function RandomizeEvents( HXGameInfo Game, HXSteve Steve, int MissionNumber, String MapName )
{
	Super.RandomizeEvents( Game, Steve, MissionNumber, MapName );

	// TODO, below is just added to test Bark flag branching code.

	// If player finished of desperate Manderley.
	//if ( True )
	if ( FRand()<0.75 )
		Steve.FlagBase.SetBool( 'JosephManderley_Dead', true, true, 0 );
}

// ----------------------------------------------------------------------------
// AcceptInventory()
// ----------------------------------------------------------------------------

//
// Needs some serious overhaul.
//
// Inventory should just be removed when entering the map the first time.
//
function AcceptInventory( HXPlayerPawn Player, String Portal, String MapURL )
{
	local SpawnPoint InventoryDropPoints[64], SpawnPoint;
	local int NumInventoryDropPoints, i;


	local Inventory item, nextItem, anItem;
	local SpawnPoint SP;

	//
	// First time on 05_NYC_UNATCOMJ12LAB
	//
	if ( MapURL=="05_NYC_UNATCOMJ12LAB" && Portal=="" && !GetInventoryMovedToArmory(Player) )
	{
		//
		// Heal the player up to 50% of his total health per part.
		//
		Player.HealthHead     = Max( 50, Player.HealthHead );
		Player.HealthTorso    = Max( 50, Player.HealthTorso );
		Player.HealthLegLeft  = Max( 50, Player.HealthLegLeft );
		Player.HealthLegRight = Max( 50, Player.HealthLegRight );
		Player.HealthArmLeft  = Max( 50, Player.HealthArmLeft );
		Player.HealthArmRight = Max( 50, Player.HealthArmRight );
		Player.GenerateTotalHealth();

		//
		// Remove the player's inventory and put it in Armory.
		//

		// First find SpawnPoints in map (Yes it sucks, doing it each time).
		foreach Player.AllActors( Class'SpawnPoint', SpawnPoint, 'player_inv' )
		{
			InventoryDropPoints[NumInventoryDropPoints++] = SpawnPoint;
			if ( NumInventoryDropPoints>=ArrayCount(InventoryDropPoints) )
				break;
		}

		Log( "Found" @ NumInventoryDropPoints @ "DropPoints for Inventory", 'DevMissionScript' );

		// TODO: better code is needed here -- urgent.
		if (Player.Inventory != None)
		{
			item      = Player.Inventory;
			nextItem  = None;

			foreach Player.AllActors(class'SpawnPoint', SP, 'player_inv')
			{
				//Log( SP $ ".Name = " $ SP.Name );

				// Find the next item we can process.
				while((item != None) && (item.IsA('HXNanoKeyRing') || (!item.bDisplayableInv)))
					item = item.Inventory;

				if (item != None)
				{
					nextItem = item.Inventory;

					item.DropFrom(SP.Location);

					// Make sure it gets deleted in case DropFrom() failed.
					Player.DeleteInventory(item);

					// restore any ammo amounts for a weapon to default
					if (item.IsA('Weapon') && (Weapon(item).AmmoType != None))
						Weapon(item).PickupAmmoCount = Weapon(item).Default.PickupAmmoCount;
				}
				
				if (nextItem == None)
					break;	
				else
					item = nextItem;
			}
		}

		// Make sure inventory is just stripped once.
		SetInventoryMovedToArmory( Player, True );

		// Add Baton or CombatKnife.
		GiveInitialInventory( Player, Portal, MapURL );
	}
}

// ----------------------------------------------------------------------------
// Getter/Setter to store player specific data.
//
// Main reason for using these is to have a single place where the variable
// is directly accessed to avoid missmatches.
// ----------------------------------------------------------------------------

static final function SetInventoryMovedToArmory( HXPlayerPawn Player, bool bMoved )
{
	Player.bMissionScriptBoolean0 = bMoved;
}
static final function bool GetInventoryMovedToArmory( HXPlayerPawn Player )
{
	return Player.bMissionScriptBoolean0;
}

// ----------------------------------------------------------------------------
// GiveInitialInventory()
// ----------------------------------------------------------------------------

function GiveInitialInventory( HXPlayerPawn Player, String Portal, String MapURL )
{
	// 
	// Initial inventory changes throughout the mission:
	// Initially there is none until the Baton/CombatKnife in the starting area
	// got picked up. Whatever was picked up first remains the initial inventory
	// throughout the Mission until the equipment is retrieved off the armory,
	// in which case it uses the default equipment used on all other missions again.
	//
	if ( IsGoalCompleted('FindEquipment') )
	{
		Super.GiveInitialInventory( Player, Portal, MapURL );
	}
	else if ( HXGameInfo(Player.Level.Game).Steve.FlagBase.GetBool('M05BatonPickedUp') )
	{
		GiveInventoryItem( Player, WeaponBatonClass, 1 );
	}
	else if ( HXGameInfo(Player.Level.Game).Steve.FlagBase.GetBool('M05CombatKnifePickedUp') )
	{
		GiveInventoryItem( Player, WeaponCombatKnifeClass, 1 );
	}
}

// ----------------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------------

function FirstFrame()
{
	local Actor Actor;

	Super.FirstFrame();

	//
	// 05_NYC_UNATCOMJ12LAB.
	//
	if ( LocalURL=="05_NYC_UNATCOMJ12LAB" )
	{
		// Make sure this goal is completed.
		CompleteGoal( 'EscapeToBatteryPark' );

		// Delete Paul's carcass if he's still alive
		if ( !GetBoolFlag('PaulDenton_Dead') )
		{
			if ( PaulDentonCarcassClass!=None )
				foreach AllActors( PaulDentonCarcassClass, Actor )
					Actor.Destroy();
		}

		// If the player has already talked to Paul, delete him.
		if ( GetBoolFlag('M05PaulDentonDone') || GetBoolFlag('PlayerBailedOutWindow') )
		{
			if ( PaulDentonClass!=None )
				foreach AllActors( PaulDentonClass, Actor )
					Actor.Destroy();
		}

		// If Miguel is not following the player, delete him.
		if ( GetBoolFlag('MeetMiguel_Played') && !GetBoolFlag('MiguelFollowing') )
		{
			if ( TerroristClass!=None )
				foreach AllActors( TerroristClass, Actor )
					if ( Actor.BindName=="Miguel" )
						Actor.Destroy();
		}
	}

	//
	// 05_NYC_UNATCOHQ.
	//
	else if ( LocalURL=="05_NYC_UNATCOHQ" )
	{
		// Force DL_Choice to be played, as Anna convo handling depends on it having been played when we reach this point.
		// Otherwise Anna just keeps standing around, seemingly doing nothing as she has no barks and will be in Standing state.
		SetBoolFlag( 'DL_Choice_Played', true, true, 6 );

		// If Miguel is following the player, unhide him.
		if ( GetBoolFlag('MiguelFollowing') )
		{
			if ( TerroristClass!=None )
				foreach AllActors( TerroristClass, Actor )
					if ( Actor.BindName=="Miguel" )
						HXScriptedPawn(Actor).EnterWorld();
		}

		// Make Anna not flee in this mission.
		if ( AnnaNavarreClass!=None )
			foreach AllActors( AnnaNavarreClass, Actor )
				HXScriptedPawn(Actor).MinHealth = 0;
	}

	//
	// 05_NYC_UNATCOISLAND.
	//
	else if ( LocalURL=="05_NYC_UNATCOISLAND" )
	{
		// If Miguel is following the player, unhide him.
		if ( GetBoolFlag('MiguelFollowing') )
		{
			if ( TerroristClass!=None )
				foreach AllActors( TerroristClass, Actor )
					if ( Actor.BindName=="Miguel" )
						HXScriptedPawn(Actor).EnterWorld();
		}
	}
}

// ----------------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------------

function PreTravel()
{
	Super.PreTravel();
}

// ----------------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------------

function Timer()
{
	local HXScriptedPawn ScriptedPawn;
	local HXMover Mover;
	local Actor Actor;

	Super.Timer();

	//
	// 05_NYC_UNATCOHQ.
	//
	if ( LocalURL=="05_NYC_UNATCOHQ" )
	{
		// Unlock a door
		if ( GetBoolFlag('CarterUnlock') && !GetBoolFlag('MS_DoorUnlocked') )
		{
			foreach AllActors( Class'HXMover', Mover, 'supplydoor' )
			{
				Mover.bLocked = False;
				Mover.lockStrength = 0.0;
			}
			SetBoolFlag( 'MS_DoorUnlocked', true, true, 6 );
		}

		// Kill Anna when a flag is set.
		if ( GetBoolFlag('annadies') && !GetBoolFlag('MS_AnnaKilled') )
		{
			if ( AnnaNavarreClass!=None )
			{
				foreach AllActors( AnnaNavarreClass, Actor )
				{
					ScriptedPawn = HXScriptedPawn(Actor);
					ScriptedPawn.HealthTorso = 0;
					ScriptedPawn.Health = 0;
					ScriptedPawn.TakeDamage( 1, ScriptedPawn, ScriptedPawn.Location, vect(0,0,0), 'Shot' );
				}
			}

			SetBoolFlag( 'MS_AnnaKilled', true, true, 6 );
		}

		// Make Anna attack the player after a convo is played.
		if ( GetBoolFlag('M05AnnaAtExit_Played') && !GetBoolFlag('MS_AnnaAttacking') )
		{
			if ( AnnaNavarreClass!=None )
				foreach AllActors( AnnaNavarreClass, Actor )
					HXScriptedPawn(Actor).SetOrders( 'Attacking', '', True );

			SetBoolFlag( 'MS_AnnaAttacking', true, true, 6 );
		}

		// Unhide Walton Simons
		if ( GetBoolFlag('simonsappears') && !GetBoolFlag('MS_SimonsUnhidden') )
		{
			PawnsEnterWorld( WaltonSimonsClass );
			SetBoolFlag( 'MS_SimonsUnhidden', true, true, 6 );
		}

		// Hide Walton Simons.
		if ( (GetBoolFlag('M05MeetManderley_Played') || GetBoolFlag('M05SimonsAlone_Played')) && !GetBoolFlag('MS_SimonsHidden') )
		{
			PawnsLeaveWorld( WaltonSimonsClass );
			SetBoolFlag( 'MS_SimonsHidden', true, true, 6 );
		}

		// Mark a goal as completed.
		if ( GetBoolFlag('KnowsAnnasKillphrase1') && GetBoolFlag('KnowsAnnasKillphrase2') && !GetBoolFlag('MS_KillphraseGoalCleared') )
		{
			CompleteGoal( 'FindAnnasKillphrase' );
			SetBoolFlag('MS_KillphraseGoalCleared', true, true, 6);
		}

		// Clear a goal when anna is out of commision.
		if ( GetBoolFlag('AnnaNavarre_Dead') && !GetBoolFlag('MS_EliminateAnna') )
		{
			CompleteGoal( 'EliminateAnna' );
			SetBoolFlag( 'MS_EliminateAnna', true, true, 6 );
		}
	}

	//
	// 05_NYC_UNATCOMJ12LAB.
	//
	else if ( LocalURL=="05_NYC_UNATCOMJ12LAB" )
	{
		// After the player talks to Paul, start a datalink.
		if ( !GetBoolFlag('MS_DL_Played') && GetBoolFlag('PaulInMedLab_Played') )
		{
			StartDataLinkTransmission( "DL_Paul" );
			SetBoolFlag( 'MS_DL_Played', true, true, 6 );
		}
	}
}

// ----------------------------------------------------------------------------
// Trigger()
// ----------------------------------------------------------------------------

event Trigger( Actor Other, Pawn EventInstigator )
{
	if ( Other.Tag=='StartupBaton' )
	{
		if ( !GetBoolFlag('M05CombatKnifePickedUp') )
			SetBoolFlag( 'M05BatonPickedUp', true, true, 6 );
	}
	else if ( Other.Tag=='StartupCombatKnife' )
	{
		if ( !GetBoolFlag('M05BatonPickedUp') )
			SetBoolFlag( 'M05CombatKnifePickedUp', true, true, 6 );
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	PrevMissionScript=Class'HX.HXMission04'
	NextMissionScript=Class'HX.HXMission06'
}
