//=============================================================================
// HXMission06.
//=============================================================================
class HXMission06 expands HXMissionScript;

var Class<HXScriptedPawn> WaltonSimonsClass, MJ12CommandoClass, LowerClassFemaleClass, HKMilitaryClass,
                          TriadRedArrowClass, TriadLumPathClass, GordonQuickClass, MaxChenClass,
													SpiderBotClass, JaimeReyesClass, AlexJacobsonClass, PaulDentonClass;
var Class<HXDecoration>   Keypad1Class, Keypad3Class, AlarmUnitClass, BlackHelicopterClass,
                          BookOpenClass, VanClass, CarWreckedClass, RoadBlockClass;
var Class<HXCarcass>      HKMilitaryCarcassClass, TriadLumPathCarcassClass, TriadLumPath2CarcassClass,
                          TriadRedArrowCarcassClass;
var Class<HXRocket>       ChopperMissileClass; // Class of Rockets the Jock fires at the door.
var float RocketFireTime;

// ----------------------------------------------------------------------------
// LoadClasses()
// ----------------------------------------------------------------------------

function LoadClasses()
{
	Super.LoadClasses();

	// ScriptedPawns.
	WaltonSimonsClass	    = LoadScriptedPawnReplacementClass( class'WaltonSimons' );
	MJ12CommandoClass     = LoadScriptedPawnReplacementClass( class'MJ12Commando' );
	LowerClassFemaleClass = LoadScriptedPawnReplacementClass( class'LowerClassFemale' );
	HKMilitaryClass       = LoadScriptedPawnReplacementClass( class'HKMilitary' );
	TriadRedArrowClass    = LoadScriptedPawnReplacementClass( class'TriadRedArrow' );
	TriadLumPathClass     = LoadScriptedPawnReplacementClass( class'TriadLumPath' );
	GordonQuickClass      = LoadScriptedPawnReplacementClass( class'GordonQuick' );
	MaxChenClass          = LoadScriptedPawnReplacementClass( class'MaxChen' );
	SpiderBotClass        = LoadScriptedPawnReplacementClass( class'SpiderBot' );
	JaimeReyesClass		    = LoadScriptedPawnReplacementClass( class'JaimeReyes' );
	AlexJacobsonClass     = LoadScriptedPawnReplacementClass( class'AlexJacobson' );
	PaulDentonClass	      = LoadScriptedPawnReplacementClass( class'PaulDenton' );

	// Decorations.
	Keypad1Class         = LoadDecorationReplacementClass( class'Keypad1' );
	Keypad3Class         = LoadDecorationReplacementClass( class'Keypad3' );
	AlarmUnitClass       = LoadDecorationReplacementClass( class'AlarmUnit' );
	BlackHelicopterClass = LoadDecorationReplacementClass( class'BlackHelicopter' );
	BookOpenClass        = LoadDecorationReplacementClass( class'BookOpen' );
	VanClass             = LoadDecorationReplacementClass( class'Van' );
	CarWreckedClass      = LoadDecorationReplacementClass( class'CarWrecked' );
	RoadBlockClass       = LoadDecorationReplacementClass( class'RoadBlock' );

	// Carcasses.
	HKMilitaryCarcassClass    = LoadCarcassReplacementClass( class'HKMilitaryCarcass' );
	TriadLumPathCarcassClass  = LoadCarcassReplacementClass( class'TriadLumPathCarcass' );
	TriadLumPath2CarcassClass = LoadCarcassReplacementClass( class'TriadLumPath2Carcass' );
	TriadRedArrowCarcassClass = LoadCarcassReplacementClass( class'TriadRedArrowCarcass' );

	// Misc.
	ChopperMissileClass = Class<HXRocket>(LoadActorReplacementClass( class'RocketLAW' ));
}

// ----------------------------------------------------------------------------
// RandomizeEvents()
//
// Randomizes what happened at this Mission, so one would not start blank
// with what happened in prior mission.
// ----------------------------------------------------------------------------

static function RandomizeEvents( HXGameInfo Game, HXSteve Steve, int MissionNumber, String MapName )
{
	Super.RandomizeEvents( Game, Steve, MissionNumber, MapName );
}

// ----------------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------------

function FirstFrame()
{
	local HXScriptedPawn ScriptedPawn;
	local HXDecoration Decoration;
	local HXCarcass Carcass;
	local HXMover Mover;
	local Actor Actor;

	Super.FirstFrame();

	//
	// 06_HONGKONG_WANCHAI_STREET.
	//
	if ( LocalURL=="06_HONGKONG_WANCHAI_STREET" )
	{
		// Fix for non opening Dispalycase [sic!] in maggies apartment.
		// Okay, won't work as it misses the keyframes too.
		/*foreach AllActors( Class'HXMover', Mover, 'Dispalycase' )
			Mover.bIsDoor = True;*/
	}

	//
	// 06_HONGKONG_VERSALIFE.
	//
	else if ( LocalURL=="06_HONGKONG_VERSALIFE" )
	{
		if ( GetBoolFlag('M07Briefing_Played') )
		{
			PawnsEnterWorld( MJ12CommandoClass );
		}
	}

	//
	// 06_HONGKONG_WANCHAI_CANAL.
	//
	else if ( LocalURL=="06_HONGKONG_WANCHAI_CANAL" )
	{
		if ( !GetBoolFlag('Supervisor01_Dead') && GetBoolFlag('HaveROM') )
		{
			foreach AllActors( Class'HXCarcass', Carcass, 'John_Smith_Body' )
				Carcass.bHidden = false;
		}
	}

	//
	// 06_HONGKONG_MJ12LAB.
	//
	else if ( LocalURL=="06_HONGKONG_MJ12LAB" )
	{
		if ( GetBoolFlag('M07Briefing_Played') )
		{
			PawnsEnterWorld( MJ12CommandoClass );
			PawnsEnterWorld( SpiderBotClass );

			if ( Keypad3Class!=None )
			{
				foreach AllActors( Keypad3Class, Actor )
				{
					switch ( Actor.Tag )
					{
						case 'DummyKeypad_02':
							Actor.Destroy();
							break;
						
						case 'RealKeypad_02':
							Actor.bHidden = False;
							break;

						default:
							break;
					}
				}
			}
		}
	}

	//
	// 06_HONGKONG_TONGBASE.
	//
	else if ( LocalURL=="06_HONGKONG_TONGBASE" )
	{
		if ( GetBoolFlag('Versalife_Done') )
		{
			PawnsEnterWorld( PaulDentonClass );
			PawnsEnterWorld( TriadRedArrowClass, 'TriadRedArrow' );
		}

		// Unhide Jaime Reyes.
		if ( GetBoolFlag('JaimeRecruited') && GetBoolFlag('Versalife_Done') )
		{
			PawnsEnterWorld( JaimeReyesClass );
		}

		// Unhide Alex Jacobson.
		if (GetBoolFlag('JacobsonRecruited'))
		{
			PawnsEnterWorld( AlexJacobsonClass );
		}
	}

	//
	// 06_HONGKONG_WANCHAI_UNDERWORLD.
	//
	else if ( LocalURL=="06_HONGKONG_WANCHAI_UNDERWORLD" )
	{
		if ( GetBoolFlag('QuickLetPlayerIn') )
		{
			PawnsEnterWorld( MJ12CommandoClass, 'MJ12Commando' );
		}

		if ( GetBoolFlag('TriadCeremony_Played') )
		{
			SetBoolFlag( 'DragonHeadsInLuckyMoney', True, True, 8 );

			// Remove all Carcasses.
			foreach AllActors( Class'HXCarcass', Carcass )
				Carcass.Destroy();
		}

		if ( GetBoolFlag('DragonHeadsInLuckyMoney') && !GetBoolFlag('MS_ChenTeleported') )
		{
			// Make the DragonHeads go drunk.
			PawnsEnterWorld( GordonQuickClass );
			if ( MaxChenClass!=None )
				foreach AllActors( MaxChenClass, Actor )
					TeleportPawn( HXScriptedPawn(Actor), 'ChenAtBar', 'Standing');

			SetBoolFlag( 'MS_ChenTeleported', True, True, 8 );
		}
	}

	//
	// 06_HONGKONG_WANCHAI_GARAGE.
	//
	else if ( LocalURL=="06_HONGKONG_WANCHAI_GARAGE" )
	{
		if ( GetBoolFlag('M07Briefing_Played') )
		{
			// Remove remaining military guys.
			DestroyActors( HKMilitaryClass, 'RumbleCops' );

			// Remove Carcasses.
			DestroyActors( HKMilitaryCarcassClass );
			DestroyActors( TriadLumPathCarcassClass );
			DestroyActors( TriadLumPath2CarcassClass );
			DestroyActors( TriadRedArrowCarcassClass ); // Remove RedArrow too? Poll said yes.

			// Unblock VersaLife back entrance.
			DestroyActors( VanClass, 'Van01' );
			DestroyActors( CarWreckedClass );
			DestroyActors( RoadBlockClass );
		}
	}

	//
	// 06_HONGKONG_WANCHAI_MARKET.
	//
	else if ( LocalURL=="06_HONGKONG_WANCHAI_MARKET" )
	{
		// Prepare for the ceremony.
		if ( GetBoolFlag('Have_ROM') && GetBoolFlag('MeetTracerTong_Played') && !GetBoolFlag('TriadCeremony_Played') ) // Check CeremonyReadyToBegin?
		{
			foreach AllActors( Class'HXScriptedPawn', ScriptedPawn )
			{
				switch ( ScriptedPawn.Tag )
				{
					case 'MarketMonk01':
						ScriptedPawn.EnterWorld();
						break;

					case 'MarketKid':
						ScriptedPawn.Destroy();
						break;

					default:
						if ( ClassIsChildOf(ScriptedPawn.Class,GordonQuickClass) )
							TeleportPawn( ScriptedPawn, 'QuickInTemple', 'Standing' );
						else if ( ClassIsChildOf(ScriptedPawn.Class,MaxChenClass) )
							TeleportPawn( ScriptedPawn, 'ChenInTemple', 'Standing' );
						break;
				}
			}

			SetBoolFlag( 'CeremonyReadyToBegin', True, True, 8 );
		}

		// Remove the secretary.
		if ( GetBoolFlag('MarketShopperOverheard_Played') )
		{
			foreach AllActors( Class'HXScriptedPawn', ScriptedPawn, 'MarketShopperFlowers' )
				ScriptedPawn.Destroy();
		}

		// Set up the catering situation.
		if ( GetBoolFlag('CatererConvo_Played' ))
		{
			foreach AllActors( Class'HXScriptedPawn', ScriptedPawn, 'TeaHouseRedArrow' )
				TeleportPawn( ScriptedPawn, 'TalkToCaterer', 'Wandering');
		}
		else if ( GetBoolFlag('TeaHouseDrama_Played') )
		{
			foreach AllActors( Class'HXScriptedPawn', ScriptedPawn, 'TeaHouseRedArrow' )
				TeleportPawn( ScriptedPawn, 'TalkToCaterer', 'Standing');

			SetBoolFlag( 'ReadyForCaterer', True, True, 8 );
		}

		// Remove some people after tea house drama has been played
		if ( GetBoolFlag('TeaHouseDrama_Played') )
		{
			foreach AllActors( Class'HXScriptedPawn', ScriptedPawn )
			{
				switch ( ScriptedPawn.Tag )
				{
					case 'TeaHouseCustomer':
					case 'TeaHouseWoman':
						ScriptedPawn.Destroy();
						break;

					default:
						break;
				}
			}
		}

		// Move the kid around to the correct spot.
		if ( GetBoolFlag('KidGetsMoney_Played') )
		{
			foreach AllActors( Class'HXScriptedPawn', ScriptedPawn, 'MarketKid' )
				TeleportPawn( ScriptedPawn, 'KidAtNewsStand', 'Wandering' );
		}
		else if ( GetBoolFlag('KidSetsFire_Played') )
		{
			foreach AllActors( Class'HXScriptedPawn', ScriptedPawn, 'MarketKid' )
				TeleportPawn( ScriptedPawn, 'KidAtNewsStand', 'Standing' );

			SetBoolFlag( 'MarketKidReadyForFifth', True, True, 8 );
		}
		else if ( GetBoolFlag('M06_Fire_Set'))
		{
			foreach AllActors( Class'HXScriptedPawn', ScriptedPawn, 'MarketKid' )
				TeleportPawn( ScriptedPawn, 'KidAtLumPath', 'Standing' );

			SetBoolFlag( 'MarketKidReadyForFourth', True, True, 8 );
		}
		else if ( GetBoolFlag('KidAsksForHelp_Played') )
		{
			foreach AllActors( Class'HXScriptedPawn', ScriptedPawn, 'MarketKid' )
				TeleportPawn( ScriptedPawn, 'KidSettingFire', 'Standing' );

			SetBoolFlag( 'MarketKidReadyForThird', True, True, 8 );
		}
		else if ( GetBoolFlag('KidAsksForWork_Played') )
		{
			foreach AllActors( Class'HXScriptedPawn', ScriptedPawn, 'MarketKid' )
				TeleportPawn( ScriptedPawn, 'KidAtLumPath', 'Standing' );

			SetBoolFlag( 'MarketKidReadyForSecond', True, True, 8 );
		}

		// Unhide the helicopter if it's time.
		if ( GetBoolFlag('M08Briefing_Played') )
		{
			DecorationsEnterWorld( BlackHelicopterClass );
		}

		// Unhide a book.
		if ( GetBoolFlag('M07Briefing_Played') )
		{
			if ( BookOpenClass!=None )
				foreach AllActors( BookOpenClass, Actor, 'TempleBook' )
					Actor.bHidden = False;
		}

		// randomly place the goth chick
		foreach AllActors( Class'HXScriptedPawn', ScriptedPawn, 'MarketGoth' )
		{
			switch ( Rand(3) )
			{
				case 0:
					TeleportPawn( ScriptedPawn, 'GothAtFlower', 'Standing' );
					SetBoolFlag( 'GothAtFlower',  True,  True, 8 );
					SetBoolFlag( 'GothAtButcher', False, True, 8 );
					SetBoolFlag( 'GothAtVase',    False, True, 8 );
					break;
			
				case 1:
					TeleportPawn( ScriptedPawn, 'GothAtButcher', 'Standing');
					SetBoolFlag( 'GothAtFlower',  False, True, 8 );
					SetBoolFlag( 'GothAtButcher', True,  True, 8 );
					SetBoolFlag( 'GothAtVase',    False, True, 8 );
					break;

				case 2:
					TeleportPawn( ScriptedPawn, 'GothAtVase', 'Standing');
					SetBoolFlag( 'GothAtFlower',  False, True, 8 );
					SetBoolFlag( 'GothAtButcher', False, True, 8 );
					SetBoolFlag( 'GothAtVase',    True,  True, 8 );
					break;
			}
		}
	}
}

// ----------------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------------

function PreTravel()
{
	Super.PreTravel();
}

// ----------------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------------

function Timer()
{
	local RatGenerator RatGenerator;
	local Dispatcher Dispatcher;
	local PatrolPoint PatrolPoint;
	local Actor Actor;
	local HXMover Mover;
	local int Count;

	Super.Timer();

	//
	// 06_HONGKONG_WANCHAI_STREET
	//
	if ( LocalURL=="06_HONGKONG_WANCHAI_STREET" )
	{
		// Unhide Walton Simons.
		if ( GetBoolFlag('WaltonAppears') && !GetBoolFlag('MS_WaltonUnhidden') )
		{
			PawnsEnterWorld( WaltonSimonsClass );
			SetBoolFlag('MS_WaltonUnhidden', True, True, 8);
		}

		// Hide Walton Simons.
		if ( GetBoolFlag('M06WaltonHolo_Played') && !GetBoolFlag('MS_WaltonHidden') )
		{
			PawnsLeaveWorld( WaltonSimonsClass );
			SetBoolFlag('MS_WaltonHidden', True, True, 8);
		}
	}

	//
	// 06_HONGKONG_WANCHAI_UNDERWORLD
	//
	else if ( LocalURL=="06_HONGKONG_WANCHAI_UNDERWORLD" )
	{
		// Make Commandos raid the club.
		if ( GetBoolFlag('MaxChenConvinced') && !GetBoolFlag('MS_CommandosUnhidden') )
		{
			PawnsEnterWorld( MJ12CommandoClass, 'RaidingCommando' );
			SetBoolFlag('MS_CommandosUnhidden', True, True, 8);
		}

		// Set a flag to False when all the commandos are dead.
		if ( GetBoolFlag('Raid_Underway') )
		{
			Count = 0;
			if ( MJ12CommandoClass!=None  )
			{
				foreach AllActors( MJ12CommandoClass, Actor, 'RaidingCommando')
				{
					Count++;
					break;
				}
			}
			if ( Count==0 )
			{
				SetBoolFlag( 'Raid_Underway', False, True, 8 );
				SetBoolFlag( 'M06AmbushDone', True,  True, 8 );
			}
		}

		// Set a home base for Tessa.
		if ( GetBoolFlag('ReadyForMercedes2') && !GetBoolFlag('MS_HomeBaseSet') )
		{
			PatrolPoint = GetPatrolPoint('PartyGirlInClub02');
			if ( PatrolPoint!=None )
			{
				if ( LowerClassFemaleClass!=None )
					foreach AllActors( LowerClassFemaleClass, Actor, 'ClubTessa')
						HXScriptedPawn(Actor).SetHomeBase( PatrolPoint.Location, PatrolPoint.Rotation );
			}
			SetBoolFlag( 'MS_HomeBaseSet', True, True, 8 );
		}
	}

	//
	// 06_HONGKONG_WANCHAI_GARAGE
	//
	else if ( LocalURL=="06_HONGKONG_WANCHAI_GARAGE" )
	{
		//
		// Note: Should the _Lost flags get set after the first party died?
		//

		// Count the number of military guys.
		if ( !GetBoolFlag('RumbleCops_Lost') )
		{
			Count = 0;
			if ( HKMilitaryClass!=None )
			{
				foreach AllActors( HKMilitaryClass, Actor, 'RumbleCops' )
				{
					Count++;
					break;
				}
			}
			if ( Count==0 )
				SetBoolFlag( 'RumbleCops_Lost', True, True, 8 );
		}

		// Count the number of RedArrow.
		if ( !GetBoolFlag('RumbleRedArrow_Lost') )
		{
			Count = 0;
			if ( TriadRedArrowClass!=None )
			{
				foreach AllActors( TriadRedArrowClass, Actor, 'RumbleRedArrow')
				{
					Count++;
					break;
				}
			}
			if ( Count==0 )
				SetBoolFlag( 'RumbleRedArrow_Lost', True, True, 8 );
		}

		// Count the number of LumPath.
		if ( !GetBoolFlag('RumbleLumPath_Lost') )
		{
			Count = 0;
			if ( TriadLumPathClass!=None )
			{
				foreach AllActors( TriadLumPathClass, Actor, 'RumbleLumPath' )
				{
					Count++;
					break;
				}
			}
			if ( Count==0 )
				SetBoolFlag( 'RumbleLumPath_Lost', True, True, 8 );
		}
	}

	//
	// 06_HONGKONG_WANCHAI_MARKET
	//
	else if ( LocalURL=="06_HONGKONG_WANCHAI_MARKET" )
	{
		// Release the rats!
		if ( GetBoolFlag('TeaHouseDrama_Played') && !GetBoolFlag('MS_RatsReleased') )
		{
			foreach AllActors( Class'RatGenerator', RatGenerator )
				RatGenerator.Trigger( Self, Player );

			SetBoolFlag( 'MS_RatsReleased', True, True, 8 );
		}

		// Trigger something.
		if ( GetBoolFlag('CatererConvo_Played') && !GetBoolFlag('MS_ConvoTrigger1') )
		{
			foreach AllActors( Class'Actor', Actor, 'TeaHouseRedArrowWanders' )
				Actor.Trigger( Self, None );

			SetBoolFlag( 'MS_ConvoTrigger1', True, True, 8 );
		}

		// Trigger something.
		if ( GetBoolFlag('TeaHouseDrama_Played') && !GetBoolFlag('MS_ConvoTrigger2') )
		{
			foreach AllActors( Class'Actor', Actor, 'TeaHouseRedArrowPatrol' )
				Actor.Trigger( Self, None );

			foreach AllActors( Class'Actor', Actor, 'MarketWaiterWanders' )
				Actor.Trigger( Self, None );

			SetBoolFlag( 'MS_ConvoTrigger2', True, True, 8 );
		}

		// Trigger something.
		if ( GetBoolFlag('FlowerShopperOverheard_Played') && !GetBoolFlag('MS_ConvoTrigger3') )
		{
			foreach AllActors( Class'Actor', Actor, 'MarketShopperFlowersWanders' )
				Actor.Trigger( Self, None );

			SetBoolFlag( 'MS_ConvoTrigger3', True, True, 8 );
		}

		// Move the kid around to the correct spot.
		if ( GetBoolFlag('KidGetsMoney_Played') && !GetBoolFlag('MS_ConvoTrigger4') )
		{
			foreach AllActors(Class'Actor', Actor, 'KidWanders')
				Actor.Trigger( Self, None );

			SetBoolFlag( 'MS_ConvoTrigger4', True, True, 8 );
		}
		else if ( GetBoolFlag('KidSetsFire_Played') && !GetBoolFlag('MS_ConvoTrigger5') )
		{
			foreach AllActors(Class'Actor', Actor, 'KidGoesToNewsStand')
				Actor.Trigger( Self, None );

			SetBoolFlag( 'MS_ConvoTrigger5', True, True, 8 );
		}
		else if ( GetBoolFlag('KidStealsSomething_Played') && !GetBoolFlag('MS_ConvoTrigger6') )
		{
			foreach AllActors(Class'Actor', Actor, 'KidGoesToLumPath')
				Actor.Trigger( Self, None );

			SetBoolFlag( 'MS_ConvoTrigger6', True, True, 8 );
		}
		else if (GetBoolFlag('KidAsksForHelp_Played') && !GetBoolFlag('MS_ConvoTrigger7') )
		{
			foreach AllActors(Class'Actor', Actor, 'KidGoesToNewsStand')
				Actor.Trigger( Self, None );

			SetBoolFlag( 'MS_ConvoTrigger7', True, True, 8 );
		}
		else if ( GetBoolFlag('KidAsksForWork_Played') && !GetBoolFlag('MS_ConvoTrigger8') )
		{
			foreach AllActors( Class'Actor', Actor, 'KidGoesToLumPath' )
				Actor.Trigger( Self, None );

			SetBoolFlag( 'MS_ConvoTrigger8', True, True, 8 );
		}

		// Hide/unhide some keypads.
		if ( GetBoolFlag('QuickLetPlayerIn') && !GetBoolFlag('MS_KeypadsMoved') )
		{
			if ( Keypad1Class!=None )
			{
				foreach AllActors( Keypad1Class, Actor )
				{
					switch ( Actor.Tag )
					{
						case 'DummyKeypad01':
							Actor.Destroy();
							break;

						case 'GateKeypad':
						case 'BasementKeypad':
							Actor.bHidden = False;
							Actor.bHidden = False;
							break;

						default:
							break;
					}
				}
			}

			SetBoolFlag( 'MS_KeypadsMoved', True, True, 8 );
		}
	}

	//
	// 06_HONGKONG_HELIBASE
	//
	else if ( LocalURL=="06_HONGKONG_HELIBASE" )
	{
		// Start an InfoLink when helicopter is armed.
		if ( GetBoolFlag('helicopter_armed') && !GetBoolFlag('MS_JockInfoLink') )
		{
			StartDataLinkTransmission( "DL_Jock_02" );
			SetBoolFlag( 'MS_JockInfoLink', True, True, 8 );
		}

		// Set the door rubble to be bBreakable.
		if ( GetBoolFlag('MS_DoorsBlown') && !GetBoolFlag('MS_RubbleBreakable') )
		{
			// Make the rubble breakable.
			foreach AllActors( Class'HXMover', Mover, 'DoorWreckage' )
				Mover.bBreakable = True;

			SetBoolFlag( 'MS_RubbleBreakable', True, True, 8 );
		}

		// Check to see if the doors are blown.
		if ( GetBoolFlag('MS_HelicopterFired') && !GetBoolFlag('MS_DoorsBlown') )
		{
			RocketFireTime += CheckTime;
			Count = 0;
			foreach AllActors( Class'HXMover', Mover, 'Blast_doors' )
			{
				if ( !Mover.bDestroyed )
				{
					Count++;
					break;
				}
			}

			if ( Count==0 )
			{
				// Have Jock bark at the player
				StartDataLinkTransmission( "DL_Jock_03" );

				// turn on the alarm
				if ( AlarmUnitClass!=None )
					foreach AllActors( AlarmUnitClass, Actor, 'AlarmUnit' )
						Actor.Trigger( None, None );

				// trigger the dispatcher
				foreach AllActors( Class'Dispatcher', Dispatcher, 'Go' )
					Dispatcher.Trigger(None, None);

				SetBoolFlag('MS_DoorsBlown', True, True, 8);
			}
			else
			{
				// keep firing every 3 seconds until the doors are gone
				if ( RocketFireTime>3 )
				{
					FireMissilesAt( 'Blast_doors' );
					RocketFireTime = 0;
				}
			}
		}

		// Start the helicopter firing sequence when triggered.
		if ( GetBoolFlag('helicopter_fire') && !GetBoolFlag('MS_HelicopterFired') )
		{
			// Have Jock bark at the player.
			StartDataLinkTransmission( "DL_Jock_Fired" );

			// Set the blast doors to be breakable.
			foreach AllActors( Class'HXMover', Mover, 'Blast_doors' )
				Mover.bBreakable = True;

			RocketFireTime = 0;
			FireMissilesAt('Blast_doors');

			SetBoolFlag( 'MS_HelicopterFired', True, True, 8 );
		}
	}

	//
	// 06_HONGKONG_STORAGE
	//
	else if ( LocalURL=="06_HONGKONG_STORAGE" )
	{
		// Make the AUC destroyable.
		if ( GetBoolFlag('ReadyToDestroyAUC') && !GetBoolFlag('MS_ReadyAUC') )
		{
			foreach AllActors( Class'HXMover', Mover )
			{
				switch ( Mover.Tag )
				{
					case 'Pod01':
					case 'Pod02':
					case 'Pod03':
					case 'Pod04':
					case 'AUC':
						Mover.bBreakable = True;
						break;

					default:
						break;
				}
			}

			SetBoolFlag( 'MS_ReadyAUC', True, True, 8 );
		}
	}

	//
	// 06_HONGKONG_WANCHAI_CANAL
	//
	else if ( LocalURL=="06_HONGKONG_WANCHAI_CANAL" )
	{
		if ( GetBoolFlag('Overhear_Canal_Thug1_Played') && !GetBoolFlag('MS_DrugDealersAttacking') )
		{
			foreach AllActors( Class'Actor', Actor, 'CanalDrugDealersAttack' )
				Actor.Trigger( Self, Player );

			SetBoolFlag( 'MS_DrugDealersAttacking', True, True, 8 );
		}
	}
}

// ----------------------------------------------------------------------------
// FireMissilesAt()
//
// Fire missiles from the helicopter.
// ----------------------------------------------------------------------------

function FireMissilesAt( Name TargetTag )
{
	local Actor Chopper, Target;
	local Vector SpawnLocation;
	local HXRocket Rocket;
	local int i;

	Log( "FireMissilesAt() called.", 'DevMissionScript' );

	if ( BlackHelicopterClass==None )
		return;

	foreach AllActors( Class'Actor', Target, TargetTag )
		break;

	Log( "Target = " $ Target, 'DevMissionScript' );

	foreach AllActors( BlackHelicopterClass, Chopper, 'chopper' )
	{
		for ( i=-1; i<=1; i+=2 )
		{
			SpawnLocation  = (i*Chopper.CollisionRadius * vect(0,0.15,0)) >> Chopper.Rotation;
			SpawnLocation += Chopper.Location;
			Rocket = Spawn( ChopperMissileClass, Chopper, , SpawnLocation, Chopper.Rotation );
			if ( Rocket!=None )
			{
				Rocket.bTracking = True;
				Rocket.Target    = Target;
				Rocket.PlaySound( Sound'RocketIgnite', SLOT_None, 2.0,, 2048 );
			}
		}
		break; // Only one chopper!
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	PrevMissionScript=Class'HX.HXMission05'
	NextMissionScript=Class'HX.HXMission08'
}
