//=============================================================================
// HXMission08.
//=============================================================================
class HXMission08 expands HXMissionScript;

var Class<HXScriptedPawn> UNATCOTroopClass, MJ12TroopClass, RiotCopClass, SandraRentonClass,
                          FordSchickClass, JanitorClass, StantonDowdClass, ThugMaleClass;
var Class<HXDecoration>   BlackHelicopterClass;

// ----------------------------------------------------------------------------
// LoadClasses()
// ----------------------------------------------------------------------------

function LoadClasses()
{
	Super.LoadClasses();

	// ScriptedPawns.
	UNATCOTroopClass	= LoadScriptedPawnReplacementClass( class'UNATCOTroop' );
	MJ12TroopClass	  = LoadScriptedPawnReplacementClass( class'MJ12Troop' );
	RiotCopClass	    = LoadScriptedPawnReplacementClass( class'RiotCop' );
	SandraRentonClass = LoadScriptedPawnReplacementClass( class'SandraRenton' );
	FordSchickClass	  = LoadScriptedPawnReplacementClass( class'FordSchick' );
	JanitorClass	    = LoadScriptedPawnReplacementClass( class'Janitor' );
	StantonDowdClass  = LoadScriptedPawnReplacementClass( class'StantonDowd' );
	ThugMaleClass	    = LoadScriptedPawnReplacementClass( class'ThugMale' );

	// Decorations,
	BlackHelicopterClass = LoadDecorationReplacementClass( class'BlackHelicopter' );
}

// ----------------------------------------------------------------------------
// RandomizeEvents()
//
// Randomizes what happened at this Mission, so one would not start blank
// with what happened in prior mission.
// ----------------------------------------------------------------------------

static function RandomizeEvents( HXGameInfo Game, HXSteve Steve, int MissionNumber, String MapName )
{
	Super.RandomizeEvents( Game, Steve, MissionNumber, MapName );
}

// ----------------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------------

function FirstFrame()
{
	Super.FirstFrame();

	//
	// *
	//
	if ( GetBoolFlag('SandraWentToCalifornia') )
	{
		DestroyActors( SandraRentonClass );
	}

	//
	// 08_NYC_SMUG
	//
	if ( LocalURL=="08_NYC_SMUG" )
	{
		// Unhide Ford if you've rescued him.
		if ( GetBoolFlag('FordSchickRescued') )
		{
			PawnsEnterWorld( FordSchickClass );
		}
	}
}

// ----------------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------------

function PreTravel()
{
	//
	// 08_NYC_STREET
	//
	if ( LocalURL=="08_NYC_STREET")
	{
		// Make sure that damn helicopter is gone.
		DestroyActors( BlackHelicopterClass, 'EntranceCopter' );
	}

	Super.PreTravel();
}

// ----------------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------------

function Timer()
{
	local Actor Actor, Stanton, Thug;
	local int Count;

	Super.Timer();

	//
	// 08_NYC_FREECLINIC
	//
	if ( LocalURL=="08_NYC_FREECLINIC" )
	{
		if ( GetBoolFlag('JoeGreene_Dead') && !GetBoolFlag('MS_GreeneGoalSet') )
		{
			CompleteGoal( 'KillGreene' );
			SetBoolFlag( 'MS_GreeneGoalSet', True, True, 9 );
		}
	}

	//
	// 08_NYC_STREET
	//
	else if ( LocalURL=="08_NYC_STREET" )
	{
		// Spawn reinforcements as cops are killed.
		if ( !GetBoolFlag('MS_UnhideTroop1') )
		{
			Count = 0;
			if ( RiotCopClass!=None )
			{
				foreach AllActors( RiotCopClass, Actor, 'Cop1' )
				{
					Count++;
					break;
				}
			}

			if ( Count==0 )
			{
				PawnsEnterWorld( UNATCOTroopClass, 'troop1' );
				SetBoolFlag( 'MS_UnhideTroop1', True, True, 9 );
			}
		}
		if ( !GetBoolFlag('MS_UnhideTroop2') )
		{
			Count = 0;
			if ( RiotCopClass!=None )
			{
				foreach AllActors( RiotCopClass, Actor, 'Cop2' )
				{
					Count++;
					break;
				}
			}

			if ( Count==0 )
			{
				PawnsEnterWorld( UNATCOTroopClass, 'troop2' );
				SetBoolFlag( 'MS_UnhideTroop2', True, True, 9 );
			}
		}
		if ( !GetBoolFlag('MS_UnhideTroop3') )
		{
			Count = 0;
			if ( RiotCopClass!=None )
			{
				foreach AllActors( RiotCopClass, Actor, 'Cop3' )
				{
					Count++;
					break;
				}
			}

			if ( Count==0 )
			{
				PawnsEnterWorld( UNATCOTroopClass, 'troop3' );
				SetBoolFlag( 'MS_UnhideTroop3', True, True, 9 );
			}
		}
		if (!GetBoolFlag('MS_UnhideTroop4'))
		{
			Count = 0;
			if ( RiotCopClass!=None )
			{
				foreach AllActors( RiotCopClass, Actor, 'Cop4' )
				{
					Count++;
					break;
				}
			}

			if ( Count==0 )
			{
				PawnsEnterWorld( UNATCOTroopClass, 'troop4' );
				SetBoolFlag( 'MS_UnhideTroop4', True, True, 9 );
			}
		}
		if (!GetBoolFlag('MS_UnhideTroop5'))
		{
			Count = 0;
			if ( RiotCopClass!=None )
			{
				foreach AllActors( RiotCopClass, Actor, 'Cop5' )
				{
					Count++;
					break;
				}
			}

			if ( Count==0 )
			{
				PawnsEnterWorld( UNATCOTroopClass, 'troop5' );
				SetBoolFlag( 'MS_UnhideTroop5', True, True, 9 );
			}
		}
		if ( !GetBoolFlag('MS_UnhideTroop6') )
		{
			Count = 0;
			if ( RiotCopClass!=None )
			{
				foreach AllActors( RiotCopClass, Actor, 'Cop6' )
				{
					Count++;
					break;
				}
			}

			if ( Count==0 )
			{
				PawnsEnterWorld( UNATCOTroopClass, 'troop6' );
				SetBoolFlag( 'MS_UnhideTroop6', True, True, 9 );
			}
		}

		// Unhide Thomas Dieter.
		if ( !GetBoolFlag('MS_ThomasUnhidden') && GetBoolFlag('HarleyFilben_Dead') )
		{
			PawnsEnterWorld( JanitorClass, 'ThomasDieter' );
			SetBoolFlag( 'MS_ThomasUnhidden', True, True, 9 );
		}

		// Unhide Stanton Dowd.
		if ( !GetBoolFlag('MS_StantonUnhidden') && (GetBoolFlag('M08MeetHarleyFilben_Played') || GetBoolFlag('MeetThomasDieter_Played')) )
		{
			PawnsEnterWorld( StantonDowdClass, 'StantonDowd' );
			SetBoolFlag( 'MS_StantonUnhidden', True, True, 9 );
		}

		// Unhide shady guy.
		if ( !GetBoolFlag('MS_ShadyGuyUnhidden') && GetBoolFlag('MS_StantonUnhidden') )
		{
			if ( (GetBoolFlag('GreenKnowsAboutDowd') && !GetBoolFlag('JoeGreen_Dead')) || GetBoolFlag('SheaKnowsAboutDowd') )
			{
				PawnsEnterWorld( ThugMaleClass, 'ShadyGuy' );
				SetBoolFlag( 'MS_ShadyGuyUnhidden', True, True, 9 );
			}
		}

		// Spawn MJ12 attack force when Shady Guy gets close (8 feet) to Dowd.
		if ( !GetBoolFlag('StantonAmbush') )
		{
			Stanton = None;
			if ( StantonDowdClass!=None )
				foreach AllActors( StantonDowdClass, Stanton, 'StantonDowd' )
					break;

			if ( Stanton!=None )
			{
				Thug = None;
				if ( ThugMaleClass!=None )
					foreach AllActors( ThugMaleClass, Thug, 'ShadyGuy' )
						break;

				if ( Thug!=None )
				{
					if ( VSize(Thug.Location-Stanton.Location)<=128 )
					{
						PawnsEnterWorld( MJ12TroopClass, 'MJ12AttackForce' );
						SetBoolFlag( 'StantonAmbush', True, True, 9 );
					}
				}
			}
		}

		// Spawn MJ12 attack force when a flag is set.
		if ( !GetBoolFlag('StantonAmbush') && GetBoolFlag('MJ12Converging') )
		{
			PawnsEnterWorld( MJ12TroopClass, 'MJ12AttackForce' );
			SetBoolFlag( 'StantonAmbush', True, True, 9 );
		}

		// If the MJ12 attack force is killed, set a flag.
		if ( GetBoolFlag('StantonAmbush') && !GetBoolFlag('StantonAmbushDefeated') )
		{
			Count = 0;
			if ( MJ12TroopClass!=None )
			{
				foreach AllActors( MJ12TroopClass, Actor, 'MJ12AttackForce' )
				{
					Count++;
					break;
				}
			}

			if ( Count==0 )
			{
				SetBoolFlag( 'StantonAmbushDefeated', True, True, 9 );
			}
		}

		// Unhide the helicopter when its time.
		if ( GetBoolFlag('StantonDowd_Played') && GetBoolFlag('DL_Exit_Played') && !GetBoolFlag('MS_Helicopter_Unhidden') )
		{
			DecorationsEnterWorld( BlackHelicopterClass, 'CopterExit' );
			SetBoolFlag('MS_Helicopter_Unhidden', True, True, 9);
		}
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	PrevMissionScript=Class'HX.HXMission06'
	NextMissionScript=Class'HX.HXMission09'
}
