//=============================================================================
// HXMission09.
//=============================================================================
class HXMission09 expands HXMissionScript;

var Class<HXScriptedPawn> MJ12TroopClass, MJ12CommandoClass, WaltonSimonsClass;
var Class<HXDecoration>   BlackHelicopterClass;

// ----------------------------------------------------------------------------
// LoadClasses()
// ----------------------------------------------------------------------------

function LoadClasses()
{
	Super.LoadClasses();

	// ScriptedPawns.
	MJ12TroopClass	  = LoadScriptedPawnReplacementClass( class'MJ12Troop' );
	MJ12CommandoClass = LoadScriptedPawnReplacementClass( class'MJ12Commando' );
	WaltonSimonsClass	= LoadScriptedPawnReplacementClass( class'WaltonSimons' );

	// Decorations,
	BlackHelicopterClass = LoadDecorationReplacementClass( class'BlackHelicopter' );
}

// ----------------------------------------------------------------------------
// RandomizeEvents()
//
// Randomizes what happened at this Mission, so one would not start blank
// with what happened in prior mission.
// ----------------------------------------------------------------------------

static function RandomizeEvents( HXGameInfo Game, HXSteve Steve, int MissionNumber, String MapName )
{
	Super.RandomizeEvents( Game, Steve, MissionNumber, MapName );
}

// ----------------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------------

function FirstFrame()
{
	local HXMover Mover;

	Super.FirstFrame();

	//
	// 09_NYC_SHIP
	//
	if ( LocalURL=="09_NYC_SHIP" )
	{
		if ( GetBoolFlag('ShipBreech') )
		{

			foreach AllActors( Class'HXMover', Mover )
			{
				switch ( Mover.Tag )
				{
					// Close and lock the doors.
					case 'SewerGrate':
					case 'FrontDoor':
						if ( Mover.KeyNum!=0 )
							Mover.Trigger( None, None );
						Mover.bBreakable = False;
						Mover.bPickable  = False;
						Mover.bFrobbable = False;
						Mover.bLocked    = True;
						break;

					default:
						break;
				}
			}
		}

		// Raise the alarm after we have blown up the ship.
		if ( GetBoolFlag('MS_ShipBreeched') )
		{
			SetAmbientAlarmSound();
		}
	}

	//
	// 09_NYC_DOCKYARD
	//
	else if ( LocalURL=="09_NYC_DOCKYARD" )
	{
		// Unhide helicopter.
		if ( GetBoolFlag('MS_ShipBreeched') )
		{
			DecorationsEnterWorld( BlackHelicopterClass, 'BlackHelicopter' );
		}
	}
}

// ----------------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------------

function PreTravel()
{
	Super.PreTravel();
}

// ----------------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------------

function Timer()
{
	local HXMover Mover;
	local Trigger Trigger;
	local int Count;

	Super.Timer();

	//
	// 09_NYC_SHIP
	//
	if ( LocalURL=="09_NYC_SHIP" )
	{
		// Unhide Walton Simons
		if ( !GetBoolFlag('MS_SimonsAppeared') && GetBoolFlag('SummonSimons') )
		{
			PawnsEnterWorld( WaltonSimonsClass );
			SetBoolFlag( 'MS_SimonsAppeared', true, true, 10 );
		}

		// Hide Walton Simons, and make this convo retriggerable.
		if ( GetBoolFlag('MS_SimonsAppeared') && GetBoolFlag('M09SimonsDisappears') )
		{
			PawnsLeaveWorld( WaltonSimonsClass );

			SetBoolFlag( 'M09SimonsDisappears', false, true, 10 );
			SetBoolFlag( 'MS_SimonsAppeared',   false, true, 10 );
			SetBoolFlag( 'SummonSimons',        false, true, 10 );
		}

		// Randomly play explosions and shake the view if the ship has been breeched.
		if ( GetBoolFlag('MS_ShipBreeched') )
		{
			ShipExplosionEffects( false );
		}
	}

	//
	// 09_NYC_SHIPBELOW
	//
	else if ( LocalURL=="09_NYC_SHIPBELOW" )
	{
		// Check for blown up ship.
		if ( !GetBoolFlag('MS_ShipBreeched') )
		{
			Count = 0;
			foreach AllActors( Class'HXMover', Mover, 'ShipBreech' )
			{
				if ( !Mover.bDestroyed )
				{
					Count++;
					break;
				}
			}

			if ( Count==0 )
			{
				if ( GetBoolFlag('Bilge') )
				{
					StartDataLinkTransmission( "DL_AllDone" );

					// Raise the alarm after we have blown up the ship.
					SetAmbientAlarmSound();

					SetBoolFlag( 'MS_ShipBreeched', true, true, 10 );
				}
				else if ( !GetBoolFlag('DL_AllPlaced_Played') )
				{
					StartDataLinkTransmission( "DL_AllPlaced" );
				}
			}
		}

		// Randomly play explosions and shake the view if the ship has been breeched.
		if ( GetBoolFlag('MS_ShipBreeched') )
		{
			ShipExplosionEffects( true );
		}
	}

	//
	// 09_NYC_GRAVEYARD
	//
	else if ( LocalURL=="09_NYC_GRAVEYARD" )
	{
		// Unhide the helicopter and more troops when the "little device" is destroyed
		if ( !GetBoolFlag('MS_UnhideHelicopter') && (GetBoolFlag('deviceDestroyed') && GetBoolFlag('M09MeetStantonDowd_Played')) )
		{
			DecorationsEnterWorld( BlackHelicopterClass, 'BlackHelicopter' );
			PawnsEnterWorld( MJ12TroopClass, 'TroopSupport' );

			StartDataLinkTransmission( "DL_ComingIn" );
			
			SetBoolFlag( 'MS_UnhideHelicopter', true, true, 10 );
		}

		// Activate a trigger and unhide some troops once Stanton Dowd has been talked to.
		if ( !GetBoolFlag('MS_TriggerOn') && GetBoolFlag('M09MeetStantonDowd_Played') )
		{
			foreach AllActors( Class'Trigger', Trigger, 'TunnelTrigger' )
				Trigger.SetCollision( True );

			PawnsEnterWorld( MJ12TroopClass, 'TroopInsertion' );

			SetBoolFlag('MS_TriggerOn', true, true, 10);
		}

		// Spawn some commandos.
		if ( GetBoolFlag('GreenKnowsAboutDowd') && GetBoolFlag('suprisePoint') && !GetBoolFlag('MS_UnhideCommandos') )
		{
			PawnsEnterWorld( MJ12CommandoClass, 'paratroop' );

			SetBoolFlag( 'MS_UnhideCommandos', true, true, 10 );
		}
	}
}

// ----------------------------------------------------------------------------
// ShipExplosionEffects()
//
// Note: Maybe combine the sounds + frags falling into a single effect.
//       Maybe the Pawn.Velocity += Bobble actually does nothing.
// ----------------------------------------------------------------------------

function ShipExplosionEffects( bool bFragments )
{
	local HXDecoration Decoration;
	local Sound ExplosionSound;
	local Pawn Pawn;
	local Actor HitActor;
	local DeusExFragment Fragment;
	local Vector Bobble, TraceStart, TraceEnd, HitLocation, HitNormal, RandMainDecoMove;
	local float ShakeTime, ShakeRoll, ShakeVert;
	local float Temp, Size, ExplosionChance;
	local int NumFragments, i;

	if ( bFragments ) 
		ExplosionChance = 0.66; // 09_NYC_SHIP
	else
		ExplosionChance = 0.9;  // 09_NYC_SHIPBELOW

	if ( ExplosionChance<FRand() )
		return;

	// Pick a random explosion size and modify everything accordingly.
	Size      = FRand();
	ShakeTime =   0.5 + Size;
	ShakeRoll = 512.0 + Size * 1024.0;
	ShakeVert =   8.0 + Size *   16.0;
	Bobble    = Vect(300.0,300.0,200.0) + 500.0 * Size * VRand();

	// Scale amount of Fragments per player based on player count.
	if ( Level.Game.NumPlayers>0 )
	{
		Temp = Size * 20.0 / Level.Game.NumPlayers;
		NumFragments = Int(Temp+0.5);
	}
	else
	{
		NumFragments = 1;
	}

	// Pick a sound.
	if ( Size<0.2 )
		ExplosionSound = Sound'SmallExplosion1';
	else if ( Size<0.4 )
		ExplosionSound = Sound'MediumExplosion1';
	else if ( Size<0.6 )
		ExplosionSound = Sound'MediumExplosion2';
	else if ( Size<0.8 )
		ExplosionSound = Sound'LargeExplosion1';
	else
		ExplosionSound = Sound'LargeExplosion2';

	RandMainDecoMove = Size * VRand();

	// Handle HangingDecoration and Carts.
	foreach AllActors( Class'HXDecoration', Decoration )
	{
		// Make all the hanging decorations sway randomly.
		if ( Decoration.bIsHangingDecoration )
		{
			// HangingDecoration will call CallculateHit() and 
			// set bSwaying=True when taking damage. 'JustSway'
			// DamageType was added so they just start to sway.
			Decoration.TakeDamage( 0, None, Decoration.Location + 10.0 * FRand() * VRand(), 0.5 * Bobble, 'JustSway' );
		}
		// Make all the carts move randomly.
		else if ( Decoration.bIsCart )
		{
			// Note: Maybe transfer it into a TakeDamage with 'JustRoll'.
			Decoration.StartRolling( Vect(-100.0,-100.0,0.0) + 200.0 * (RandMainDecoMove + 0.1 * Size * VRand()) );
		}
		// Make Containers randomly slightly move.
		/*else if ( Decoration.bIsContainer ) // Doesn't work.
		{
			Decoration.Velocity += (RandMainDecoMove + 0.1 * Size * VRand()) * (1000.0 / Decoration.Mass);
		}*/
	}

	// Handle PlayerPawns.
	for ( Pawn=Level.PawnList; Pawn!=None; Pawn=Pawn.NextPawn )
	{
		if ( Pawn.bIsPlayer )
		{
			// Play a sound.
			Pawn.PlaySound( ExplosionSound, SLOT_None, 2.0, , 16384 );

			// Shake the view.
			Pawn.ShakeView( ShakeTime, ShakeRoll, ShakeVert );

			// Bobble the player around.
			Pawn.Velocity += Bobble;

			// Have random metal fragments fall from the ceiling.
			if ( bFragments )
			{
				for ( i=0; i<NumFragments; i++ )
				{
					TraceStart   = Pawn.Location + 256.0 * VRand();
					TraceStart.Z = Pawn.Location.Z;
					TraceEnd     = TraceStart;
					TraceEnd.Z  += 1024.0;

					HitActor = Trace( HitLocation, HitNormal, TraceEnd, TraceStart, False );
					if ( HitActor==None )
						HitLocation = TraceEnd;

					Fragment = Spawn( Class'MetalFragment', , , HitLocation );
					if ( Fragment!=None )
					{
						Fragment.CalcVelocity( Vect(20000,0,0), 256 );
						Fragment.DrawScale = 0.5 + 2.0 * FRand();
						if ( FRand()<0.25 )
							Fragment.bSmoking = True;
					}
				}
			}
		}
	}
}

// ----------------------------------------------------------------------------
// SetAmbientAlarmSound() -- Applies alarm ambient sound to all ZoneInfos
// ----------------------------------------------------------------------------

function SetAmbientAlarmSound()
{
	local ZoneInfo Zone;

	// Make sure all zones have an alarm ambient sound.
	foreach AllActors( Class'ZoneInfo', Zone )
	{
		//if ( !Zone.IsA('SkyZoneInfo') )
		//{
			Zone.AmbientSound = Sound'Klaxon';
			Zone.SoundRadius  = 255;
			Zone.SoundVolume  = 255;
		//}
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	PrevMissionScript=Class'HX.HXMission08'
	NextMissionScript=Class'HX.HXMission10'
}
