//=============================================================================
// HXMission10.
//=============================================================================
class HXMission10 expands HXMissionScript;

var Class<HXScriptedPawn> NicoletteDuClareClass, JaimeReyesClass, GreaselClass, GuntherHermannClass,
                          MJ12CommandoClass;
var Class<HXDecoration>   BlackHelicopterClass;

// ----------------------------------------------------------------------------
// LoadClasses()
// ----------------------------------------------------------------------------

function LoadClasses()
{
	Super.LoadClasses();

	// ScriptedPawns.
	NicoletteDuClareClass	= LoadScriptedPawnReplacementClass( class'NicoletteDuClare' );
	JaimeReyesClass		    = LoadScriptedPawnReplacementClass( class'JaimeReyes' );
	GreaselClass		      = LoadScriptedPawnReplacementClass( class'Greasel' );
	GuntherHermannClass	  = LoadScriptedPawnReplacementClass( class'GuntherHermann' );
	MJ12CommandoClass     = LoadScriptedPawnReplacementClass( class'MJ12Commando' );

	// Decorations,
	BlackHelicopterClass  = LoadDecorationReplacementClass( class'BlackHelicopter' );
}

// ----------------------------------------------------------------------------
// RandomizeEvents()
//
// Randomizes what happened at this Mission, so one would not start blank
// with what happened in prior mission.
// ----------------------------------------------------------------------------

static function RandomizeEvents( HXGameInfo Game, HXSteve Steve, int MissionNumber, String MapName )
{
	Super.RandomizeEvents( Game, Steve, MissionNumber, MapName );
}

// ----------------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------------

function FirstFrame()
{
	local Actor Actor;

	Super.FirstFrame();

	//
	// 10_PARIS_METRO
	//
	if ( LocalURL=="10_PARIS_METRO" )
	{
		// Unhide Helicopter and Nicolette.
		if ( GetBoolFlag('NicoletteLeftClub') )
		{
			PawnsEnterWorld( NicoletteDuClareClass );
			DecorationsEnterWorld( BlackHelicopterClass );
		}

		// Unhide Jaime Reyes if you have not recruited him.
		if ( !GetBoolFlag('JaimeRecruited') )
		{
			PawnsEnterWorld( JaimeReyesClass );
		}
	}

	//
	// 10_PARIS_CLUB
	//
	else if ( LocalURL=="10_PARIS_CLUB" )
	{
		if ( GetBoolFlag('NicoletteLeftClub') )
		{
			DestroyActors( NicoletteDuClareClass );
		}
	}

	//
	// 10_PARIS_CHATEAU
	//
	else if ( LocalURL=="10_PARIS_CHATEAU" )
	{
		// Set some flags, so Nicolette plays the right conversations
		// if we start at 10_Paris_Chateau.
		SetBoolFlag( 'ClubComplete',          True, True, 11 );
		SetBoolFlag( 'MeetNicolette_Played',  True, True, 11 );
		SetBoolFlag( 'NicoletteLeftClub',     True, True, 11 );
		SetBoolFlag( 'NicoletteReadyToLeave', True, True, 11 );
	}
}

// ----------------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------------

function PreTravel()
{
	//
	// 10_PARIS_CLUB
	//
	if ( LocalURL=="10_PARIS_CLUB" )
	{
		if ( GetBoolFlag('MeetNicolette_Played') && !GetBoolFlag('NicoletteLeftClub') )
		{
			SetBoolFlag( 'NicoletteLeftClub', True, True, 11 );
		}
	}

	Super.PreTravel();
}

// ----------------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------------

function Timer()
{
	local HXScriptedPawn Hostage;
	local Actor Actor;
	local int NotSafeCount, NotDeadCount;

	Super.Timer();

	//
	// 10_PARIS_CATACOMBS
	//
	if ( LocalURL=="10_PARIS_CATACOMBS" )
	{
		// See if the greasels are dead.
		if ( !GetBoolFlag('SewerGreaselsDead') )
		{
			if ( !PawnsExist(GreaselClass,'SewerGreasel') )
			{
				SetBoolFlag( 'SewerGreaselsDead', True, True, 11 );
			}
		}

		// Check if guards are still alive.
		if ( !GetBoolFlag('defoequestcomplete') )
		{
			if ( !PawnsExist(Class'HXScriptedPawn','mj12metroguards') )
			{
				SetBoolFlag( 'defoequestcomplete', True, True, 11 );
			}
		}
	}

	//
	// 10_PARIS_CATACOMBS_TUNNELS
	//
	else if ( LocalURL=="10_PARIS_CATACOMBS_TUNNELS" )
	{
		if ( !GetBoolFlag('SilhouetteRescueComplete') )
		{
			// Count how many hostages are NOT safe.
			NotSafeCount = 0;
			NotDeadCount = 0;

			foreach AllActors( Class'HXScriptedPawn', Hostage )
			{
				switch ( Hostage.BindName )
				{
					case "hostage":
						notDeadCount++;
						if ( !GetBoolFlag('CataMaleSafe') )
							NotSafeCount++;
						break;
					
					case "hostage_female":
						NotDeadCount++;
						if ( !GetBoolFlag('CataFemaleSafe') )
							NotSafeCount++;
						break;

					default:
						break;
				}
			}

			if ( NotSafeCount==0 || NotDeadCount==0 )
			{
				SetBoolFlag( 'SilhouetteRescueComplete', True, True, 11 );
				CompleteGoal( 'EscortHostages' );

				if ( NotDeadCount==0 )
				{
					SetBoolFlag('SilhouetteHostagesDead', True, True, 11);
				}
				else if ( NotDeadCount<2 )
				{
					SetBoolFlag( 'SilhouetteHostagesSomeRescued', True, True, 11 );
				}
				else
				{
					SetBoolFlag( 'SilhouetteHostagesAllRescued', True, True, 11 );
				}
			}
		}
	}

	//
	// 10_PARIS_METRO
	//
	else if ( LocalURL=="10_PARIS_METRO" )
	{
		// Unhide GuntherHermann.
		if ( !GetBoolFlag('MS_GuntherUnhidden') && GetBoolFlag('JockReady_Played') )
		{
			PawnsEnterWorld( GuntherHermannClass );
			SetBoolFlag( 'MS_GuntherUnhidden', True, True, 11 );
		}

		// Bark something.
		if ( GetBoolFlag('AlleyCopSeesPlayer_Played') && !GetBoolFlag('MS_CopBarked') )
		{
			foreach AllActors( Class'Actor', Actor, 'AlleyCopAttacks' )
				Actor.Trigger( Self, None );

			SetBoolFlag( 'MS_CopBarked', True, True, 11 );
		}
	}

	//
	// 10_PARIS_CHATEAU
	//
	else if ( LocalURL=="10_PARIS_CHATEAU" )
	{
		// Unhide MJ12Commandos when an infolink is played.
		if ( GetBoolFlag('MS_CommandosUnhidden') && GetBoolFlag('everettsignal') )
		{
			PawnsEnterWorld( MJ12CommandoClass );
			SetBoolFlag( 'MS_CommandosUnhidden', True, True, 11 );
		}
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	PrevMissionScript=Class'HX.HXMission09'
	NextMissionScript=Class'HX.HXMission11'
}
