//=============================================================================
// HXMission11.
//=============================================================================
class HXMission11 expands HXMissionScript;

var Class<HXScriptedPawn> AlexJacobsonClass, GuntherHermannClass, TobyAtanweClass, WaltonSimonsClass;
var Class<HXDecoration>   BlackHelicopterClass;

// ----------------------------------------------------------------------------
// LoadClasses()
// ----------------------------------------------------------------------------

function LoadClasses()
{
	Super.LoadClasses();

	// ScriptedPawns.
	AlexJacobsonClass    = LoadScriptedPawnReplacementClass( class'AlexJacobson' );
	GuntherHermannClass	 = LoadScriptedPawnReplacementClass( class'GuntherHermann' );
	TobyAtanweClass	     = LoadScriptedPawnReplacementClass( class'TobyAtanwe' );
	WaltonSimonsClass	   = LoadScriptedPawnReplacementClass( class'WaltonSimons' );

	// Decorations,
	BlackHelicopterClass = LoadDecorationReplacementClass( class'BlackHelicopter' );
}

// ----------------------------------------------------------------------------
// RandomizeEvents()
//
// Randomizes what happened at this Mission, so one would not start blank
// with what happened in prior mission.
// ----------------------------------------------------------------------------

static function RandomizeEvents( HXGameInfo Game, HXSteve Steve, int MissionNumber, String MapName )
{
	Super.RandomizeEvents( Game, Steve, MissionNumber, MapName );
}

// ----------------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------------

function FirstFrame()
{
	Super.FirstFrame();

	//
	// 11_PARIS_EVERETT
	//
	if ( LocalURL=="11_PARIS_EVERETT" )
	{
		// Make sure toby doesn't ask us at everetts to get us there.
		if ( !GetBoolFlag('MeetTobyAtanwe_Played') )
		{
			SetBoolFlag( 'MeetTobyAtanwe_Played', True, True, 12 );
		}
	}
}

// ----------------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------------

function PreTravel()
{
	Super.PreTravel();
}

// ----------------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------------

function Timer()
{
	local HXScriptedPawn Gunther;
	local Actor Actor;

	Super.Timer();

	//
	// 11_PARIS_UNDERGROUND
	//
	if ( LocalURL=="11_PARIS_UNDERGROUND" )
	{
		// Unhide Toby Atanwe.
		if ( GetBoolFlag('templar_upload') && !GetBoolFlag('MS_TobyUnhidden') )
		{
			PawnsEnterWorld( TobyAtanweClass );

			SetBoolFlag( 'MS_TobyUnhidden', True, True, 12 );
		}

		// Knock out the player and teleport him after this convo.
		if ( GetBoolFlag('MeetTobyAtanwe_Played') && !GetBoolFlag('MS_PlayerTeleported') )
		{
			SetBoolFlag( 'MS_PlayerTeleported', True, True, 12 );

			// Travel to Everett.
			Log( "Traveling via MissionScript to 11_PARIS_EVERETT#", 'DevMisionScript' );
			Level.ServerTravel( "11_PARIS_EVERETT#", True );
		}
	}

	//
	// 11_PARIS_EVERETT
	//
	else if ( LocalURL=="11_PARIS_EVERETT" )
	{
		// Unhide the helicopter.
		if ( GetBoolFlag('MeetEverett_Played') && !GetBoolFlag('MS_ChopperUnhidden') )
		{
			DecorationsEnterWorld( BlackHelicopterClass );
			SetBoolFlag('MS_ChopperUnhidden', True, True, 12);
		}

		// Unhide Alex Jacobson.
		if ( GetBoolFlag('AtanweAtEveretts_Played') && !GetBoolFlag('MS_AlexUnhidden') )
		{
			PawnsEnterWorld( AlexJacobsonClass );
			SetBoolFlag('MS_AlexUnhidden', True, True, 12);
		}

		// Set a flag fater Ray has been killed.
		if ( GetBoolFlag('Ray_Dead') && !GetBoolFlag('MS_RayDead') )
		{
			CompleteGoal( 'KillMechanic' );
			SetBoolFlag( 'MS_RayDead', True, True, 12 );
		}
	}
	
	//
	// 11_PARIS_CATHEDRAL
	//
	else if ( LocalURL=="11_PARIS_CATHEDRAL" )
	{
		// Kill Gunther after a convo.
		if ( GetBoolFlag('M11MeetGunther_Played') && GetBoolFlag('KillGunther') && !GetBoolFlag('MS_GuntherKilled') )
		{
			if ( GuntherHermannClass!=None )
			{
				foreach AllActors( GuntherHermannClass, Actor )
				{
					Gunther = HXScriptedPawn(Actor);
					Gunther.bInvincible = False;
					Gunther.HealthTorso = 0;
					Gunther.Health      = 0;
					Gunther.GotoState( 'KillswitchActivated' );

					SetBoolFlag( 'GuntherHermann_Dead', True, True, 0 );
					SetBoolFlag( 'MS_GuntherKilled', True, True, 12 );
				}
			}
		}

		// Unhide Walton Simons.
		if ( GetBoolFlag('templar_upload') && GetBoolFlag('M11NearWalt') && !GetBoolFlag('MS_M11WaltAppeared') )
		{
			PawnsEnterWorld( WaltonSimonsClass );
			SetBoolFlag( 'MS_M11WaltAppeared', True, True, 12 );
		}

		// Hide Walton Simons.
		if ( GetBoolFlag('M11WaltonHolo_Played') && !GetBoolFlag('MS_M11WaltRemoved') )
		{
			PawnsLeaveWorld( WaltonSimonsClass );
			SetBoolFlag( 'MS_M11WaltRemoved', True, True, 12 );
		}
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	PrevMissionScript=Class'HX.HXMission10'
	NextMissionScript=Class'HX.HXMission12'
}
