//=============================================================================
// HXMission12.
//=============================================================================
class HXMission12 expands HXMissionScript;

var Class<HXScriptedPawn> SandraRentonClass, TracerTongClass, MJ12TroopClass, BobPageClass,
                          JockClass;
var Class<HXDecoration>   BlackHelicopterClass, EarthClass;

// ----------------------------------------------------------------------------
// LoadClasses()
// ----------------------------------------------------------------------------

function LoadClasses()
{
	Super.LoadClasses();

	// ScriptedPawns.
	SandraRentonClass    = LoadScriptedPawnReplacementClass( class'SandraRenton' );
	TracerTongClass      = LoadScriptedPawnReplacementClass( class'TracerTong' );
	MJ12TroopClass	     = LoadScriptedPawnReplacementClass( class'MJ12Troop' );
	BobPageClass			   = LoadScriptedPawnReplacementClass( class'BobPage' );
	JockClass			       = LoadScriptedPawnReplacementClass( class'Jock' );

	// Decorations,
	BlackHelicopterClass = LoadDecorationReplacementClass( class'BlackHelicopter' );
	EarthClass           = LoadDecorationReplacementClass( class'Earth' );
}

// ----------------------------------------------------------------------------
// RandomizeEvents()
//
// Randomizes what happened at this Mission, so one would not start blank
// with what happened in prior mission.
// ----------------------------------------------------------------------------

static function RandomizeEvents( HXGameInfo Game, HXSteve Steve, int MissionNumber, String MapName )
{
	Super.RandomizeEvents( Game, Steve, MissionNumber, MapName );
}

// ----------------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------------

function FirstFrame()
{
	Super.FirstFrame();

	// !! Leaving map testing.
	//SetBoolFlag( 'GaryHostageBriefing_Played', True, True, 14 );

	//
	// 12_VANDENBERG_CMD
	//
	if ( LocalURL=="12_VANDENBERG_CMD" )
	{
		// Unhide the black helicopter, Jock, and TracerTong.
		if ( GetBoolFlag('GaryHostageBriefing_Played') )
		{
			DecorationsEnterWorld( BlackHelicopterClass );
			PawnsEnterWorld( JockClass );
			PawnsEnterWorld( TracerTongClass );
		}
	}

	//
	// 12_VANDENBERG_GAS
	//
	else if ( LocalURL=="12_VANDENBERG_GAS" )
	{
		SetBoolFlag( 'RescueBegan', True, True, 14 );

		// Unhide Sandra if she went to California.
		if ( GetBoolFlag('SandraWentToCalifornia') )
		{
			PawnsEnterWorld( SandraRentonClass );
		}
	}
}

// ----------------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------------

function PreTravel()
{
	Super.PreTravel();
}

// ----------------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------------

function Timer()
{
	local HXScriptedPawn ScriptedPawn;
	local HXMover Mover;
	local Actor Actor;
	local int Count;

	Super.Timer();

	//
	// 12_VANDENBERG_CMD
	//
	if ( LocalURL=="12_VANDENBERG_CMD" )
	{
		// Play datalinks when robots are destroyed or disabled.
		if ( !GetBoolFlag('MS_DL_Played') )
		{
			Count = 0;
			foreach AllActors( Class'HXScriptedPawn', ScriptedPawn, 'enemy_bot' )
			{
				if ( ScriptedPawn.bIsRobot && ScriptedPawn.EMPHitPoints>0 )
					Count++;

				// Break if we found more then 3 Bots alreadys.
				if ( Count>3 )
					break;
			}

			switch ( Count )
			{
				case 3:
					StartDataLinkTransmission( "DL_bots_left_3" );
					break;

				case 2:
					StartDataLinkTransmission( "DL_bots_left_2" );
					break;

				case 1:
					StartDataLinkTransmission( "DL_bots_left_1" );
					break;

				case 0:
					StartDataLinkTransmission( "DL_command_bots_destroyed" );
					SetBoolFlag( 'MS_DL_Played', True, True, 14 );
					break;

				default:
					break;
			}
		}

		// Rescue the scientist when the guards are dead.
		if ( !GetBoolFlag('CapturedScientistRescued') )
		{
			Count = 0;
			if ( MJ12TroopClass!=None )
			{
				foreach AllActors( MJ12TroopClass, Actor )
				{
					switch ( Actor.Tag )
					{
						case 'MJ12_hazlab_troop1':
						case 'MJ12_hazlab_troop2':
							Count++;
							break;
					}

					// Break if we found more then one alreadys.
					if ( Count>0 )
						break;
				}
			}

			if ( Count==0 )
			{
				SetBoolFlag( 'CapturedScientistRescued', True, True, 14 );
			}
		}
	}
	
	//
	// 12_VANDENBERG_GAS
	//
	else if ( LocalURL=="12_VANDENBERG_GAS" )
	{
		// Unhide the black helicopter and destroy the doors.
		if ( !GetBoolFlag('MS_ChopperGasUnhidden') && (GetBoolFlag('MeetTiffanySavage_Played') || GetBoolFlag('TiffanySavage_Dead')) )
		{
			DecorationsEnterWorld( BlackHelicopterClass );

			// Blow up the doors.
			BlowUpMovers( Class'HXMover', 'junkyard_doors' );

			SetBoolFlag( 'TiffanyRescued',        True, True, 14 );
			SetBoolFlag( 'MS_ChopperGasUnhidden', True, True, 14 );
		}

		if ( !GetBoolFlag('MS_TiffanyDLPlayed') && GetBoolFlag('TiffanySavage_Dead') )
		{
			StartDataLinkTransmission( "DL_JockTiffanyDead" );
			SetBoolFlag( 'MS_TiffanyDLPlayed', True, True, 14 );
		}
	}

	//
	// 12_VANDENBERG_COMPUTER
	//
	else if (localURL == "12_VANDENBERG_COMPUTER")
	{
		// Hide the earth and unhide Bob Page.
		if ( !GetBoolFlag('MS_M12PageAppeared') && GetBoolFlag('M12PageAppears') )
		{
			HideActors( EarthClass );
			PawnsEnterWorld( BobPageClass );

			SetBoolFlag( 'MS_M12PageAppeared', True, True, 14 );
		}

		// Unhide the earth and hide Bob Page.
		if ( GetBoolFlag('MS_M12PageAppeared') && !GetBoolFlag('MS_BobPageHidden') && GetBoolFlag('PageHostageBriefing_Played') )
		{
			UnhideActors( EarthClass );
			PawnsLeaveWorld( BobPageClass );

			SetBoolFlag('MS_BobPageHidden', True, True, 14);
		}
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	PrevMissionScript=Class'HX.HXMission11'
	NextMissionScript=Class'HX.HXMission14'
}
