//=============================================================================
// Mission14.
//=============================================================================
class HXMission14 expands HXMissionScript;

var Class<HXScriptedPawn> HowardStrongClass, ScubaDiverClass, GarySavageClass, BobPageClass,
                          WaltonSimonsClass;
var Class<HXDecoration>   BlackHelicopterClass, Keypad3Class, MiniSubClass;

// ----------------------------------------------------------------------------
// LoadClasses()
// ----------------------------------------------------------------------------

function LoadClasses()
{
	Super.LoadClasses();

	// ScriptedPawns.
	HowardStrongClass    = LoadScriptedPawnReplacementClass( class'HowardStrong' );
	ScubaDiverClass      = LoadScriptedPawnReplacementClass( class'ScubaDiver' );
	GarySavageClass      = LoadScriptedPawnReplacementClass( class'GarySavage' );
	BobPageClass         = LoadScriptedPawnReplacementClass( class'BobPage' );
	WaltonSimonsClass    = LoadScriptedPawnReplacementClass( class'WaltonSimons' );

	// Decorations,
	BlackHelicopterClass = LoadDecorationReplacementClass( class'BlackHelicopter' );
	Keypad3Class         = LoadDecorationReplacementClass( class'Keypad3' );
	MiniSubClass         = LoadDecorationReplacementClass( class'MiniSub' );
}

// ----------------------------------------------------------------------------
// RandomizeEvents()
//
// Randomizes what happened at this Mission, so one would not start blank
// with what happened in prior mission.
// ----------------------------------------------------------------------------

static function RandomizeEvents( HXGameInfo Game, HXSteve Steve, int MissionNumber, String MapName )
{
	Super.RandomizeEvents( Game, Steve, MissionNumber, MapName );
}

// ----------------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------------

function FirstFrame()
{
	Super.FirstFrame();

	//
	// 14_OCEANLAB_LAB
	//
	if ( LocalURL=="14_OCEANLAB_LAB" )
	{
		CompleteGoal( 'StealSub' );
	}
}

// ----------------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------------

function PreTravel()
{
	Super.PreTravel();
}

// ----------------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------------

function Timer()
{
	local Actor Actor;

	Super.Timer();

	//
	// 14_VANDENBERG_SUB
	//
	if ( LocalURL=="14_VANDENBERG_SUB" )
	{
		// When the mission is complete, unhide the chopper and Gary Savage and destroy the minisub and the welding parts.
		if ( !GetBoolFlag('MS_DestroySub') && GetBoolFlag('DL_downloaded_Played') )
		{
			DestroyActors( MiniSubClass, 'MiniSub2' );
			DestroyActors( Class'Actor', 'welding_stuff' );
			
			DecorationsEnterWorld( BlackHelicopterClass, 'BlackHelicopter' );
			PawnsEnterWorld( GarySavageClass );

			SetBoolFlag( 'MS_DestroySub', true, true, 15 );
		}
	}

	//
	// 14_OCEANLAB_LAB
	//
	else if ( LocalURL=="14_OCEANLAB_LAB" )
	{
		// When the mission is complete, unhide the minisub and the diver team.
		if ( !GetBoolFlag('MS_UnhideSub') && GetBoolFlag('DL_downloaded_Played') )
		{
			DecorationsEnterWorld( MiniSubClass, 'MiniSub2' );
			PawnsEnterWorld( WaltonSimonsClass );
			PawnsEnterWorld( ScubaDiverClass, 'scubateam' );

			SetBoolFlag( 'MS_UnhideSub', true, true, 15 );
		}
	}

	//
	// 14_OCEANLAB_SILO
	//
	else if ( LocalURL=="14_OCEANLAB_SILO" )
	{
		// After trap fired, hack outer Keypad to missile silo, to allow players to reenter.
		if ( !GetBoolFlag('MS_SiloKeypadHacked') && GetBoolFlag('M14_SiloDoorClosed') )
		{
			// Find KeyPad.
			if ( Keypad3Class!=None )
			{
				foreach AllActors( Keypad3Class, Actor )
				{
					// The inner Keypad is hackable, while the outer is not.
					if ( Actor.Event=='dooropen' && !bool(Actor.GetPropertyText("bHackable")) )
					{
						Actor.SetPropertyText( "bHackable",    String(true) );
						Actor.SetPropertyText( "HackStrength", String(0.0)  );
						break;
					}
				}
			}

			SetBoolFlag( 'MS_SiloKeypadHacked', true, true, 15 );
		}

		// When HowardStrong is dead, unhide the helicopter.
		if ( !GetBoolFlag('MS_UnhideHelicopter') )
		{
			if ( !PawnsExist(HowardStrongClass) )
			{
				DecorationsEnterWorld( BlackHelicopterClass, 'BlackHelicopter' );
				StartDataLinkTransmission( "DL_Dead" );

				SetBoolFlag( 'MS_UnhideHelicopter', true, true, 15 );
			}
		}
	}

	//
	// 14_OCEANLAB_UC
	//
	else if ( LocalURL=="14_OCEANLAB_UC" )
	{
		// When a flag is set, unhide Bob Page.
		if ( !GetBoolFlag('MS_UnhideBobPage') && GetBoolFlag('schematic_downloaded') )
		{
			PawnsEnterWorld( BobPageClass );
			SetBoolFlag( 'MS_UnhideBobPage', true, true, 15 );
		}

		// When a flag is set, hide Bob Page.
		if ( !GetBoolFlag('MS_HideBobPage') && GetBoolFlag('PageTaunt_Played') )
		{
			PawnsLeaveWorld( BobPageClass );
			SetBoolFlag( 'MS_HideBobPage', true, true, 15 );
		}
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	PrevMissionScript=Class'HX.HXMission12'
	NextMissionScript=Class'HX.HXMission15'
}
