//=============================================================================
// HXMissionEndgame.
//=============================================================================
class HXMissionEndgame extends HXMissionScript;

//var byte SavedSoundVolume;
var float EndgameDelays[3];
var float EndgameTimer;
var localized string EndgameQuote[6];
//var HUDMissionStartTextDisplay QuoteDisplay;
var bool bQuotePrinted;

// ----------------------------------------------------------------------------
// GiveInitialInventory()
// ----------------------------------------------------------------------------

function GiveInitialInventory( HXPlayerPawn Player, String Portal, String MapURL )
{
}

// ----------------------------------------------------------------------------
// StartCinematic()
// ----------------------------------------------------------------------------

function StartCinematic()
{
	//local HXDummyCameraPoint CameraPoint, CameraPointZero;
	local int RetVal;

	EndgameTimer = 0.0;

	//if (Player != None)
	//{
		// Make sure all the flags are deleted.
		//HXRootWindow(Player.rootWindow).ResetFlags();

	switch ( LocalUrl )
	{
		case "Endgame1":
			RetVal = int(HXGameInfo(Level.Game).StartCinematicByName( 'Endgame1', Level.Game ));
			break;

		case "Endgame2":
			RetVal = int(HXGameInfo(Level.Game).StartCinematicByName( 'Endgame2', Level.Game ));
			break;

		case "Endgame3":
			RetVal = int(HXGameInfo(Level.Game).StartCinematicByName( 'Endgame3', Level.Game ));
			break;

		default:
			RetVal = 4;
			break;
	}

	Log( Self $ ": RetVal =" @ RetVal, 'DevMissionScript' );

	// turn down the sound so we can hear the speech
	//savedSoundVolume = SoundVolume;
	//SoundVolume = 32;
	//Player.SetInstantSoundVolume(SoundVolume);
}

// ----------------------------------------------------------------------------
// InitStateMachine()
// ----------------------------------------------------------------------------

function InitStateMachine()
{
	Super.InitStateMachine();

	// Destroy all flags!
	//if (flags != None)
		//flags.DeleteAllFlags();

	// Set the PlayerTraveling flag (always want it set for 
	// the intro and Endgames)
	//SetBoolFlag('PlayerTraveling', True, True, 0);
}

// ----------------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------------

function FirstFrame()
{
	Super.FirstFrame();

	//EndgameTimer = 0.0;

	//if (Player != None)
	//{
		// Make sure all the flags are deleted.
		//HXRootWindow(Player.rootWindow).ResetFlags();

		// Start the conversation
		//if (localURL == "Endgame1")
			//HXGameInfo(Level.Game).StartConversationByName( None, 'Endgame1', Player, False, True);
		//else if (localURL == "Endgame2")
			//HXGameInfo(Level.Game).StartConversationByName( None, 'Endgame2', Player, False, True);
		//else if (localURL == "Endgame3")
			//HXGameInfo(Level.Game).StartConversationByName( None, 'Endgame3', Player, False, True);

		// turn down the sound so we can hear the speech
		//savedSoundVolume = SoundVolume;
		//SoundVolume = 32;
		//Player.SetInstantSoundVolume(SoundVolume);
	//}
}

// ----------------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------------

function PreTravel()
{
	// restore the sound volume
	//SoundVolume = savedSoundVolume;
	//Player.SetInstantSoundVolume(SoundVolume);

	Super.PreTravel();
}

// ----------------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------------

function Timer()
{
	Super.Timer();

	if ( GetBoolFlag('EndgameExplosions') )
	{
		ExplosionEffects();
	}

	// After the conversation finishes playing, print a quote, delay a
	// bit, then scroll the credits and then return to the DXOnly map
	if ( GetBoolFlag('Endgame1_Played') )
	{
		if (!bQuotePrinted)
			PrintEndgameQuote( 0 );

		EndgameTimer += checkTime;

		if ( EndgameTimer>EndgameDelays[0] )
			FinishCinematic();
	}
	else if ( GetBoolFlag('Endgame2_Played') )
	{
		if ( !bQuotePrinted )
			PrintEndgameQuote( 1 );

		EndgameTimer += checkTime;

		if ( EndgameTimer>EndgameDelays[1] )
			FinishCinematic();
	}
	else if ( GetBoolFlag('Endgame3_Played') )
	{
		if ( !bQuotePrinted )
			PrintEndgameQuote( 2 );

		EndgameTimer += checkTime;

		if ( EndgameTimer>EndgameDelays[2] )
			FinishCinematic();
	}
}

// ----------------------------------------------------------------------------
// FinishCinematic()
// ----------------------------------------------------------------------------

function FinishCinematic()
{
	//local CameraPoint cPoint;

	//if (quoteDisplay != None)
	//{
		//quoteDisplay.Destroy();
		//quoteDisplay = None;
	//}

	// Loop through all the CameraPoints and set the "nextPoint"
	// to None will will effectively cause them to halt.
	// This prevents the screen from fading while the credits are rolling.

	//foreach player.AllActors(class'CameraPoint', cPoint)
		//cPoint.NextPoint = None;

	SetBoolFlag( 'EndgameExplosions', False, True, 1 );
	SetTimer( 0, False );
	//Player.ShowCredits(True);

	// Switch to training map.
	//Level.ServerTravel( "00_Training#", False );

	// Switch to intro map.
	Level.ServerTravel( "00_Intro#", False );
}

// ----------------------------------------------------------------------------
// PrintEndgameQuote()
// ----------------------------------------------------------------------------

function PrintEndgameQuote(int num)
{
	local int i;
	local HXRootWindow root;

	bQuotePrinted = True;
	SetBoolFlag( 'EndgameExplosions', False, True, 1 );

	// TODO!

	/*root = HXRootWindow(Player.rootWindow);
	if (root != None)
	{
		quoteDisplay = HUDMissionStartTextDisplay(root.NewChild(Class'HUDMissionStartTextDisplay', True));
		if (quoteDisplay != None)
		{
			quoteDisplay.displayTime = EndgameDelays[num];
			quoteDisplay.SetWindowAlignments(HALIGN_Center, VALIGN_Center);

			for (i=0; i<2; i++)
				quoteDisplay.AddMessage(EndgameQuote[2*num+i]);

			quoteDisplay.StartMessage();
		}
	}*/
}

// ----------------------------------------------------------------------------
// ExplosionEffects()
// ----------------------------------------------------------------------------

function ExplosionEffects()
{
	local float size;
	local int i;
	local Vector loc, endloc, HitLocation, HitNormal;
	local Actor HitActor;
	local MetalFragment frag;

	if (FRand() < 0.8)
	{
		// pick a random explosion size and modify everything accordingly
		size = FRand();

		// play a sound
		if (size < 0.5)
			Player.PlaySound(Sound'LargeExplosion1', SLOT_None, 2.0,, 16384);
		else
			Player.PlaySound(Sound'LargeExplosion2', SLOT_None, 2.0,, 16384);

		// have random metal fragments fall from the ceiling
		if (FRand() < 0.8)
		{
			for (i=0; i<Int(size*10.0); i++)
			{
				loc = Player.Location + 512.0 * VRand();
				loc.Z = Player.Location.Z;
				endloc = loc;
				endloc.Z += 1024.0;
				HitActor = Trace(HitLocation, HitNormal, endloc, loc, False);
				if (HitActor == None)
					HitLocation = endloc;

				// spawn some explosion effects
				if (size < 0.5)
					Spawn(class'ExplosionMedium',,, HitLocation+8*HitNormal);
				else
					Spawn(class'ExplosionLarge',,, HitLocation+8*HitNormal);

				if (FRand() < 0.5)
				{
					frag = Spawn(class'MetalFragment',,, HitLocation);
					if (frag != None)
					{
						frag.CalcVelocity(vect(20000,0,0),256);
						frag.DrawScale = 0.5 + 2.0 * FRand();
						if (FRand() < 0.75)
							frag.bSmoking = True;
					}
				}
			}
		}
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	EndgameDelays(0)=13.000000
	EndgameDelays(1)=13.500000
	EndgameDelays(2)=10.500000
	EndgameQuote(0)="YESTERDAY WE OBEYED KINGS AND BENT OUR NECKS BEFORE EMPERORS.  BUT TODAY WE KNEEL ONLY TO TRUTH..."
	EndgameQuote(1)="    -- KAHLIL GIBRAN"
	EndgameQuote(2)="IF THERE WERE NO GOD, IT WOULD BE NECESSARY TO INVENT HIM."
	EndgameQuote(3)="    -- VOLTAIRE"
	EndgameQuote(4)="BETTER TO REIGN IN HELL, THAN SERVE IN HEAVEN."
	EndgameQuote(5)="    -- PARADISE LOST, JOHN MILTON"
	bCinematicMap=True
}
