//=============================================================================
// HXMissionIntro.
//=============================================================================
class HXMissionIntro extends HXMissionScript;

var Class<HXScriptedPawn> BobPageClass;

//var byte SavedSoundVolume;

// ------------------------------------------------------------------------
// LoadClasses()
// ------------------------------------------------------------------------

function LoadClasses()
{
	Super.LoadClasses();

	// ScriptedPawns.
	BobPageClass = LoadScriptedPawnReplacementClass( class'BobPage' );
}

// ------------------------------------------------------------------------
// GiveInitialInventory()
// ------------------------------------------------------------------------

function GiveInitialInventory( HXPlayerPawn Player, String Portal, String MapURL )
{
}

// ----------------------------------------------------------------------
// StartCinematic()
// ----------------------------------------------------------------------

function StartCinematic()
{
	local Actor Actor;

	// Make sure all the flags are deleted.
	//HXRootWindow(Player.rootWindow).ResetFlags();

	// Find our buddy Bob, because he has the conversation!
	if ( BobPageClass!=None )
		foreach AllActors( BobPageClass, Actor )
			break;

	// Start the conversation.
	if ( Actor!=None)
	{
		if ( !Game.StartCinematicByName( 'Intro', Actor ) )
			Log( Self $ "Failed to start Intro cinematic.", 'DevMissionScript' );
	}
	else
	{
		Log( Self $ "Failed to find Page.", 'DevMissionScript' );
	}

	// turn down the sound so we can hear the speech
	//savedSoundVolume = SoundVolume;
	//SoundVolume = 32;
	//Player.SetInstantSoundVolume(SoundVolume);
}


// ----------------------------------------------------------------------
// InitStateMachine()
// ----------------------------------------------------------------------

function InitStateMachine()
{
	Super.InitStateMachine();

	// Destroy all flags!
	//if (flags != None)
		//flags.DeleteAllFlags();

	// Set the PlayerTraveling flag (always want it set for 
	// the intro and endgames)
	//SetBoolFlag('PlayerTraveling', True, True, 0);
}

// ----------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------

function FirstFrame()
{
	//local HXBobPage bob;

	Super.FirstFrame();

	//if (player != None)
	//{
		// Make sure all the flags are deleted.
		//HXRootWindow(Player.rootWindow).ResetFlags();

		// Find our buddy Bob, because he has the conversation!
		//foreach AllActors(class'HXBobPage', bob)
			//break;

		//if (bob != None)
		//{
			// Start the conversation
			//HXGameInfo(Level.Game).StartConversationByName( None, 'Intro', bob, False, True);
		//}

		// turn down the sound so we can hear the speech
		//savedSoundVolume = SoundVolume;
		//SoundVolume = 32;
		//Player.SetInstantSoundVolume(SoundVolume);
	//}
}

// ----------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------

function PreTravel()
{
	// restore the sound volume
	//SoundVolume = savedSoundVolume;
	//Player.SetInstantSoundVolume(SoundVolume);

	Super.PreTravel();
}

// ----------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------

function Timer()
{
	Super.Timer();

	// After the Intro conversation is over, tell the player to go on
	// to the next map (which will either be the main menu map or 
	// the first game mission if we're starting a new game.
	if ( GetBoolFlag('Intro_Played') )
	{
		SetBoolFlag( 'Intro_Played', False, True, 1 );

		//Log( "Travel via MissionScript to 01_NYC_UNATCOISLAND#", 'DevMissionScript' );
		//Level.ServerTravel( "01_NYC_UNATCOISLAND#", False );

		Log( "ServerTravel via MissionScript to 00_Training#", 'DevMissionScript' );
		Level.ServerTravel( "00_Training#", False );
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	bCinematicMap=True
}
