//=============================================================================
// HXMissionScript.
//=============================================================================
class HXMissionScript extends MissionScript
	abstract;

var transient HXGameInfo Game;
var transient HXSteve Steve;

var HXCameraPointDummy Dummy;

var Class<HXMissionScript> PrevMissionScript, NextMissionScript;

var bool bCinematicMap;
var bool bFiredCinematic;

var Class<Inventory> WeaponPistolClass, WeaponProdClass, MedKitClass;

// ----------------------------------------------------------------------------
// Spawned()
// ----------------------------------------------------------------------------

event Spawned()
{
	// Link to GameInfo.
	Game = HXGameInfo(Level.Game);
	if ( Game!=None )
		Game.MissionScript = Self;

	// Load dynamic loaded classes used in scripts.
	LoadClasses();
}

// ----------------------------------------------------------------------------
// LoadClasses()
// ----------------------------------------------------------------------------

function LoadClasses()
{
	// Inventory.
	WeaponPistolClass = LoadInventoryReplacementClass( class'WeaponPistol' );
	WeaponProdClass   = LoadInventoryReplacementClass( class'WeaponProd' );
	MedKitClass       = LoadInventoryReplacementClass( class'MedKit' );
}

// ----------------------------------------------------------------------------
// Load*ReplacementClass()
//
// Helper for LoadClasses() to wrap around ModifyInventoryClass and 
// ModifyActorClass interface.
// ----------------------------------------------------------------------------

function class<Inventory> LoadInventoryReplacementClass( class<Inventory> InClass )
{
	Game.ModifyInventoryClass( InClass );
	return InClass;
}
function class<Actor> LoadActorReplacementClass( class<Actor> InClass )
{
	Game.ModifyActorClass( InClass );
	return InClass;
}
function class<HXScriptedPawn> LoadScriptedPawnReplacementClass( class<ScriptedPawn> InClass )
{
	local class<Actor> ActorClass;
	ActorClass = InClass;
	Game.ModifyActorClass( ActorClass );
	return class<HXScriptedPawn>(ActorClass);
}
function class<HXDecoration> LoadDecorationReplacementClass( class<DeusExDecoration> InClass )
{
	local class<Actor> ActorClass;
	ActorClass = InClass;
	Game.ModifyActorClass( ActorClass );
	return class<HXDecoration>(ActorClass);
}
function class<HXCarcass> LoadCarcassReplacementClass( class<DeusExCarcass> InClass )
{
	local class<Actor> ActorClass;
	ActorClass = InClass;
	Game.ModifyActorClass( ActorClass );
	return class<HXCarcass>(ActorClass);
}

// ----------------------------------------------------------------------------
// PostPostBeginPlay()
//
// Set the timer
// ----------------------------------------------------------------------------

function PostPostBeginPlay()
{
	// start the script
	SetTimer(checkTime, True);
}

// ----------------------------------------------------------------------------
// NotifyPlayerUp()
// ----------------------------------------------------------------------------

function NotifyPlayerUp( HXPlayerPawn PlayerPawn )
{
	local int SequenceNum;
	local float TimeOffset;

	if ( bCinematicMap )
	{
		if ( !bFiredCinematic )
		{
			StartCinematic();
			StartCinematicCamera( PlayerPawn );

			bFiredCinematic = True;

			PlayerPawn.ClientStartCinematicCamera( 0.0, PlayerPawn.Location, PlayerPawn.ViewRotation );
		}
		else
		{
			Log( "Level.TimeSeconds - Dummy.StartTimeSeconds = " $ (Level.TimeSeconds - Dummy.StartTimeSeconds), 'DevMissionScript' );
			Log( "Dummy.TickedSeconds = " $ Dummy.TickedSeconds, 'DevMissionScript' );

			PlayerPawn.ClientStartCinematicCamera( Dummy.TickedSeconds, Dummy.StartLocation, Dummy.StartViewRotation );
		}
	}
}

// ----------------------------------------------------------------------------
// StartCinematic()
// ----------------------------------------------------------------------------

function StartCinematic()
{
}

// ----------------------------------------------------------------------------
// StartCinematicCamera()
// ----------------------------------------------------------------------------

function StartCinematicCamera( HXPlayerPawn P )
{
	local HXDummyCameraPoint CameraPoint, CameraPointZero;

	Dummy = Spawn( class'HXCameraPointDummy',,, P.Location, P.Rotation );

	// Moved to HXCameraPointDummy.Spawned()
	//Dummy.StartTimeSeconds	= Level.TimeSeconds;
	//Dummy.StartLocation			= P.Location;
	//Dummy.StartViewRotation = P.ViewRotation;

	// Make dummy available to all camera points and find first
	foreach AllActors( class'HXDummyCameraPoint', CameraPoint )
	{
		CameraPoint.Dummy = Dummy;

		if ( CameraPoint.sequenceNum==0 )
			CameraPointZero = CameraPoint;
	}

	// start stuff
	CameraPointZero.GotoState( 'Idle' );
}

// ----------------------------------------------------------------------------
// PreventDeath()
// Used by training mission and mission 04 after hunt begins.
// ----------------------------------------------------------------------------

function PreventDeath( Pawn Pawn )
{
}

// ----------------------------------------------------------------------------
// InitStateMachine()
//
// Get the player's flag base, get the map name, and set the player
// ----------------------------------------------------------------------------

function InitStateMachine()
{
	//local HXPickupDistributor dist;
	local DeusExLevelInfo info;

	// put it here so it's run before any of these mission script stuff
	//foreach AllActors(class'HXPickupDistributor', dist)
		//dist.DistributeKeys();

	//Player = DeusExPlayer(GetPlayerPawn());

	foreach AllActors(class'DeusExLevelInfo', info)
		DXInfo = info;

	//if (Player != None)
	//{
		//flags = Player.FlagBase;

	foreach AllActors(class'HXSteve', Steve)
		break;

		//flags = Steve.FlagBase;

		// Get the mission number by extracting it from the
		// DeusExLevelInfo and then delete any expired flags.
		//
		// Also set the default mission expiration so flags
		// expire in the next mission unless explicitly set
		// differently when the flag is created.

		if ( Steve != None )
		//if (flags != None)
		{
			// Don't delete expired flags if we just loaded
			// a savegame
			//if (Steve.flagbase.GetBool('PlayerTraveling'))

			// Now handled in InitGame()
			//Steve.Flagbase.DeleteExpiredFlags(DXInfo.MissionNumber);
			//Steve.Flagbase.SetDefaultExpiration(DXInfo.MissionNumber + 1);

			localURL = Caps(DXInfo.mapName);

			Log( "**** InitStateMachine() -"@ Steve @"started mission state machine for"@localURL, 'DevMissionScript' );
		}
		else
		{
			Log( "**** InitStateMachine() - FlagBase not set - mission state machine NOT initialized!", 'DevMissionScript' );
		}
	//}
	//else
	//{
		//Log("**** InitStateMachine() - player not set - mission state machine NOT initialized!", 'DevMissionScript' );
	//}
}

// ----------------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------------

function FirstFrame()
{
	local name FlagName;
	local HXScriptedPawn P;
	local int i;

	Log( Self $ ".FirstFrame()", 'DevMissionScript' );

	// Tag cannot be set by spawn right now, as it's spawned inside DeusExLevelInfo.
	// Tag is used to easy triggering of MissionScripts.
	Tag = 'MissionScript';

	//DeleteBoolFlag('PlayerTraveling');

	// Check to see which NPCs should be dead from prevous missions
	foreach AllActors( class'HXScriptedPawn', P )
	{
		if (P.bImportant)
		{
			FlagName = StringToName( P.BindName$"_Dead" );
			if ( GetBoolFlag(FlagName) )
			{
				Log( Self $ ".FirstFrame() Removing dead " $ P.BindName, 'DevMissionScript' );
				P.Destroy();
			}
		}
	}

	// Print the mission startup text only once per map. TODO: MOVE ME!
	if ( Game.bShowStartupMessage )
	{
		// Do this just for listen server here
		// It is done for clients in GameReplicationInfo's PostNetBeginPlay()
		if ( Level.NetMode==NM_ListenServer )
		{
			for (i=0; i<ArrayCount(DXInfo.startupMessage); i++)
				HXRootWindow(HXPlayerPawn(GetPlayerPawn()).rootWindow).hud.startDisplay.AddMessage(DXInfo.startupMessage[i]);

			HXRootWindow(HXPlayerPawn(GetPlayerPawn()).rootWindow).hud.startDisplay.StartMessage();
		}
		//HXGameReplicationInfo(Level.Game.GameReplicationInfo).bAlreadyVisited = False;
	}

	FlagName = StringToName( "M"$DXInfo.MissionNumber$"MissionStart" );
	if ( !GetBoolFlag(FlagName) )
	{
		// Remove completed Primary goals and all Secondary goals
		HXGameInfo(Level.Game).ResetGoals();

		// Remove any Conversation History.
		//Player.ResetConversationHistory();

		// Set this flag so we only get in here once per mission.
		SetBoolFlag( FlagName, True, True, DXInfo.MissionNumber+1 );
	}
}

// ----------------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------------

function PreTravel()
{
	Log( Sprintf("PreTravel (Self=%s).",Self.Name), 'DevMissionScript' );

	// turn off the timer
	SetTimer(0, False);

	// zero the flags so FirstFrame() gets executed at load
	//flags = None;
	//Steve = None;
}

// ----------------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------------

function Timer()
{
	// make sure our flags are initialized correctly
	if (Steve == None)
	{
		InitStateMachine();

		// Don't want to do this if the user just loaded a savegame
		//if ((player != None) && (flags.GetBool('PlayerTraveling')))
		//if ( Steve.flagbase.GetBool('PlayerTraveling') )

		// HX_NOTE: looks like this should always be called, since there is no
		// savegame support yet
		FirstFrame();
	}
}

// ----------------------------------------------------------------------------
// InitSkillPoints()
// ----------------------------------------------------------------------------

static function InitSkillPoints( HXGameInfo Game, HXSteve Steve )
{
	// 6575 are DeusEx starting points.
	Steve.SkillPointsTotal = FMax( Steve.SkillPointsTotal, (1.0-Game.SkillPointPenalty)*6575.0+Game.StartingSkillPointsBonus );

	//Log( "Steve.SkillPointsTotal = " $ Steve.SkillPointsTotal, 'DevMissionScript' );
}

// ----------------------------------------------------------------------------
// RandomizeEvents()
//
// Randomizes what happened at this Mission, so one would not start blank
// with what happened in prior mission.
// ----------------------------------------------------------------------------

static function RandomizeEvents( HXGameInfo Game, HXSteve Steve, int MissionNumber, String MapName )
{
	if ( Default.PrevMissionScript!=None )
		Default.PrevMissionScript.Static.RandomizeEvents( Game, Steve, MissionNumber, MapName );

	Log( "Randomizing events in " $ Default.Class, 'DevMissionScript' );
}

// ----------------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------------

event Tick( float DeltaTime )
{
	Super.Tick( DeltaTime );
	//Log(self $ ".Tick() called", 'DevMissionScript' );

	// moved here from PostPostBeginPlay() might be buggy for traveling
	//if (flags == None)
		//SetTimer(checkTime, True);
}

// ----------------------------------------------------------------------------
// StartDataLinkTransmission() -- Conveniance function.
// ----------------------------------------------------------------------------

function bool StartDataLinkTransmission( String DatalinkName )
{
	return HXGameInfo(Level.Game).StartDataLinkTransmission( DatalinkName );
}

// ----------------------------------------------------------------------------
// AcceptInventory()
// ----------------------------------------------------------------------------

function AcceptInventory( HXPlayerPawn Player, String Portal, String MapURL )
{
}

// ----------------------------------------------------------------------------
// GiveInitialInventory()
// ----------------------------------------------------------------------------

function GiveInitialInventory( HXPlayerPawn Player, String Portal, String MapURL )
{
	// Default singleplayer Equipment.
	GiveInventoryItem( Player, WeaponPistolClass, 1 );
	GiveInventoryItem( Player, WeaponProdClass,   1 );
	GiveInventoryItem( Player, MedKitClass,       1 );
}

// ----------------------------------------------------------------------------
// GiveInventoryItem()
// ----------------------------------------------------------------------------

static function GiveInventoryItem( HXPlayerPawn Player, Class<Inventory> ItemClass, int Count )
{
	local Inventory Item;

	if ( ItemClass==None )
	{
		Warn( "ItemClass is None." );
		return;
	}
	if ( Count<=0 )
	{
		Warn( "Count is "$Count$"." );
		return;
	}

	for ( Count=Count; Count>0; Count-- )
	{
		Item = Player.Spawn( ItemClass, Player );
		Item.Frob( Player, None );
		if ( Player.Level.Game.ShouldRespawn(Item) )
			Item.Destroy();
	}
}

// ----------------------------------------------------------------------------
// SetBoolFlag()
// ----------------------------------------------------------------------------

function bool SetBoolFlag( Name FlagName, bool newValue, bool bAdd, int Expiration )
{
	local bool bResult;

	if ( Steve.FlagBase==None )
	{
		Log( "Steve.FlagBase is None", 'DevMissionScript' );
		return false;
	}

	// HACK: match optional default value in exec.
	//if ( expiration == 0 )
		//expiration = 1;

	Log( Sprintf("SetBoolFlag (FlagName=%s,Value=%s,Expiration=%s)",FlagName,NewValue,Expiration), 'DevMissionScript' );

	// I WILL KILL THEM ALL !!!
	bAdd = True;
	
	bResult = Steve.FlagBase.SetBool( flagName, newValue, bAdd, expiration );
	//bResult = true;

	if ( bResult )
		HXGameInfo(Level.Game).FlagReplicationInfo.SetBoolFlag( flagName, int(newValue) );

	return bResult;
}

// ----------------------------------------------------------------------------
// GetBoolFlag()
// ----------------------------------------------------------------------------

function bool GetBoolFlag( Name flagName )
{
	return Steve.FlagBase.GetBool( flagName );
}

// ----------------------------------------------------------------------------
// DeleteBoolFlag()
// ----------------------------------------------------------------------------

function bool DeleteBoolFlag( Name flagName )
{
	return Steve.FlagBase.DeleteFlag( flagName, FLAG_Bool );
}

// ----------------------------------------------------------------------------
// StringToName()
// ----------------------------------------------------------------------------

function Name StringToName( string Str )
{
	return class'HXMutator'.static.StringToName( Str );
}

// ----------------------------------------------------------------------------
// PawnsEnterWorld()
// 
// Makes ScriptedPawns leave the world. bSingle parameter is used if the
// function return after first occurance (used for optimisation).
// ----------------------------------------------------------------------------

function PawnsEnterWorld( class<HXScriptedPawn> PawnClass, optional Name PawnTag, optional bool bSingle )
{
	local Pawn Pawn;
	local int Count;

	// Used to class spot loading errors (maybe remove later).
	if ( PawnClass==None )
	{
		Warn( Sprintf("Class is None (Tag=%s,bSingle=%b).",PawnTag,bSingle) );
		return;
	}

	// Pawn has no Tag, so don't check it.
	if ( PawnTag=='' )
	{
		if ( bSingle )
		{
			for ( Pawn=Level.PawnList; Pawn!=None; Pawn=Pawn.NextPawn )
			{
				if ( ClassIsChildOf(Pawn.Class,PawnClass) )
				{
					HXScriptedPawn(Pawn).EnterWorld();
					Count++;
					break;
				}
			}
		}
		else // !bSingle
		{
			for ( Pawn=Level.PawnList; Pawn!=None; Pawn=Pawn.NextPawn )
			{
				if ( ClassIsChildOf(Pawn.Class,PawnClass) )
				{
					HXScriptedPawn(Pawn).EnterWorld();
					Count++;
				}
			}
		}
	}
	else // Pawn.Tag!=''
	{
		if ( bSingle )
		{
			for ( Pawn=Level.PawnList; Pawn!=None; Pawn=Pawn.NextPawn )
			{
				if ( Pawn.Tag==PawnTag && ClassIsChildOf(Pawn.Class,PawnClass) )
				{
					HXScriptedPawn(Pawn).EnterWorld();
					Count++;
					break;
				}
			}
		}
		else // !bSingle
		{
			for ( Pawn=Level.PawnList; Pawn!=None; Pawn=Pawn.NextPawn )
			{
				if ( Pawn.Tag==PawnTag && ClassIsChildOf(Pawn.Class,PawnClass) )
				{
					HXScriptedPawn(Pawn).EnterWorld();
					Count++;
				}
			}
		}
	}

	Log( Sprintf("PawnsEnterWorld (Class=%s,Tag=%s,bSingle=%b,Count=%i)",PawnClass.Name,PawnTag,bSingle,Count), 'DevMissionScript' );
}

// ----------------------------------------------------------------------------
// PawnsLeaveWorld()
// 
// Makes ScriptedPawns leave the world. bSingle parameter is used if the
// function return after first occurance (used for optimisation).
// ----------------------------------------------------------------------------

function PawnsLeaveWorld( class<HXScriptedPawn> PawnClass, optional Name PawnTag, optional bool bSingle )
{
	local Pawn Pawn;
	local int Count;

	// Used to class spot loading errors (maybe remove later).
	if ( PawnClass==None )
	{
		Warn( Sprintf("Class is None (Tag=%s,bSingle=%b).",PawnTag,bSingle) );
		return;
	}

	// Pawn has no Tag, so don't check it.
	if ( PawnTag=='' )
	{
		if ( bSingle )
		{
			for ( Pawn=Level.PawnList; Pawn!=None; Pawn=Pawn.NextPawn )
			{
				if ( ClassIsChildOf(Pawn.Class,PawnClass) )
				{
					HXScriptedPawn(Pawn).LeaveWorld();
					Count++;
					break;
				}
			}
		}
		else // !bSingle
		{
			for ( Pawn=Level.PawnList; Pawn!=None; Pawn=Pawn.NextPawn )
			{
				if ( ClassIsChildOf(Pawn.Class,PawnClass) )
				{
					HXScriptedPawn(Pawn).LeaveWorld();
					Count++;
				}
			}
		}
	}
	else // Pawn.Tag!=''
	{
		if ( bSingle )
		{
			for ( Pawn=Level.PawnList; Pawn!=None; Pawn=Pawn.NextPawn )
			{
				if ( Pawn.Tag==PawnTag && ClassIsChildOf(Pawn.Class,PawnClass) )
				{
					HXScriptedPawn(Pawn).LeaveWorld();
					Count++;
					break;
				}
			}
		}
		else // !bSingle
		{
			for ( Pawn=Level.PawnList; Pawn!=None; Pawn=Pawn.NextPawn )
			{
				if ( Pawn.Tag==PawnTag && ClassIsChildOf(Pawn.Class,PawnClass) )
				{
					HXScriptedPawn(Pawn).LeaveWorld();
					Count++;
				}
			}
		}
	}

	Log( Sprintf("PawnsLeaveWorld (Class=%s,Tag=%s,bSingle=%b,Count=%i)",PawnClass.Name,PawnTag,bSingle,Count), 'DevMissionScript' );
}

// ----------------------------------------------------------------------------
// DecorationsEnterWorld()
// 
// Makes Decorations leave the world. bSingle parameter is used if the
// function return after first occurance (used for optimisation).
// ----------------------------------------------------------------------------

function DecorationsEnterWorld( class<HXDecoration> DecorationClass, optional Name DecorationTag, optional bool bSingle )
{
	local Actor Actor;
	local int Count;

	// Used to class spot loading errors (maybe remove later).
	if ( DecorationClass==None )
	{
		Warn( Sprintf("Class is None (Tag=%s,bSingle=%b).",DecorationTag,bSingle) );
		return;
	}

	if ( bSingle )
	{
		foreach AllActors( DecorationClass, Actor, DecorationTag )
		{
			HXDecoration(Actor).EnterWorld();
			Count++;
			break;
		}
	}
	else // !bSingle
	{
		foreach AllActors( DecorationClass, Actor, DecorationTag )
		{
			HXDecoration(Actor).EnterWorld();
			Count++;
		}
	}

	Log( Sprintf("DecorationsEnterWorld (Class=%s,Tag=%s,bSingle=%b,Count=%i)",DecorationClass.Name,DecorationTag,bSingle,Count), 'DevMissionScript' );
}

// ----------------------------------------------------------------------------
// DecorationsLeaveWorld()
// 
// Makes Decorations leave the world. bSingle parameter is used if the
// function return after first occurance (used for optimisation).
// ----------------------------------------------------------------------------

function DecorationsLeaveWorld( class<HXDecoration> DecorationClass, optional Name DecorationTag, optional bool bSingle )
{
	local Actor Actor;
	local int Count;

	// Used to class spot loading errors (maybe remove later).
	if ( DecorationClass==None )
	{
		Warn( Sprintf("Class is None (Tag=%s,bSingle=%b).",DecorationTag,bSingle) );
		return;
	}

	if ( bSingle )
	{
		foreach AllActors( DecorationClass, Actor, DecorationTag )
		{
			HXDecoration(Actor).LeaveWorld();
			Count++;
			break;
		}
	}
	else // !bSingle
	{
		foreach AllActors( DecorationClass, Actor, DecorationTag )
		{
			HXDecoration(Actor).LeaveWorld();
			Count++;
		}
	}

	Log( Sprintf("DecorationsLeaveWorld (Class=%s,Tag=%s,bSingle=%b,Count=%i)",DecorationClass.Name,DecorationTag,bSingle,Count), 'DevMissionScript' );
}

// ----------------------------------------------------------------------------
// PawnsExist()
// 
// Checks for at least one occurance of Pawn.
// ----------------------------------------------------------------------------

function bool PawnsExist( class<HXScriptedPawn> PawnClass, optional Name PawnTag )
{
	local Pawn Pawn;

	if ( PawnClass==None )
	{
		Warn( Sprintf("Class is None (Tag=%s).",PawnTag) );
		return false;
	}

	if ( PawnTag=='' )
	{
		for ( Pawn=Level.PawnList; Pawn!=None; Pawn=Pawn.NextPawn )
			if ( !Pawn.bDeleteMe && ClassIsChildOf(Pawn.Class,PawnClass) )
				return true;

		return false;
	}
	else // PawnTag!=''
	{
		for ( Pawn=Level.PawnList; Pawn!=None; Pawn=Pawn.NextPawn )
			if ( !Pawn.bDeleteMe && Pawn.Tag==PawnTag && ClassIsChildOf(Pawn.Class,PawnClass) )
				return true;

		return false;
	}
}

// ----------------------------------------------------------------------------
// ActorsExist()
// 
// Checks for at least one occurance of Actor.
// ----------------------------------------------------------------------------

function bool ActorsExist( class<Actor> ActorClass, optional Name ActorTag )
{
	local Actor Actor;

	// Used to class spot loading errors (maybe remove later).
	if ( ActorClass==None )
	{
		Warn( Sprintf("Class is None (Tag=%s).",ActorTag) );
		return false;
	}

	foreach AllActors( ActorClass, Actor, ActorTag )
		if ( !Actor.bDeleteMe )
			return true;

	return false;
}

// ----------------------------------------------------------------------------
// DestroyActors()
// 
// Destroys all Actors of class ActorClass with optional ActorTag.
// ----------------------------------------------------------------------------

function DestroyActors( class<Actor> ActorClass, optional Name ActorTag, optional bool bSingle )
{
	local Actor Actor;
	local int Count;

	// Used to class spot loading errors (maybe remove later).
	if ( ActorClass==None )
	{
		Warn( Sprintf("Class is None (Tag=%s,bSingle=%b).",ActorTag,bSingle) );
		return;
	}

	foreach AllActors( ActorClass, Actor, ActorTag )
	{
		Actor.Destroy();
		Count++;
		if ( bSingle )
			break;
	}

	Log( Sprintf("DestroyActors (Class=%s,Tag=%s,bSingle=%b,Count=%i)",ActorClass.Name,ActorTag,bSingle,Count), 'DevMissionScript' );
}

// ----------------------------------------------------------------------------
// BlowUpMovers()
// 
// Blows up all Movers of a certain class with an optional tag.
// ----------------------------------------------------------------------------

function BlowUpMovers( class<HXMover> MoverClass, optional Name MoverTag )
{
	local Actor Actor;
	local int Count;

	if ( MoverClass==None )
	{
		Warn( Sprintf("Class is None (Tag=%s).",MoverTag) );
		return;
	}

	foreach AllActors( MoverClass, Actor, MoverTag )
	{
		HXMover(Actor).BlowItUp( None );
		Count++;
	}

	Log( Sprintf("BlowUpMovers (Class=%s,Tag=%s,Count=%i)",MoverClass.Name,MoverTag,Count), 'DevMissionScript' );
}

// ----------------------------------------------------------------------------
// UnlockMovers()
// 
// Unlocks up all Movers of a certain class with an optional tag
// with optional Trigger handling.
// ----------------------------------------------------------------------------

function UnlockMovers( class<HXMover> MoverClass, optional Name MoverTag, optional bool bTrigger, optional Actor Other, optional Pawn EventInstigator )
{
	local HXMover Mover;
	local Actor Actor;
	local int Count;
	local Name OtherName, EventInstigatorName;

	if ( Other!=None )
		OtherName = Other.Name;
	if ( EventInstigator!=None )
		EventInstigatorName = EventInstigator.Name;

	if ( MoverClass==None )
	{
		Warn( Sprintf("Class is None (Tag=%s,bTrigger=%b,Other=%s,EventInstigator=%s).",MoverTag,bTrigger,OtherName,EventInstigatorName) );
		return;
	}

	foreach AllActors( MoverClass, Actor, MoverTag )
	{
		Mover = HXMover(Actor);

		Mover.bLocked = False;
		Mover.LockStrength = 0.0;

		if ( bTrigger )
			Mover.Trigger( Other, EventInstigator );

		Count++;
	}

	Log( Sprintf("UnlockMovers (%s,EventInstigator=%s,Count=%i)",Sprintf("Class=%s,Tag=%s,bTrigger=%b,Other=%s",MoverClass.Name,MoverTag,bTrigger,OtherName),EventInstigatorName,Count), 'DevMissionScript' );
}

// ----------------------------------------------------------------------------
// HideActors()
// 
// Hides all Actor of a certain class with an optional tag.
// You might NOT want to use this for Decorations and ScriptedPawns.
// ----------------------------------------------------------------------------

function HideActors( class<Actor> ActorClass, optional Name ActorTag )
{
	local Actor Actor;
	local int Count;

	// Used to class spot loading errors (maybe remove later).
	if ( ActorClass==None )
	{
		Warn( Sprintf("Class is None (Tag=%s).",ActorTag) );
		return;
	}

	foreach AllActors( ActorClass, Actor, ActorTag )
	{
		Actor.bHidden = true;
		Count++;
	}

	Log( Sprintf("HideActors (Class=%s,Tag=%s,Count=%i)",ActorClass.Name,ActorTag,Count), 'DevMissionScript' );
}

// ----------------------------------------------------------------------------
// UnhideActors()
// 
// Unhides all Actor of a certain class with an optional tag.
// You might NOT want to use this for Decorations and ScriptedPawns.
// ----------------------------------------------------------------------------

function UnhideActors( class<Actor> ActorClass, optional Name ActorTag )
{
	local Actor Actor;
	local int Count;

	// Used to class spot loading errors (maybe remove later).
	if ( ActorClass==None )
	{
		Warn( Sprintf("Class is None (Tag=%s).",ActorTag) );
		return;
	}

	foreach AllActors( ActorClass, Actor, ActorTag )
	{
		Actor.bHidden = false;
		Count++;
	}

	Log( Sprintf("UnhideActors (Class=%s,Tag=%s,Count=%i)",ActorClass.Name,ActorTag,Count), 'DevMissionScript' );
}

// ----------------------------------------------------------------------------
// TriggerActors()
// 
// Triggers all Actors of a certain class with an optional tag.
// ----------------------------------------------------------------------------

function TriggerActors( class<Actor> ActorClass, optional Name ActorTag, optional Actor Other, optional Pawn EventInstigator )
{
	local Actor Actor;
	local int Count;
	local Name OtherName, EventInstigatorName;

	if ( Other!=None )
		OtherName = Other.Name;
	if ( EventInstigator!=None )
		EventInstigatorName = EventInstigator.Name;

	// Used to class spot loading errors (maybe remove later).
	if ( ActorClass==None )
	{
		Warn( Sprintf("Class is None (Tag=%s,Other=%s,EventInstigator=%s).",ActorTag,OtherName,EventInstigatorName) );
		return;
	}

	foreach AllActors( ActorClass, Actor, ActorTag )
	{
		Actor.Trigger( Other, EventInstigator );
		Count++;
	}

	Log( Sprintf("TriggerActors (%s,Count=%i)",Sprintf("Class=%s,Tag=%s,Other=%s,EventInstigator=%s",ActorClass.Name,ActorTag,OtherName,EventInstigatorName),Count), 'DevMissionScript' );
}

// ----------------------------------------------------------------------------
// UnTriggerActors()
// 
// UnTriggers all Actors of a certain class with an optional tag.
// ----------------------------------------------------------------------------

function UnTriggerActors( class<Actor> ActorClass, optional Name ActorTag, optional Actor Other, optional Pawn EventInstigator )
{
	local Actor Actor;
	local int Count;
	local Name OtherName, EventInstigatorName;

	if ( Other!=None )
		OtherName = Other.Name;
	if ( EventInstigator!=None )
		EventInstigatorName = EventInstigator.Name;

	// Used to class spot loading errors (maybe remove later).
	if ( ActorClass==None )
	{
		Warn( Sprintf("Class is None (Tag=%s,Other=%s,EventInstigator=%s).",ActorTag,OtherName,EventInstigatorName) );
		return;
	}

	foreach AllActors( ActorClass, Actor, ActorTag )
	{
		Actor.UnTrigger( Other, EventInstigator );
		Count++;
	}

	Log( Sprintf("UnTriggerActors (%s,Count=%i)",Sprintf("Class=%s,Tag=%s,Other=%s,EventInstigator=%s",ActorClass.Name,ActorTag,OtherName,EventInstigatorName),Count), 'DevMissionScript' );
}

// ----------------------------------------------------------------------------
// GetPatrolPoint()
// ----------------------------------------------------------------------------

function PatrolPoint GetPatrolPoint( Name PatrolTag, optional bool bRandom )
{
	local PatrolPoint PatrolPoint;

	foreach AllActors( class'PatrolPoint', PatrolPoint, PatrolTag )
		return PatrolPoint;

	return None;
}

// ----------------------------------------------------------------------------
// GetSpawnPoint()
// ----------------------------------------------------------------------------

function SpawnPoint GetSpawnPoint( Name SpawnTag, optional bool bRandom )
{
	local SpawnPoint SpawnPoint;

	foreach AllActors( class'SpawnPoint', SpawnPoint, SpawnTag )
		return SpawnPoint;

	return None;
}

// ----------------------------------------------------------------------------
// GetCoopStart()
// ----------------------------------------------------------------------------

function HXCoopStart GetCoopStart( Name SpawnTag )
{
	local HXCoopStart CoopStart;

	foreach AllActors( class'HXCoopStart', CoopStart, SpawnTag )
		return CoopStart;

	return None;
}

// ----------------------------------------------------------------------------
// TeleportPawn() -- Moved here out of Mission06.
// ----------------------------------------------------------------------------

function TeleportPawn( HXScriptedPawn ScriptedPawn, Name PatrolTag, Name Orders, optional bool bRandom )
{
	local PatrolPoint PatrolPoint;

	if ( ScriptedPawn==None )
	{
		Warn( Sprintf("ScriptedPawn is None (PatrolTag=%s,Orders=%s,bRandom=%b).",PatrolTag,Orders,bRandom) );
		return;
	}

	PatrolPoint = GetPatrolPoint( PatrolTag, bRandom );
	if ( PatrolPoint==None )
	{
		Warn( Sprintf("Cannot find PatrolPoint (Pawn=%s,PatrolTag=%s,Orders=%s,bRandom=%b).",ScriptedPawn.Name,PatrolTag,Orders,bRandom) );
		return;
	}

	ScriptedPawn.SetLocation( PatrolPoint.Location );
	ScriptedPawn.SetRotation( PatrolPoint.Rotation );
	ScriptedPawn.SetOrders( Orders,, true );

	Log( Sprintf("TeleportPawn (%s,bRandom=%b)",Sprintf("Pawn=%s,PatrolPoint=%,PatrolTag=%s,Orders=%s",ScriptedPawn.Name,PatrolPoint.Name,PatrolTag,Orders),bRandom), 'DevMissionScript' );
}

// ----------------------------------------------------------------------------
// CompleteGoal()
// ----------------------------------------------------------------------------

function CompleteGoal( Name GoalName )
{
	Game.GoalCompleted( GoalName );

	Log( Sprintf("Completed Goal (Goal=%s).",GoalName), 'DevMissionScript' );
}

// ----------------------------------------------------------------------------
// DeleteGoal()
// ----------------------------------------------------------------------------

function DeleteGoal( Name GoalName )
{
	Game.DeleteGoalByName( GoalName );

	Log( Sprintf("Deleted Goal (Goal=%s).",GoalName), 'DevMissionScript' );
}

// ----------------------------------------------------------------------------
// IsGoalCompleted()
// ----------------------------------------------------------------------------

function bool IsGoalCompleted( Name GoalName )
{
	return Game.IsGoalCompleted('PowerElevator');
}

// ----------------------------------------------------------------------------
// Trigger()
// ----------------------------------------------------------------------------

event Trigger( Actor Other, Pawn EventInstigator )
{
	local Name OtherName, EventInstigatorName;

	if ( Other!=None )
		OtherName = Other.Name;
	if ( EventInstigator!=None )
		EventInstigatorName = EventInstigator.Name;

	Log( Sprintf("Trigger (Other=%s,EventInstigator=%s)",OtherName,EventInstigatorName), 'DevMissionScript' );
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bGameRelevant=True
	CheckTime=1.000000
	LocalURL="NOTHING"
	bCinematicMap=False
}
