//=============================================================================
// HXNanoKey.
//=============================================================================
class HXNanoKey extends HXDeusExPickup;

var() Name KeyID; // Unique FName identifier used for movers and such.

enum ESkinColor
{
	SC_Level1,
	SC_Level2,
	SC_Level3,
	SC_Level4
};

var() ESkinColor SkinColor;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local NanoKey OtherNanoKey;

	// Call Super.
	Super.Succeeds( Other );

	// Special NanoKey Init.
	OtherNanoKey = NanoKey(Other);
	if ( OtherNanoKey!=None )
	{
		// NanoKey.
		KeyID				= OtherNanoKey.KeyID;
		Description	= OtherNanoKey.Description;
		SetPropertyText( "SkinColor", OtherNanoKey.GetPropertyText("SkinColor") );
	}
}

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	Super.BeginPlay();

	if ( bDeleteMe )
		return;

	if ( Role==ROLE_Authority && !IsInRelevant() )
	{
		switch ( SkinColor )
		{
			case SC_Level1:	MultiSkins[0] = Texture'NanoKeyTex1'; break;
			case SC_Level2:	MultiSkins[0] = Texture'NanoKeyTex2'; break;
			case SC_Level3:	MultiSkins[0] = Texture'NanoKeyTex3'; break;
			case SC_Level4:	MultiSkins[0] = Texture'NanoKeyTex4'; break;
		}
	}
}

// ----------------------------------------------------------------------------
// GiveTo()
//
// Called during conversations since HandlePickupQuery() isn't called then.
// ----------------------------------------------------------------------------

function GiveTo( pawn Other )
{
	local DeusExPlayer player;

	if (Other.IsA('DeusExPlayer'))
	{
		HXGameInfo(Level.Game).PickupNanoKey(Self);

		//player = DeusExPlayer(Other);
		//player.PickupNanoKey(Self);
		Destroy();
	}
	else
	{
		Super.GiveTo(Other);
	}
}

// ----------------------------------------------------------------------------
// HandlePickupQuery()
//
// Adds the NanoKey to the player's NanoKeyRing and then destroys 
// this object
// ----------------------------------------------------------------------------

function bool HandlePickupQuery( inventory Item )
{
	local DeusExPlayer player;

	if ( Item.Class == Class )
	{
		HXGameInfo(Level.Game).PickupNanoKey(Self);

		//player = DeusExPlayer(Owner);
		//player.PickupNanoKey(NanoKey(item));
		item.Destroy();
			
		return True;
	}

	return Super.HandlePickupQuery(Item);
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	ItemName="NanoKey"
	PlayerViewOffset=(X=30.0,Y=0.0,Z=-12.0)
	PlayerViewMesh=NanoKey
	PickupViewMesh=NanoKey
	ThirdPersonMesh=NanoKey
	MultiSkins(0)=NanoKeyTex1
	Icon=Texture'DeusExUI.Icons.BeltIconNanoKey'
	Description="NO KEY DESCRIPTION - REPORT THIS AS A BUG!"
	BeltDescription="NANO"
	Mesh=NanoKey
	CollisionRadius=2.05
	CollisionHeight=3.11
	Mass=1.0
}
