//=============================================================================
// HXNetworkTerminal.
//=============================================================================
class HXNetworkTerminal extends DeusExBaseWindow
	abstract;

var HXComputerUIWindow           WinComputer;           // Currently active computer screen.
var HXComputerScreenHack         WinHack;               // Ice Breaker Hack Window.
var ShadowWindow                 WinHackShadow;
var HXComputerScreenHackAccounts WinHackAccounts;       // Hack Accounts Window, used for email.
var ShadowWindow                 WinHackAccountsShadow;
var HXComputers                  CompOwner;             // what computer owns this window?.

var Class<HXComputerUIWindow>    FirstScreen;           // First screen to push

// Hacking related variables
var float LoginTime;       // Time that the user logged in.
var float DetectionTime;   // Total time a user may be logged on.
var int   KickTimerID;     // Timer ID for kicking the user off.
var int   SkillLevel;      // Player's computer skill level (0-3).
var bool  bHacked;         // This computer has been hacked.
var bool  bNoHack;         // This computer has been purposely not hacked.
var bool  bUsesHackWindow; // True if Hack Window created by default.

// Login related variables
var String UserName;
var int    UserIndex;

// Shadow stuff
var int ShadowOffsetX;
var int ShadowOffsetY;

// NodeInfos. See comment above HXComputers.EComputerNodes.
struct sNodeInfo
{
	var localized string NodeName;
	var localized string NodeDesc;
	var string NodeAddress;
	var Texture NodeTexture;
};
var localized sNodeInfo NodeInfo[30];

// ----------------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();

	SetWindowAlignments( HALIGN_Full, VALIGN_Full );

	// Draw a black background for now.
	SetBackgroundStyle( DSTY_Normal );
	SetBackground( Texture'Solid' );
	SetTileColorRGB( 0, 0, 0 );
	SetMouseFocusMode( MFOCUS_Click );

	Root.ShowHUD( False );

	CreateHackWindow();

	bTickEnabled = True;
}

// ----------------------------------------------------------------------------
// DestroyWindow()
//
// Destroys the Window
// ----------------------------------------------------------------------------

event DestroyWindow()
{
	if ( CompOwner!=None )
	{
		if ( Player!=Player.GetPlayerPawn() )
		{
			Log("==============>Player mismatch!!!!");
		}
		// Keep track of the last time this computer was hacked.
		else if ( HXPlayerPawn(Player).HXActiveComputer==CompOwner )
		{
			if ( bHacked )
				HXPlayerPawn(Player).HXSetComputerHackTime( CompOwner, CompOwner.Level.TimeSeconds, CompOwner.Level.TimeSeconds );
			HXPlayerPawn(Player).HXCloseComputerScreen( CompOwner );
			HXPlayerPawn(Player).HXActiveComputer = None;
		}

		CompOwner.TermWindow = None;
	}

	// Show the HUD again.
	Root.ShowHUD(True);

	// Now finish destroy us.
	Super.DestroyWindow();
}

// ----------------------------------------------------------------------------
// Tick()
//
// Checks to see if the player has died, and if so, gets us the 
// hell out of this screen!!
// ----------------------------------------------------------------------------

function Tick( float DeltaTime )
{
	if ( Player!=None && Player.IsInState('Dying') )
	{
		bTickEnabled = False;
		CloseScreen("EXIT");	
	}
	else
	{
		// DEUS_EX AMSD Put this in an else.  Don't do this if you are dead and have
		// closed the screen!
		// Update the hack bar detection time
		UpdateHackDetectionTime();
	}
}

// ----------------------------------------------------------------------------
// ConfigurationChanged()
//
// Used to Manually place the computer screen if the Hack window 
// is visible and the computer screen's position would overlap
// the hack window.
// ----------------------------------------------------------------------------

function ConfigurationChanged()
{
	local float HackWidth, HackHeight, HackAccountsWidth, HackAccountsHeight;
	local float CompWidth, CompHeight, CompX;

	// First look for the hack window.  If it's not visible, then our work here is done!
	if ( WinHack!=None )
	{
		WinHack.QueryPreferredSize( HackWidth, HackHeight );

		// Shove in upper-right hand corner.
		WinHack.ConfigureChild( Width - HackWidth, 0, HackWidth, HackHeight );

		// Place shadow.
		WinHackShadow.ConfigureChild
		(
			Width - HackWidth + WinHack.BackgroundPosX - ShadowOffsetX,
			WinHack.BackgroundPosY - ShadowOffsetY,
			WinHack.backgroundWidth + ShadowOffsetX * 2,
			WinHack.backgroundHeight + ShadowOffsetY * 2
		);
	}

	// Check for the Hack Accounts window, which is displayed underneath the Hack window.  Position under the Hack Window.
	if ( WinHackAccounts!=None )
	{
		WinHackAccounts.QueryPreferredSize( HackAccountsWidth, HackAccountsHeight );
		WinHackAccounts.ConfigureChild( Width - HackAccountsWidth, HackHeight + 20, HackAccountsWidth, HackAccountsHeight );

		// Place shadow.
		WinHackAccountsShadow.ConfigureChild
		(
			Width - HackAccountsWidth + WinHackAccounts.BackgroundPosX - ShadowOffsetX, 
			HackHeight + 20 + WinHackAccounts.BackgroundPosY - ShadowOffsetY, 
			WinHackAccounts.BackgroundWidth + ShadowOffsetX * 2, 
			WinHackAccounts.BackgroundHeight + ShadowOffsetY * 2
		);
	}

	// Now check to see if we have a computer screen.  If so, center it in relation to the hack window.
	// Don't force position if the window has been dragged somewhere else by the user.
	if ( WinComputer!=None && !WinComputer.bWindowDragged )
	{
		WinComputer.QueryPreferredSize( CompWidth, CompHeight );

		// Center the window, but move it left if the height of the hack window would infringe on the window (unless the "bAlwaysCenter" flag is set)
		if ( (HackHeight + hackAccountsHeight + 20)>(Height / 2 - CompHeight / 2) && !WinComputer.bAlwaysCenter )
		{
			CompX = (Width - HackWidth) / 2 - CompWidth / 2;
		}
		else
		{
			CompX = Width / 2 - CompWidth / 2;
		}

		WinComputer.ConfigureChild( CompX, Height / 2 - CompHeight / 2, CompWidth, CompHeight );
	}
}

// ----------------------------------------------------------------------------------------
// VirtualKeyPressed
// ----------------------------------------------------------------------------------------

event bool VirtualKeyPressed( EInputKey key, bool bRepeat )
{
	local String KeyName, Alias;
	local bool bKeyHandled;

	bKeyHandled = False;

	if ( bKeyHandled )
		return True;
	else
		return Super.VirtualKeyPressed(key, bRepeat);
}

// ----------------------------------------------------------------------------
// ShowFirstScreen()
// ----------------------------------------------------------------------------

function ShowFirstScreen()
{
	ShowScreen( FirstScreen );
}

// ----------------------------------------------------------------------------
// ShowScreen()
// ----------------------------------------------------------------------------

function ShowScreen( Class<HXComputerUIWindow> NewScreen )
{
	//Log( Self $ ".ShowScreen( " $ newScreen $ " ) CompOwner = " $ CompOwner );

	// First close any existing screen
	if ( WinComputer!=None )
	{
		WinComputer.Destroy();
		WinComputer = None;
	}

	// Now invoke the new screen
	if ( NewScreen!=None )
	{
		WinComputer = HXComputerUIWindow(NewChild(NewScreen));
		WinComputer.SetWindowAlignments( HALIGN_Center, VALIGN_Center );
		WinComputer.SetNetworkTerminal( Self );
		WinComputer.SetCompOwner( CompOwner );
		WinComputer.Lower();
	}
}

// ----------------------------------------------------------------------------
// CloseScreen()
// ----------------------------------------------------------------------------

function CloseScreen( String Action )
{
	// First destroy the current screen.
	if ( WinComputer!=None )
	{
		WinComputer.Destroy();
		WinComputer = None;
	}

	// Based on the action, proceed!
	switch ( Action )
	{
		case "EXIT":
			if ( CompOwner!=None )
				HXPlayerPawn(Player).HXCloseComputerScreen( CompOwner );
			Root.PopWindow();
			return;
			break;

		case "LOGIN":
			// If the user is logging in and bypassing the Hack screen,
			// then destroy the Hack window
			if ( WinHack!=None && !bHacked )
			{
				CloseHackWindow();
				bNoHack = True;
			}
			break;

		default:
			break;
	}
}

// ----------------------------------------------------------------------------
// CloseHackWindow()
// ----------------------------------------------------------------------------

function CloseHackWindow()
{
	if ( WinHack!=None )
	{
		WinHack.Destroy();
		WinHack = None;
	}

	if ( WinHackShadow!=None )
	{
		WinHackShadow.Destroy();
		WinHackShadow = None;
	}
}

// ----------------------------------------------------------------------------
// ForceCloseScreen()
// ----------------------------------------------------------------------------

function ForceCloseScreen()
{
	// If a screen is active, tell it to exit.
	if ( WinComputer!=None )
		WinComputer.CloseScreen( WinComputer.EscapeAction );
}

// ----------------------------------------------------------------------------
// CreateHackWindow()
// ----------------------------------------------------------------------------

function CreateHackWindow()
{
	local Float HackTime;
	local Float SkillLevelValue;

	SkillLevelValue = Player.SkillSystem.GetSkillLevelValue( Class'HXSkillComputer' );
	SkillLevel      = Player.SkillSystem.GetSkillLevel( Class'HXSkillComputer' );

	// Check to see if the player is skilled in Hacking before creating the window.
	if ( SkillLevel>0 && bUsesHackWindow )
	{
		// Base the detection and hack time on the skill level.
		HackTime       = DetectionTime / (SkillLevelValue * 1.5);
		DetectionTime *= SkillLevelValue;

		// First create the shadow window
		WinHackShadow = ShadowWindow(NewChild(Class'ShadowWindow'));

		WinHack = HXComputerScreenHack(NewChild(Class'HXComputerScreenHack'));
		WinHack.SetNetworkTerminal( Self);
		WinHack.SetDetectionTime( DetectionTime, HackTime );
	}
}

// ----------------------------------------------------------------------------
// CreateHackAccountsWindow()
//
// Create the window used to hack email accounts, but only create it if
// the player hacked into the computer *and* there's more than one 
// account to display
// ----------------------------------------------------------------------------

function CreateHackAccountsWindow()
{
	if ( bHacked && WinHackAccounts==None && NumComputerUsers(CompOwner)>1 )
	{
		// First create the shadow window.
		WinHackAccountsShadow = ShadowWindow(NewChild(Class'ShadowWindow'));

		WinHackAccounts = HXComputerScreenHackAccounts(NewChild(Class'HXComputerScreenHackAccounts'));
		WinHackAccounts.SetNetworkTerminal( Self );
		WinHackAccounts.SetCompOwner( CompOwner );
		WinHackAccounts.AskParentForReconfigure();
	}
}

// ----------------------------------------------------------------------------
// CloseHackAccountsWindow()
// ----------------------------------------------------------------------------

function CloseHackAccountsWindow()
{
	if ( WinHackAccounts!=None )
	{
		WinHackAccounts.Destroy();
		WinHackAccounts = None;
	}

	if ( WinHackAccountsShadow!=None )
	{
		WinHackAccountsShadow.Destroy();
		WinHackAccountsShadow = None;
	}
}

// ----------------------------------------------------------------------------
// SetHackButtonToReturn()
// ----------------------------------------------------------------------------

function SetHackButtonToReturn()
{
	if ( bHacked && WinHack!=None )
		WinHack.SetHackButtonToReturn();
}

// ----------------------------------------------------------------------------
// SetCompOwner()
// ----------------------------------------------------------------------------

function SetCompOwner( HXComputers NewCompOwner )
{
	CompOwner = NewCompOwner;

	if ( WinComputer!=None )
		WinComputer.SetCompOwner( NewCompOwner );

	// Update the hack bar detection time
	UpdateHackDetectionTime();
}

// ----------------------------------------------------------------------------
// UpdateHackDetectionTime()
// ----------------------------------------------------------------------------

function UpdateHackDetectionTime()
{
	local Float DetectionTime;
	local Float Diff;

	// If the hack window is active, then we need to update the detection time.
	if ( WinHack!=None && !Winhack.bHacking && CompOwner!=None && !bHacked )
	{
		DetectionTime = WinHack.GetSaveDetectionTime();
		Diff = Player.Level.TimeSeconds - CompOwner.LastHackTime;

		if ( Diff<DetectionTime )
			WinHack.UpdateDetectionTime( Diff+0.5 );
	}
}

// ----------------------------------------------------------------------------
// SetLoginInfo()
// ----------------------------------------------------------------------------

function SetLoginInfo( String NewUserName, Int NewUserIndex )
{
	UserName  = NewUserName;
	UserIndex = NewUserIndex;
}

// ----------------------------------------------------------------------------
// ChangeAccount()
// ----------------------------------------------------------------------------

function ChangeAccount( int NewUserIndex )
{
	UserIndex = NewUserIndex;

	if ( CompOwner!=None )
		UserName = GetComputerUserName( CompOwner, UserIndex );

	// Notify the computer window.
	if ( WinComputer!=None )
		WinComputer.ChangeAccount();
}

// ----------------------------------------------------------------------------
// GetUserName()
// ----------------------------------------------------------------------------

function String GetUserName()
{
	return UserName;
}

// ----------------------------------------------------------------------------
// GetUserIndex()
// ----------------------------------------------------------------------------

function int GetUserIndex()
{
	return UserIndex;
}

// ----------------------------------------------------------------------------
// SetSkillLevel()
// ----------------------------------------------------------------------------

function SetSkillLevel( int NewSkillLevel )
{
	SkillLevel = NewSkillLevel;
}

// ----------------------------------------------------------------------------
// GetSkillLevel()
// ----------------------------------------------------------------------------

function int GetSkillLevel()
{
	return SkillLevel;
}

// ----------------------------------------------------------------------------
// ComputerHacked()
//
// Computer was hacked, allow user to login
// ----------------------------------------------------------------------------

function ComputerHacked()
{
	bHacked = True;

	// Use the first login.
	UserIndex = 0;
	
	if ( CompOwner.IsA('HXComputers') )
		UserName = GetComputerUserName( CompOwner, UserIndex );
	
	CloseScreen( "LOGIN" );
}

// ----------------------------------------------------------------------------
// HackDetected()
// ----------------------------------------------------------------------------

function HackDetected(optional bool bDamageOnly)
{
	CompOwner.LockoutTime = Player.Level.TimeSeconds;
	CompOwner.bLockedOut  = True;

	// Shock the crap out of the player (drain BE and play a sound)
	// Highly skilled players take less damage
	HXPlayerPawn(Player).TakeHackDetectedDamage();

	if ( !bDamageOnly )
		CloseScreen( "EXIT" );
}

// ----------------------------------------------------------------------------
// AreSpecialOptionsAvailable()
// ----------------------------------------------------------------------------

function bool AreSpecialOptionsAvailable( optional bool bCheckActivated )
{
	local int i;

	// Also check if the "bCheckActivated" bool is set, in which case we also want to make sure the item hasn't already been triggered.
	for ( i=0; i<ArrayCount(CompOwner.SpecialOptions); i++ )
		if ( CompOwner.SpecialOptions[i].Text!="" && (CompOwner.SpecialOptions[i].UserName=="" || Caps(CompOwner.SpecialOptions[i].UserName)==UserName) )
			if ( !(bCheckActivated && CompOwner.SpecialOptions[i].bAlreadyTriggered) )
				return True;

	return False;
}

// ----------------------------------------------------------------------------
// NumComputerUsers()
//
// HX_HAN: Maybe count non zero slots instead?
// ----------------------------------------------------------------------------

function int NumComputerUsers( HXComputers Computer )
{
	local int i;

	for ( i=0; i<ArrayCount(Computer.UserList); i++ )
		if ( Computer.UserList[i].UserName=="" )
			break;

	return i;
}

// ----------------------------------------------------------------------------
// GetComputerUserName()
// ----------------------------------------------------------------------------

function string GetComputerUserName( HXComputers Computer, int userIndex)
{
	if ( UserIndex>=0 && UserIndex<ArrayCount(Computer.UserList) )
		return Computer.UserList[UserIndex].UserName;
	return "ERR";
}

// ----------------------------------------------------------------------------
// GetComputerPassword()
// ----------------------------------------------------------------------------

function string GetComputerPassword( HXComputers Computer, int UserIndex )
{
	if ( UserIndex>=0 && UserIndex<ArrayCount(Computer.UserList) )
		return Computer.UserList[userIndex].Password;
	return "ERR";
}

// ----------------------------------------------------------------------------
// GetComputerAccessLevel()
// ----------------------------------------------------------------------------

function int GetComputerAccessLevel( HXComputers Computer, int UserIndex )
{
	if ( UserIndex>=0 && UserIndex<ArrayCount(Computer.UserList) )
		return int(Computer.UserList[UserIndex].AccessLevel);
	return 0;
}

// ----------------------------------------------------------------------
// GetNodeName()
// ----------------------------------------------------------------------

function static String GetNodeName( int NodeID )
{
	return Default.NodeInfo[NodeID].NodeName;
}

// ----------------------------------------------------------------------
// GetNodeDesc()
// ----------------------------------------------------------------------

function static String GetNodeDesc( int NodeID )
{
	return Default.NodeInfo[NodeID].NodeDesc;
}

// ----------------------------------------------------------------------
// GetNodeAddress()
// ----------------------------------------------------------------------

function static String GetNodeAddress( int NodeID )
{
	return Default.NodeInfo[NodeID].NodeAddress;
}

// ----------------------------------------------------------------------
// GetNodeTexture()
// ----------------------------------------------------------------------

function static Texture GetNodeTexture( int NodeID )
{
	return Default.NodeInfo[NodeID].NodeTexture;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	DetectionTime=15.000000
	KickTimerID=-1
	bUsesHackWindow=True
	ShadowOffsetX=15
	ShadowOffsetY=15
	ScreenType=ST_Computer
	NodeInfo(0)=(NodeName="UNATCO",NodeDesc="United Nations Anti-Terrorist Coalition",NodeAddress="UN//UNATCO//RESTRICTED//923.128.6430",NodeTexture=Texture'DeusExUI.UserInterface.ComputerLogonLogoUNATCO')
	NodeInfo(1)=(NodeName="VersaLife",NodeDesc="VersaLife",NodeAddress="VERSALIFECORP//GLOBAL//3939.39.8",NodeTexture=Texture'DeusExUI.UserInterface.ComputerLogonLogoVersaLife')
	NodeInfo(2)=(NodeName="Queens Tower",NodeDesc="Queens Tower Luxury Suites",NodeAddress="QT_UTIL//LOCAL//673.9845.09531",NodeTexture=Texture'DeusExUI.UserInterface.ComputerLogonLogoQueensTower')
	NodeInfo(3)=(NodeName="USN",NodeDesc="United States Navy",NodeAddress="USGOV//MIL//USN//GLOBAL//0001",NodeTexture=Texture'DeusExUI.UserInterface.ComputerLogonLogoUSNavy')
	NodeInfo(4)=(NodeName="MJ12Net",NodeDesc="Majestic 12 Net",NodeAddress="MAJESTIC//GLOBAL//12.12.12",NodeTexture=Texture'DeusExUI.UserInterface.ComputerLogonLogoMJ12')
	NodeInfo(5)=(NodeName="Page Industries",NodeDesc="Page Industries",NodeAddress="PAGEIND//USERWEB//NODE.34@778",NodeTexture=Texture'DeusExUI.UserInterface.ComputerLogonLogoPage')
	NodeInfo(6)=(NodeName="X-51 SecureNet",NodeDesc="X-51 SecureNet",NodeAddress="X51//SECURENET//NODE.938@893",NodeTexture=Texture'DeusExUI.UserInterface.ComputerLogonLogoArea51')
	NodeInfo(7)=(NodeName="Everett Enterprises",NodeDesc="Everett Enterprises",NodeAddress="EE//INTSYS.TT//0232.98//TERMINAL",NodeTexture=Texture'DeusExUI.UserInterface.ComputerLogonLogoEverettEnt')
	NodeInfo(8)=(NodeName="NSF",NodeDesc="National Secessionist Forces",NodeAddress="HUB//RESISTANCE.7654//NSFNODES",NodeTexture=Texture'DeusExUI.UserInterface.ComputerLogonLogoNSF')
	NodeInfo(9)=(NodeName="NYComm",NodeDesc="NYC Communications",NodeAddress="USA//DOMESTIC//NYCCOM.USERS.PUB",NodeTexture=Texture'DeusExUI.UserInterface.ComputerLogonLogoNYComm')
	NodeInfo(10)=(NodeName="PRChina",NodeDesc="Peoples Republic of China",NodeAddress="PRC//GOV//RESTRICTED.HK.562",NodeTexture=Texture'DeusExUI.UserInterface.ComputerLogonLogoPRChina')
	NodeInfo(11)=(NodeName="HKNet",NodeDesc="HK Net",NodeAddress="PUB//HKNET//USERS.ACCTS.20435//2",NodeTexture=Texture'DeusExUI.UserInterface.ComputerLogonLogoHKNet')
	NodeInfo(12)=(NodeName="Quick Stop",NodeDesc="Quick Stop",NodeAddress="PUB//HKNET//QUICKSTOPINT//NODE98",NodeTexture=Texture'DeusExUI.UserInterface.ComputerLogonLogoQuickStop')
	NodeInfo(13)=(NodeName="Lucky Money",NodeDesc="Lucky Money Club",NodeAddress="PUB//HKNET//LUCKYMONEY/BUSSYS.294",NodeTexture=Texture'DeusExUI.UserInterface.ComputerLogonLogoLuckyMoney')
	NodeInfo(14)=(NodeName="IIS",NodeDesc="Illuminati Information Systems",NodeAddress="SECURE//IIS.INFTRANS.SYS//UEU",NodeTexture=Texture'DeusExUI.UserInterface.ComputerLogonLogoIlluminati')
}
